package com.biz.crm.user.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionSelectRespVo;
import com.biz.crm.nebular.mdm.user.req.*;
import com.biz.crm.nebular.mdm.user.resp.MdmUserPageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserSelectRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserUnderlingRespVo;
import com.biz.crm.user.model.MdmUserEntity;
import com.biz.crm.user.provider.MdmUserProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * 用户信息表
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
public interface MdmUserMapper extends BaseMapper<MdmUserEntity> {

    /**
     * 列表
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "b10.position_code",orgCode = "b10.org_code")
    List<MdmUserPageRespVo> findList(Page<MdmUserPageRespVo> page, @Param("vo") MdmUserPageReqVo reqVo);

    /**
     * 列表
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SelectProvider(type = MdmUserProvider.class,method = "findListProvider")
    List<MdmUserPageRespVo> findListProvider(Page<MdmUserPageRespVo> page, @Param("vo") MdmUserPageReqVo reqVo);

    /**
     * 查询用户下属列表
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "a40.position_code")
    List<MdmUserUnderlingRespVo> findUserUnderlingList(Page<MdmUserUnderlingRespVo> page, @Param("vo") MdmUserUnderlingReqVo reqVo);

    /**
     * 用户基本信息分页查询
     * @param page page
     * @param mdmUserReqVo vo
     * @return list
     */
    List<MdmUserRespVo> pageBasic(Page<MdmUserRespVo> page, @Param("vo") MdmUserReqVo mdmUserReqVo);

    /**
     * 查询用户选择已有职位下拉框
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(orgCode = "b1.org_code",posCode = "b1.position_code")
    List<MdmPositionSelectRespVo> findUserPositionSelectList(Page<MdmPositionSelectRespVo> page, @Param("vo") MdmUserPositionSelectReqVo reqVo);

    @SqlPrivilege(orgCode = "c1.org_code",posCode = "c1.position_code")
    List<MdmPositionSelectRespVo> findUserParentPositionSelectList(Page<MdmPositionSelectRespVo> page, @Param("vo") MdmUserParentPositionSelectReqVo reqVo, @Param("excludeOrgCodeList") List<String> excludeOrgCodeList);

    /**
     * 用户下拉框
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmUserSelectRespVo> findUserSelectList(Page<MdmUserSelectRespVo> page, @Param("vo") MdmUserSelectReqVo reqVo);

    /**
     * 分页查询客户用户对应的经销商员工
     * @param page page
     * @param customerCode customerCode
     * @return list
     */
    List<MdmPositionPageRespVo> findCustomerEmployeePage(Page<MdmPositionPageRespVo> page,@Param("customerCode") String customerCode);

    /**
     * 根据职位查询用户名称
     * @param positionCodeList 职位编码集合
     * @return list
     */
    List<String> findSupplyNameList(@Param("vo") List<String> positionCodeList);
}
