package com.biz.crm.user.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationCustomerPageRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface MdmUserRelationCustomerMapper {

    /**
     * 查询未关联任何用户的客户
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmUserRelationCustomerPageRespVo> findCustomerNotRelateAnyUser(Page<MdmUserRelationCustomerPageRespVo> page, @Param("vo") MdmUserRelationCustomerPageReqVo reqVo);

    /**
     * 查询未关联当前用户的客户
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmUserRelationCustomerPageRespVo> findCustomerNotRelateCurUser(Page<MdmUserRelationCustomerPageRespVo> page, @Param("vo") MdmUserRelationCustomerPageReqVo reqVo);

    /**
     * 查询已关联当前用户的客户
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmUserRelationCustomerPageRespVo> findCustomerHasRelateCurUser(Page<MdmUserRelationCustomerPageRespVo> page, @Param("vo") MdmUserRelationCustomerPageReqVo reqVo);

}
