package com.biz.crm.user.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationTerminalPageRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface MdmUserRelationTerminalMapper {

    /**
     * 查询未关联任何用户的终端
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(
            extOrgSql = "select 1 from mdm_terminal_r_org where a1.terminal_code=terminal_code and org_code in",
            extPosSql = "select 1 from mdm_terminal_supply where terminal_code=a1.terminal_code and position_code in"
    )
    List<MdmUserRelationTerminalPageRespVo> findTerminalNotRelateAnyUser(Page<MdmUserRelationTerminalPageRespVo> page, @Param("vo") MdmUserRelationTerminalPageReqVo reqVo);

    /**
     * 查询未关联当前用户的终端
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(
            extOrgSql = "select 1 from mdm_terminal_r_org where a1.terminal_code=terminal_code and org_code in",
            extPosSql = "select 1 from mdm_terminal_supply where terminal_code=a1.terminal_code and position_code in"
    )
    List<MdmUserRelationTerminalPageRespVo> findTerminalNotRelateCurUser(Page<MdmUserRelationTerminalPageRespVo> page, @Param("vo") MdmUserRelationTerminalPageReqVo reqVo);

    /**
     * 查询已关联当前用户的终端
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(
            extOrgSql = "select 1 from mdm_terminal_r_org where a1.terminal_code=terminal_code and org_code in",
            extPosSql = "select 1 from mdm_terminal_supply where terminal_code=a1.terminal_code and position_code in"
    )
    List<MdmUserRelationTerminalPageRespVo> findTerminalHasRelateCurUser(Page<MdmUserRelationTerminalPageRespVo> page, @Param("vo") MdmUserRelationTerminalPageReqVo reqVo);

}
