package com.biz.crm.user.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserPageReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.Map;

/**
 * @Author hej
 * @Created Date 2021-01-08 11:04
 **/
public class MdmUserProvider {

    public String findListProvider(Map<String,Object> map){
        MdmUserPageReqVo vo = (MdmUserPageReqVo) map.get("vo");
        return new SQL(){{
            SELECT("b10.*");
            FROM("("+findListProviderFirstSon(vo)+") b10");
            if(StringUtils.isNotEmpty(vo.getPositionLevelCode())){
                WHERE("b10.position_level_code=#{vo.positionLevelCode}");
            }
            if(StringUtils.isNotEmpty(vo.getOrgRuleCode())){
                WHERE(" b10.org_rule_code like "+ProviderUtil.bindPercent(vo.getOrgRuleCode(),MdmProviderEnum.SQL_JOIN_RIGHT));
            }
            if(StringUtils.isNotEmpty(vo.getParentFullName())){
                WHERE("b10.parent_full_name like "+ProviderUtil.bindPercent(vo.getParentFullName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getRoleCode())){
                WHERE("(b10.position_code in (select distinct b2.position_code" +
                        "            from mdm_role b1" +
                        "            left join mdm_position_role b2 on b1.role_code = b2.role_code" +
                        "            where b1.role_code = #{vo.roleCode}" +
                        "            ))");
            }
            ORDER_BY("b10.create_date desc,b10.create_date_second desc");
        }
        }.toString();
    }

    public String findListProviderFirstSon(MdmUserPageReqVo vo){
        return new SQL(){{
            SELECT(" a10.*," +
                    "        a30.position_code," +
                    "        a30.position_name," +
                    "        a40.position_level_code," +
                    "        a40.position_level_name," +
                    "        a50.org_name," +
                    "        a50.org_code," +
                    "        a50.rule_code as org_rule_code," +
                    "        a60.position_code as parent_posotion_code," +
                    "        a60.position_name as parent_posotion_name," +
                    "        a80.user_name as parent_user_name," +
                    "        a80.full_name as parent_full_name," +
                    "        a30.role_code_redundancy as role_code," +
                    "        a30.role_name_redundancy as role_name");
            FROM("("+findListProviderSecondSon(vo)+") a10");
            LEFT_OUTER_JOIN("(select t1.id, t1.position_code, position_name, position_level_code," +
                    "        org_code,role_code_redundancy,role_name_redundancy,parent_code, t2.user_name" +
                    "        from mdm_position t1" +
                    "        left join mdm_position_user t2 on t1.position_code = t2.position_code" +
                    "        where primary_flag = '1'" +
                    "        and del_flag = '009') a30 on a30.user_name = a10.user_name ");
            LEFT_OUTER_JOIN("mdm_position_level a40 on a40.position_level_code = a30.position_level_code");
            LEFT_OUTER_JOIN("mdm_org a50 on a50.org_code = a30.org_code");
            LEFT_OUTER_JOIN("mdm_position a60 on a60.position_code = a30.parent_code");
            LEFT_OUTER_JOIN("mdm_position_user a70 on a70.position_code = a60.position_code");
            LEFT_OUTER_JOIN("mdm_user a80 on a80.user_name = a70.user_name");
        }}.toString();
    }

    public String findListProviderSecondSon(MdmUserPageReqVo vo){
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){{
            SELECT("*");
            FROM("mdm_user");
            if(StringUtils.isNotEmpty(vo.getUserType())){
                WHERE("user_type=#{vo.userType}");
            }
            if(StringUtils.isNotEmpty(vo.getGender())){
                WHERE("gender=#{vo.gender}");
            }
            if(StringUtils.isNotEmpty(vo.getEnableStatus())){
                WHERE("enable_status=#{vo.enableStatus}");
            }
            if(StringUtils.isNotEmpty(vo.getFullName())){
                WHERE("full_name like "+ ProviderUtil.bindPercent(vo.getFullName(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getUserName())){
                WHERE("user_name like "+ProviderUtil.bindPercent(vo.getUserName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getUserCode())){
                WHERE("user_code like "+ProviderUtil.bindPercent(vo.getUserCode(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, ""));
            }
        }}.toString();
    }

}
