package com.biz.crm.user.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalDetailRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmTerminalUserEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmTerminalUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmTerminalUserTerminalSelectReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmTerminalUserDetailRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmTerminalUserPageRespVo;
import com.biz.crm.user.model.MdmUserEntity;

import java.util.List;
import java.util.Map;

/**
 * 终端用户信息表接口
 * @author ql
 * @date 2021/2/3
 * @time 20:27
 **/
public interface MdmTerminalUserService extends IService<MdmUserEntity> {

    /**
     * 列表
     * @param reqVo 请求参数
     * @return PageResult<MdmTerminalUserPageRespVo>
     */
    PageResult<MdmTerminalUserPageRespVo> findList(MdmTerminalUserPageReqVo reqVo);


    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    void save(MdmTerminalUserEditReqVo reqVo);


    /**
     * 根据id或者username查询终端用户的详细信息
     * @param id id
     * @param username 终端用户的用户名
     * @return 查询出来的详细信息
     */
    MdmTerminalUserDetailRespVo queryByIdOrUsername(String id,String username);

    /**
     * 修改中的用户信息
     * @param mdmTerminalUserEditReqVo 携带的修改信息
     */
    void update(MdmTerminalUserEditReqVo mdmTerminalUserEditReqVo);


    /**
     * 根据ID集合，批量删除记录
     * @param ids 待删除的ID集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 获取终端下拉列表，如果是新增，那么需要返回没有被用户关联的终端
     * 如果是编辑，前端需要将当前编辑的用户名传过来，然后将当前用户已经关联的终端放在前面
     * @param reqVo 请求vo
     * @return 未被用户绑定的终端
     */
    List<MdmTerminalDetailRespVo> getTerminalListByCondition(MdmTerminalUserTerminalSelectReqVo reqVo);

}
