package com.biz.crm.user.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelWeChatReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelWeChatRespVo;
import com.biz.crm.user.model.MdmUserRelWeChatEntity;

import java.util.List;

/**
 * 用户关联微信接口
 *
 * @author Tao.Chen
 * @date 2021-02-19 11:47:07
 */
public interface MdmUserRelWeChatService extends IService<MdmUserRelWeChatEntity> {

    /**
     * 绑定用户与微信
     *
     * @param reqVo
     */
    void bind(MdmUserRelWeChatReqVo reqVo);

    /**
     * 绑定用户与微信
     *
     * @param originModule
     * @param openId
     */
    void unbindByOpenId(String originModule, String openId);

    /**
     * 根据关联表id解除关联关系，并退出登录
     *
     * @param ids
     */
    void unbindByIds(List<String> ids);

    /**
     * 解除用户关联的所有微信，并退出登录
     *
     * @param userNameList
     */
    void unbindByUserName(List<String> userNameList);

    /**
     * 修改登录状态
     *
     * @param originModule
     * @param openId
     * @param loginStatus
     */
    void changeLoginStatus(String originModule, String openId,String loginStatus);

    /**
     * 查询用户关联微信列表
     *
     * @param reqVo
     * @return
     */
    List<MdmUserRelWeChatRespVo> findUserRelWeChatList(MdmUserRelWeChatReqVo reqVo);

    /**
     * 查询绑定的用户
     *
     * @param openId       openId
     * @param originModule 来源模块
     * @return
     */
    List<MdmUserRelWeChatRespVo> getBindUserListByOpenId(String openId, String originModule);

    /**
     * 查询用户绑定的微信
     *
     * @param userName     登录名
     * @param originModule 来源模块
     * @return
     */
    List<MdmUserRelWeChatRespVo> getBindWeChatListByUserName(String userName, String originModule);

    /**
     * 验证号码并绑定微信openid
     * @param bindReq
     * @param phone
     * @param code
     */
    void bindUserWeChatVerificationPhone(MdmUserRelWeChatReqVo bindReq, String phone, String code);
}

