package com.biz.crm.user.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationCustomerPageRespVo;

public interface MdmUserRelationCustomerService {

    /**
     * 查询未关联任何用户的客户
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmUserRelationCustomerPageRespVo> findCustomerNotRelateAnyUser(MdmUserRelationCustomerPageReqVo reqVo);

    /**
     * 查询为关联当前用户的客户
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmUserRelationCustomerPageRespVo> findCustomerNotRelateCurUser(MdmUserRelationCustomerPageReqVo reqVo);

    /**
     * 查询已关联当前用户的客户
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmUserRelationCustomerPageRespVo> findCustomerHasRelateCurUser(MdmUserRelationCustomerPageReqVo reqVo);


}
