package com.biz.crm.user.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationTerminalPageRespVo;

public interface MdmUserRelationTerminalService {

    /**
     * 查询未关联任何用户的终端
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmUserRelationTerminalPageRespVo> findTerminalNotRelateAnyUser(MdmUserRelationTerminalPageReqVo reqVo);

    /**
     * 查询未关联当前用户的终端
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmUserRelationTerminalPageRespVo> findTerminalNotRelateCurUser(MdmUserRelationTerminalPageReqVo reqVo);

    /**
     * 查询已关联当前用户的终端
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmUserRelationTerminalPageRespVo> findTerminalHasRelateCurUser(MdmUserRelationTerminalPageReqVo reqVo);


}
