package com.biz.crm.user.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.position.req.MdmPositionCurrentUserReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionSelectRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.req.*;
import com.biz.crm.nebular.mdm.user.resp.MdmUserPageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserSelectRespVo;
import com.biz.crm.user.model.MdmUserEntity;

import java.util.List;

/**
 * 用户信息表接口
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
public interface MdmUserService extends IService<MdmUserEntity> {

    /**
     * 列表
     *
     * @param reqVo
     * @return PageResult<MdmUserRespVo>
     */
    PageResult<MdmUserPageRespVo> findList(MdmUserPageReqVo reqVo);

    /**
     * 查询
     *
     * @param mdmUserReqVo
     * @return MdmUserRespVo
     */
    @Deprecated
    MdmUserRespVo query(MdmUserReqVo mdmUserReqVo);

    /**
     * 根据id或者用户登录名查询用户详情
     *
     * @param id
     * @param userName
     * @return
     */
    MdmUserRespVo detail(String id, String userName);

    /**
     * 根据用户名精确查询用户主表信息
     *
     * @param userName
     * @return
     */
    MdmUserRespVo queryByUserName(String userName);

    /**
     * 根据登录名集合查询用户主表信息
     *
     * @param userNameList
     * @return
     */
    List<MdmUserRespVo> queryBatchByUserNameList(List<String> userNameList);

    /**
     * 根据用户编码精确查询用户主表信息
     *
     * @param userCode
     * @return
     */
    MdmUserRespVo queryByUserCode(String userCode);

    /**
     * 根据用户登录名获取姓名
     *
     * @param userName
     * @return
     */
    String getFullNameByUserName(String userName);

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    void save(MdmUserEditReqVo reqVo);

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    void update(MdmUserEditReqVo reqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    @Deprecated
    void deleteBatch(MdmUserReqVo mdmUserReqVo);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);
    @Deprecated
    void enableBatch(MdmUserReqVo mdmUserReqVo);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
    @Deprecated
    void disableBatch(MdmUserReqVo mdmUserReqVo);

    /**
     * 修改密码
     *
     * @param reqVo
     */
    void changePassword(MdmUserChangePasswordReqVo reqVo);

    /**
     * 重新设置自己的密码
     *
     * @param reqVo
     */
    void resetMyselfPassword(MdmUserChangePasswordReqVo reqVo);

    /**
     * 解锁
     *
     * @param ids
     */
    void unlock(List<String> ids);
    @Deprecated
    void unlock(MdmUserReqVo reqVo);

    /**
     * 解绑微信
     *
     * @param ids
     */
    void unbindWeChat(List<String> ids);

    /**
     * 强制批量修改密码
     *
     * @param reqVo
     */
    void forceChangePassword(MdmUserForceChangePasswordReqVo reqVo);


    /**
     * 查询用户基本信息
     *
     * @param mdmUserReqVo vo
     * @return vo
     */
    MdmUserRespVo queryBasic(MdmUserReqVo mdmUserReqVo);

    PageResult<MdmUserRespVo> pageBasic(MdmUserReqVo mdmUserReqVo);

    /**
     * 用户条件列表查询
     *
     * @param mdmUserReqVo vo
     * @return list
     */
    List<MdmUserRespVo> listDetail(MdmUserReqVo mdmUserReqVo);

    /**
     * 获取当前登录用户的当前职位关联的个人信息详情
     *
     * @return
     */
    MdmPositionUserOrgRespVo getCurUserPositionDetail();

    /**
     * 修改用户头像
     *
     * @param reqVo
     */
    void changeUserHeadUrl(MdmUserChangeHeadReqVo reqVo);

    /**
     * 查询用户选择已有职位下拉框
     *
     * @param reqVo
     * @return
     */
    List<MdmPositionSelectRespVo> findUserPositionSelectList(MdmUserPositionSelectReqVo reqVo);

    List<MdmPositionSelectRespVo> findUserParentPositionSelectList(MdmUserParentPositionSelectReqVo reqVo);

    /**
     * 企业用户下拉框
     *
     * @param reqVo
     * @return
     */
    List<MdmUserSelectRespVo> findUserSelectList(MdmUserSelectReqVo reqVo);

    /**
     * 获取用户信息（仅用于登录校验）
     * 参数任意传一个，优先级 账号>手机号>邮箱
     *
     * @param userName  登录账号
     * @param userPhone 手机号
     * @param email     邮箱
     * @return
     */
    MdmUserRespVo getUserForLogin(String userName, String userPhone, String email);

    /**
     * 设置用户需要在下次登录时候强制修改密码
     *
     * @param userName 登录账号
     */
    void setUserForceChangePassword(String userName);

    /**
     * 设置用户登录时间
     *
     * @param userName      用户账号
     * @param loginDateTime 登录时间
     */
    void updateUserLastLoginDateTime(String userName, String loginDateTime);

    /**
     * 查询客户用户管理的经销商员工用户
     * @param reqVo vo
     * @return list
     */
    List<MdmPositionPageRespVo> findCustomerEmployeePage(MdmPositionCurrentUserReqVo reqVo);

    /**
     * 修改密码
     *
     * @param userName 登录账号
     * @param password 新密码
     */
    void editPassword(String userName, String password);
}

