package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.TerminalSupplyTypeEnum;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalSupplyDetailVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserTerminalEditReqVo;
import com.biz.crm.terminal.model.MdmTerminalSupplyDetailEntity;
import com.biz.crm.terminal.model.MdmTerminalSupplyEntity;
import com.biz.crm.user.mapper.MdmUserRelTerminalMapper;
import com.biz.crm.user.model.MdmTerminalRelRoleEntity;
import com.biz.crm.user.model.MdmUserRelTerminalEntity;
import com.biz.crm.user.service.MdmTerminalRelRoleService;
import com.biz.crm.user.service.MdmUserRelTerminalService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import javax.annotation.Resource;
import jodd.util.ArraysUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/**
 * @author ql
 * @date 2021/2/4
 * @time 18:18
 * 终端用户和终端关系关联service实现
 **/
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmUserRelTerminalServiceImpl")
public class MdmUserRelTerminalServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmUserRelTerminalMapper, MdmUserRelTerminalEntity> implements MdmUserRelTerminalService {

    @Resource
    private MdmTerminalRelRoleService mdmTerminalRelRoleService;
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void add(String userName, String terminalCode) {
        if (StringUtils.isNotEmpty(userName) && StringUtils.isNotEmpty(terminalCode)) {
            List<MdmUserTerminalEditReqVo> editReqVos = new ArrayList<>();
            MdmUserTerminalEditReqVo editReqVo = new MdmUserTerminalEditReqVo();
            editReqVo.setTerminalCode(terminalCode);
            editReqVos.add(editReqVo);
            this.add(userName, editReqVos);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void add(String userName, String terminalCode, String currentFlag) {
        if (StringUtils.isNotEmpty(userName) && StringUtils.isNotEmpty(terminalCode)) {
            if (StringUtils.isEmpty(currentFlag)) {
                currentFlag = YesNoEnum.yesNoEnum.ZERO.getValue();
            } else if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(currentFlag) && !YesNoEnum.yesNoEnum.ZERO.getValue().equals(currentFlag)) {
                throw new BusinessException("currentFlag参数不合法");
            } else {

            }
            MdmUserRelTerminalEntity one = this.lambdaQuery()
                    .eq(MdmUserRelTerminalEntity::getUserName, userName)
                    .eq(MdmUserRelTerminalEntity::getTerminalCode, terminalCode)
                    .one();
            if (one == null) {
                MdmUserRelTerminalEntity entity = new MdmUserRelTerminalEntity();
                entity.setUserName(userName);
                entity.setTerminalCode(terminalCode);
                entity.setCurrentFlag(currentFlag);
                this.save(entity);
            } else {
                if (currentFlag.equals(one.getCurrentFlag())) {
                    this.lambdaUpdate()
                            .eq(MdmUserRelTerminalEntity::getUserName, userName)
                            .eq(MdmUserRelTerminalEntity::getTerminalCode, terminalCode)
                            .set(MdmUserRelTerminalEntity::getCurrentFlag, currentFlag)
                            .update();
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void add(String userName, List<MdmUserTerminalEditReqVo> reqVoList) {
      /*  if (StringUtils.isNotEmpty(userName) && CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList)) {
            Set<String> existCodeSet = this.lambdaQuery()
                    .eq(MdmUserRelTerminalEntity::getUserName, userName)
                    .in(MdmUserRelTerminalEntity::getTerminalCode, terminalCodeList)
                    .select(MdmUserRelTerminalEntity::getTerminalCode)
                    .list()
                    .stream().map(MdmUserRelTerminalEntity::getTerminalCode).collect(Collectors.toSet());
            Set<String> terminalCodeSet = new HashSet<>(terminalCodeList);
            List<MdmUserRelTerminalEntity> entityList = new ArrayList<>();
            for (String terminalCode :
                    terminalCodeSet) {
                if (existCodeSet.contains(terminalCode)) {
                    continue;
                }
                MdmUserRelTerminalEntity entity = new MdmUserRelTerminalEntity();
                entity.setUserName(userName);
                entity.setTerminalCode(terminalCode);
                entity.setCurrentFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
                entityList.add(entity);
            }
            if (entityList.size() > 0) {
                this.saveBatch(entityList);
            }
        }*/
        Assert.hasText(userName, "用户编码不能为空");
        List<MdmUserRelTerminalEntity> list = this.lambdaQuery()
            .eq(MdmUserRelTerminalEntity::getUserName, userName)
            .select(MdmUserRelTerminalEntity::getId)
            .list();
        if (!CollectionUtils.isEmpty(list)) {
            List<String> userRelIds = list.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            mdmTerminalRelRoleService.lambdaUpdate()
                .in(MdmTerminalRelRoleEntity::getUserRelId, userRelIds)
                .remove();
        }
        this.lambdaUpdate()
            .eq(MdmUserRelTerminalEntity::getUserName, userName)
            .remove();
        if (CollectionUtil.listEmpty(reqVoList)) {
            return;
        }
        if (!CollectionUtils.isEmpty(reqVoList)) {
            for (MdmUserTerminalEditReqVo editReqVo :
                reqVoList) {
                MdmUserRelTerminalEntity entity = new MdmUserRelTerminalEntity();
                entity.setUserName(userName);
                entity.setTerminalCode(editReqVo.getTerminalCode());
                entity.setCurrentFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
                entity.setId(UUID.randomUUID().toString());
                List<String> roleCodeList = editReqVo.getRoleCodeList();
               List<MdmTerminalRelRoleEntity> terminalRelRoleEntityList = new ArrayList<>();
                if(CollectionUtil.listNotEmpty(roleCodeList)){
                    for (String roleCode :
                        roleCodeList) {
                        MdmTerminalRelRoleEntity relRoleEntity = new MdmTerminalRelRoleEntity();
                        relRoleEntity.setRoleCode(roleCode);
                        relRoleEntity.setTerminalCode(editReqVo.getTerminalCode());
                        relRoleEntity.setUserRelId(entity.getId());
                        terminalRelRoleEntityList.add(relRoleEntity);
                    }
                    if(terminalRelRoleEntityList.size()>0){
                       mdmTerminalRelRoleService.saveBatch(terminalRelRoleEntityList);
                    }
                }
                this.save(entity);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void add(List<String> userNameList, String terminalCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList) && StringUtils.isNotEmpty(terminalCode)) {
            Set<String> existCodeSet = this.lambdaQuery()
                    .eq(MdmUserRelTerminalEntity::getTerminalCode, terminalCode)
                    .in(MdmUserRelTerminalEntity::getUserName, userNameList)
                    .select(MdmUserRelTerminalEntity::getUserName)
                    .list()
                    .stream().map(MdmUserRelTerminalEntity::getUserName).collect(Collectors.toSet());
            Set<String> userNameSet = new HashSet<>(userNameList);
            List<MdmUserRelTerminalEntity> entityList = new ArrayList<>();
            for (String userName :
                    userNameSet) {
                if (existCodeSet.contains(userName)) {
                    continue;
                }
                MdmUserRelTerminalEntity entity = new MdmUserRelTerminalEntity();
                entity.setUserName(userName);
                entity.setTerminalCode(terminalCode);
                entity.setCurrentFlag(YesNoEnum.yesNoEnum.ZERO.getValue());
                entityList.add(entity);
            }
            if (entityList.size() > 0) {
                this.saveBatch(entityList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void del(String userName, String terminalCode) {
        if (StringUtils.isNotEmpty(userName) && StringUtils.isNotEmpty(terminalCode)) {
            this.del(userName, Collections.singletonList(terminalCode));
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void del(String userName, List<String> terminalCodeList) {
        if (StringUtils.isNotEmpty(userName) && CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList)) {
            this.lambdaUpdate()
                    .eq(MdmUserRelTerminalEntity::getUserName, userName)
                    .in(MdmUserRelTerminalEntity::getTerminalCode, terminalCodeList)
                    .remove();
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void del(List<String> userNameList, String terminalCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList) && StringUtils.isNotEmpty(terminalCode)) {
            this.lambdaUpdate()
                    .eq(MdmUserRelTerminalEntity::getTerminalCode, terminalCode)
                    .in(MdmUserRelTerminalEntity::getUserName, userNameList)
                    .remove();
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delByUserName(String userName) {
        if (StringUtils.isNotEmpty(userName)) {
            this.delByUserName(Collections.singletonList(userName));
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delByUserName(List<String> userNameList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList)) {
            this.lambdaUpdate()
                    .in(MdmUserRelTerminalEntity::getUserName, userNameList)
                    .remove();
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delByTerminalCode(String terminalCode) {
        if (StringUtils.isNotEmpty(terminalCode)) {
            this.delByTerminalCode(Collections.singletonList(terminalCode));
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delByTerminalCode(List<String> terminalCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(terminalCodeList)) {
            this.lambdaUpdate()
                    .in(MdmUserRelTerminalEntity::getTerminalCode, terminalCodeList)
                    .remove();
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void setUniqueCurrentTerminalIfExist(String userName, String terminalCode) {
        if (StringUtils.isNotEmpty(userName) && StringUtils.isNotEmpty(terminalCode)) {
            this.lambdaUpdate()
                    .eq(MdmUserRelTerminalEntity::getUserName, userName)
                    .set(MdmUserRelTerminalEntity::getCurrentFlag, YesNoEnum.yesNoEnum.ZERO.getValue())
                    .update();
            this.lambdaUpdate()
                    .eq(MdmUserRelTerminalEntity::getUserName, userName)
                    .eq(MdmUserRelTerminalEntity::getTerminalCode, terminalCode)
                    .set(MdmUserRelTerminalEntity::getCurrentFlag, YesNoEnum.yesNoEnum.ONE.getValue())
                    .update();
        }
    }

    @Override
    public List<MdmUserRelTerminalEntity> findTerminalCodeListByUserName(String userName) {
        if (StringUtils.isNotEmpty(userName)) {
            return this.lambdaQuery()
                    .eq(MdmUserRelTerminalEntity::getUserName, userName)
                    .select(MdmUserRelTerminalEntity::getTerminalCode,MdmUserRelTerminalEntity::getId)
                    .list();
        }
        return new ArrayList<>();
    }

    @Override
    public Map<String, List<String>> getTerminalCodeListGroupByUserNameList(List<String> userNameList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList)) {
            Map<String, List<String>> map = new HashMap<>(16);
            List<List<String>> listGroup = Lists.partition(userNameList, 500);
            for (List<String> group :
                    listGroup) {
                List<MdmUserRelTerminalEntity> list = this.lambdaQuery()
                        .in(MdmUserRelTerminalEntity::getUserName, group)
                        .select(MdmUserRelTerminalEntity::getUserName, MdmUserRelTerminalEntity::getTerminalCode)
                        .list();
                if (list.size() > 0) {
                    map.putAll(list.stream().collect(Collectors.groupingBy(MdmUserRelTerminalEntity::getUserName, Collectors.mapping(MdmUserRelTerminalEntity::getTerminalCode, Collectors.toList()))));
                }
            }
            return map;
        }
        return Collections.emptyMap();
    }

}
