package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.customer.service.MdmCustomerSupplyService;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationCustomerPageRespVo;
import com.biz.crm.position.model.MdmCustomerSupplyEntity;
import com.biz.crm.user.mapper.MdmUserRelationCustomerMapper;
import com.biz.crm.user.service.MdmUserRelationCustomerService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@ConditionalOnMissingBean(name = "MdmUserRelationCustomerServiceExpandImpl")
public class MdmUserRelationCustomerServiceImpl implements MdmUserRelationCustomerService {

    @Resource
    private MdmUserRelationCustomerMapper mdmUserRelationCustomerMapper;
    @Resource
    private MdmCustomerSupplyService mdmCustomerSupplyService;
    @Resource
    private MdmCustomerROrgService mdmCustomerROrgService;


    @Override
    public PageResult<MdmUserRelationCustomerPageRespVo> findCustomerNotRelateAnyUser(MdmUserRelationCustomerPageReqVo reqVo) {
        Page<MdmUserRelationCustomerPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmUserRelationCustomerPageRespVo> list = mdmUserRelationCustomerMapper.findCustomerNotRelateAnyUser(page, reqVo);
        setOrgName(list);
        return PageResult.<MdmUserRelationCustomerPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<MdmUserRelationCustomerPageRespVo> findCustomerNotRelateCurUser(MdmUserRelationCustomerPageReqVo reqVo) {
        Page<MdmUserRelationCustomerPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        Assert.hasText(reqVo.getUserName(), "缺失用户名");
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmUserRelationCustomerPageRespVo> list = mdmUserRelationCustomerMapper.findCustomerNotRelateCurUser(page, reqVo);
        setOrgName(list);
        setPositionCodeName(list);
        return PageResult.<MdmUserRelationCustomerPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<MdmUserRelationCustomerPageRespVo> findCustomerHasRelateCurUser(MdmUserRelationCustomerPageReqVo reqVo) {
        Page<MdmUserRelationCustomerPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmUserRelationCustomerPageRespVo> list = mdmUserRelationCustomerMapper.findCustomerHasRelateCurUser(page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> {
                item.setId(item.getSupplyId());
            });
        }
        setOrgName(list);
        Assert.hasText(reqVo.getUserName(), "缺失用户名");
        return PageResult.<MdmUserRelationCustomerPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    protected void setOrgName(List<MdmUserRelationCustomerPageRespVo> list) {
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        final Map<String, List<MdmOrgRespVo>> map = mdmCustomerROrgService.findOrgGroupByCustomerCodeList(list.stream().map(MdmUserRelationCustomerPageRespVo::getCustomerCode).collect(Collectors.toList()));
        list.forEach(item -> {
            if (map.containsKey(item.getCustomerCode())) {
                List<MdmOrgRespVo> orgList = map.get(item.getCustomerCode());
                item.setOrgName(orgList.stream().map(MdmOrgRespVo::getOrgName).collect(Collectors.joining(",")));
            }
        });
    }

    protected void setPositionCodeName(List<MdmUserRelationCustomerPageRespVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<String> customerCodeList = list.stream().map(MdmUserRelationCustomerPageRespVo::getCustomerCode).collect(Collectors.toList());
            List<MdmCustomerDockingRespVo> customerSupplyList = mdmCustomerSupplyService.findCustomerSupplyByCustomerCodeList(customerCodeList);
            List<String> positionCodeList = customerSupplyList.stream().map(MdmCustomerDockingRespVo::getPositionCode).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
                final Map<String, MdmPositionRespVo> positionMap = PositionUtil.getPositionByCodeList(positionCodeList)
                        .stream()
                        .collect(Collectors.toMap(MdmPositionRespVo::getPositionCode, v -> v));
                if (!positionMap.isEmpty()) {
                    final Map<String, List<String>> collect = customerSupplyList.stream().filter(item -> StringUtils.isNotEmpty(item.getPositionCode())).collect(Collectors.groupingBy(MdmCustomerDockingRespVo::getCustomerCode, Collectors.mapping(MdmCustomerDockingRespVo::getPositionCode, Collectors.toList())));
                    list.forEach(item -> {
                        if (collect.containsKey(item.getCustomerCode())) {
                            List<String> positionCodeListInThisCustomer = collect.get(item.getCustomerCode());
                            List<MdmPositionRespVo> positionListInThisCustomer = new ArrayList<>();
                            for (String positionCode :
                                    positionCodeListInThisCustomer) {
                                if (positionMap.containsKey(positionCode)) {
                                    positionListInThisCustomer.add(positionMap.get(positionCode));
                                }
                            }
                            item.setPositionCode(positionListInThisCustomer.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.joining(",")));
                            item.setPositionName(positionListInThisCustomer.stream().map(MdmPositionRespVo::getPositionName).collect(Collectors.joining(",")));
                        }
                    });
                }
            }
        }
    }
}
