package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserUnderlingReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserUnderlingRespVo;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.user.mapper.MdmUserMapper;
import com.biz.crm.user.service.MdmUserUnderlingService;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 用户信息表接口实现
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmUserUnderlingServiceExpandImpl")
public class MdmUserUnderlingServiceImpl implements MdmUserUnderlingService {

    @Resource
    private MdmUserMapper mdmUserMapper;

    @Resource
    private MdmPositionService mdmPositionService;

    @Override
    public PageResult<MdmUserUnderlingRespVo> findUserUnderlingList(MdmUserUnderlingReqVo reqVo) {
        Assert.hasText(reqVo.getUserName(),"用户名必传");
        Page<MdmUserUnderlingRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<MdmUserUnderlingRespVo> list = mdmUserMapper.findUserUnderlingList(page, reqVo);
        return PageResult.<MdmUserUnderlingRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void replaceParentPosition(MdmUserUnderlingReqVo reqVo) {

        Assert.notEmpty(reqVo.getUnderlingPositionCodeList(), "请选择下级职位");
        Assert.hasText(reqVo.getPositionCode(), "请选择上级职位");
        MdmPositionRespVo parentPosition = mdmPositionService.queryByPositionCode(reqVo.getPositionCode());

        Assert.notNull(parentPosition, "上级职位不存在");

        //查询所选上级职位的全部上级
        List<MdmPositionRespVo> parentList = mdmPositionService.findAllParentPositionList(parentPosition.getId(), null);
        List<String> parentCodeList = parentList.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());

        reqVo.getUnderlingPositionCodeList().forEach(positionCode -> {
            Assert.hasText(positionCode, "不能传空值");
            MdmPositionRespVo position = mdmPositionService.queryByPositionCode(positionCode);
            Assert.notNull(position, "无效的下级职位" + positionCode);
            Assert.isTrue(!parentCodeList.contains(positionCode), "所选职位" + parentPosition.getPositionName() + "是" + position.getPositionName() + "的下级职位，不能选择作为上级");
            mdmPositionService.changePositionParent(positionCode, reqVo.getPositionCode());
        });
    }
}
