package com.biz.crm.utils;

import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

/**
 * 聚合不查询数据分页
 *
 * @author zxw
 * @date 2021-05-28 16:29
 **/
public class EsEmptyAggregationPage implements Pageable {

    public static EsEmptyAggregationPage getInstance() {
        return InnerEsAggregationPage.INSTANCE;
    }

    private static class InnerEsAggregationPage{
        public static final EsEmptyAggregationPage INSTANCE = new EsEmptyAggregationPage();
    }
    @Override
    public int getPageNumber() {
        return 0;
    }

    @Override
    public int getPageSize() {
        return 0;
    }

    @Override
    public long getOffset() {
        return 0;
    }

    @Override
    public Sort getSort() {
        return null;
    }

    @Override
    public Pageable next() {
        return null;
    }

    @Override
    public Pageable previousOrFirst() {
        return null;
    }

    @Override
    public Pageable first() {
        return null;
    }

    @Override
    public boolean hasPrevious() {
        return false;
    }
}
