package com.biz.crm.utils;

import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;

import java.security.InvalidParameterException;
import java.util.Map;
import java.util.StringJoiner;

/**
 * @author zxw
 * @date 2021-05-26 15:12
 * ctx._source.enableStatus=params.enableStatus
 **/
public class EsScriptBuilder {

    public static Script updateScript(Map<String, Object> map) {
        if (map == null || map.size() < 1) {
            throw new InvalidParameterException("parameter not allowed empty");
        }
        StringJoiner source = new StringJoiner(";");
        for (String key : map.keySet()) {
            //拼接source
            StringBuilder sb = new StringBuilder();
            sb.append("ctx._source.");
            sb.append(key);
            sb.append("=params.");
            sb.append(key);
            source.add(sb);
            //拼接params
        }
        return new Script(ScriptType.INLINE, Script.DEFAULT_SCRIPT_LANG, source.toString(), map);
    }
}
