package com.biz.crm.utils;


import com.biz.crm.availablelist.entity.CusAvailablelistEntity;
import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.availablelistrule.entity.AvailableListRuleEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleAreaVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleGoodsVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAndOrgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.util.Asserts;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 可购商品单条同步es
 * @author rwm
 * @date 2022-04-01
 */

@Slf4j
@Component
public class EsSynchronismUtil {

    @Autowired
    private MdmProductService mdmProductService;

    @Autowired
    private CusAvailablelistService cusAvailablelistService;

    @Autowired
    private MdmCustomerMsgService mdmCustomerMsgService;

    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public void addEs(AvailableListRuleVo availableListRuleVo, String ruleCode){
        log.info("新增可购规则后开始同步es信息----");

        if (CollectionUtils.isEmpty(availableListRuleVo.getAreaes())||CollectionUtils.isEmpty(availableListRuleVo.getGoods())){
            return;
        }

        //保存成功后将新增信息同步到es中
        //获取商品信息编码
        List<AvailableListRuleGoodsVo> goodsCodes = availableListRuleVo.getGoods();
        //商品编码
        List<String> goodsCodeList=goodsCodes.stream().map(AvailableListRuleGoodsVo::getGoodsCode).collect(Collectors.toList());
        //商品层级编码
        List<String> goodsLevelCodeList=goodsCodes.stream().map(AvailableListRuleGoodsVo::getProductLevelCode).collect(Collectors.toList());
        List<MdmProductRespVo> mdmProductRespVos = mdmProductService.queryBatchByProductLevelCodeList(goodsLevelCodeList);
        List<String> goodsCodeLists=mdmProductRespVos.stream().map(MdmProductRespVo::getProductCode).collect(Collectors.toList());
        //得到完整的es同步商品信息
        List<MdmProductAdviseRespVo> goods= Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(goodsCodeList)){
            goods=mdmProductService.adviseQuery(goodsCodeList);
        }else {
            goods=mdmProductService.adviseQuery(goodsCodeLists);
        }

        //获得客户编码信息
        List<AvailableListRuleAreaVo> areaes = availableListRuleVo.getAreaes();
        //客户
        List<String> cusCodes=areaes.stream().map(o->o.getCusCode()).collect(Collectors.toList());
        //组织（客户）
        List<String> orgCodeLists=areaes.stream().map(AvailableListRuleAreaVo::getOrgCode).collect(Collectors.toList());
        MdmCustomerAndOrgReqVo customerAndOrgReqVo=new MdmCustomerAndOrgReqVo();
        customerAndOrgReqVo.setOrgCodeList(orgCodeLists);
        List<String> cusCodeOrgLists=mdmCustomerMsgService.findCurrentAndSubCustomerList(customerAndOrgReqVo)
                .stream().map(MdmCustomerMsgRespVo::getCustomerCode)
                .collect(Collectors.toList());

        if (StringUtils.isNotEmpty(cusCodes.get(0))){
            for (String cusCode : cusCodes) {
                cusAvailablelistService.syncCusAvailableList(goods,cusCode,ruleCode);
            }
        }else {
            for (String cusCode : cusCodeOrgLists) {
                cusAvailablelistService.syncCusAvailableList(goods,cusCode,ruleCode);
            }
        }

        log.info("客户可购商品列表信息同步完成-----");
    }
    public void editEs(AvailableListRuleVo availableListRuleVo){
        log.info("编辑可购规则后开始同步es信息----");

        //保存成功后将新增信息同步到es中
        //获取商品信息编码
        List<AvailableListRuleGoodsVo> goodsCodes = availableListRuleVo.getGoods();
        //商品编码
        List<String> goodsCodeList=goodsCodes.stream().map(AvailableListRuleGoodsVo::getGoodsCode).collect(Collectors.toList());
        //商品层级编码
        List<String> goodsLevelCodeList=goodsCodes.stream().map(AvailableListRuleGoodsVo::getProductLevelCode).collect(Collectors.toList());
        List<MdmProductRespVo> mdmProductRespVos = mdmProductService.queryBatchByProductLevelCodeList(goodsLevelCodeList);
        List<String> goodsCodeLists=mdmProductRespVos.stream().map(MdmProductRespVo::getProductCode).collect(Collectors.toList());
        //得到完整的es同步商品信息
        List<MdmProductAdviseRespVo> goods= Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(goodsCodeList)){
            goods=mdmProductService.adviseQuery(goodsCodeList);
        }else {
            goods=mdmProductService.adviseQuery(goodsCodeLists);
        }

        //获得客户编码信息
        List<AvailableListRuleAreaVo> areaes = availableListRuleVo.getAreaes();
        //客户
        List<String> cusCodes=areaes.stream().map(o->o.getCusCode()).collect(Collectors.toList());
        //组织（客户）
        List<String> orgCodeLists=areaes.stream().map(AvailableListRuleAreaVo::getOrgCode).collect(Collectors.toList());
        MdmCustomerAndOrgReqVo customerAndOrgReqVo=new MdmCustomerAndOrgReqVo();
        customerAndOrgReqVo.setOrgCodeList(orgCodeLists);
        List<String> cusCodeOrgLists=mdmCustomerMsgService.findCurrentAndSubCustomerList(customerAndOrgReqVo)
                .stream().map(MdmCustomerMsgRespVo::getCustomerCode)
                .collect(Collectors.toList());


        DeleteQuery deleteQuery = new DeleteQuery();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must(QueryBuilders.termQuery("availableRuleCode.keyword", availableListRuleVo.getRuleCode()));
        deleteQuery.setQuery(boolQueryBuilder);
        elasticsearchTemplate.delete(deleteQuery, CusAvailablelistEntity.class);
        elasticsearchTemplate.refresh(MdmConstant.ES_CUSAVAILABLELIST_INDEXNAME);
        log.info("执行删除[{}]***************\r\n", availableListRuleVo.getRuleCode());
        if (StringUtils.isNotEmpty(cusCodes.get(0))){
            for (String cusCode : cusCodes) {
                cusAvailablelistService.editSyncCusAvailableList(goods,cusCode,availableListRuleVo.getRuleCode());
            }
        }else {
            for (String cusCode : cusCodeOrgLists) {
                cusAvailablelistService.editSyncCusAvailableList(goods,cusCode,availableListRuleVo.getRuleCode());
            }
        }
        log.info("客户可购商品列表信息同步完成-----");

    }

}
