/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.availablelist.utils;

import com.biz.crm.availablelist.entity.CusAvailablelistEntity;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class CusAvailablelistUtil {
    public static List<CusAvailablelistEntity> packageEntities(List<MdmProductAdviseRespVo> goodsList, MdmCustomerMsgRespVo customerMsgRespVo, List<String> ofenGoodsCodes, Map<String, Boolean> promotionMap) {
        ArrayList<CusAvailablelistEntity> reList = new ArrayList<CusAvailablelistEntity>(goodsList.size());
        HashSet<Object> ofens = new HashSet();
        if (!CollectionUtils.isEmpty(ofenGoodsCodes)) {
            ofens = new HashSet<String>(ofenGoodsCodes);
        }
        for (MdmProductAdviseRespVo goods : goodsList) {
            CusAvailablelistEntity entity = new CusAvailablelistEntity();
            BeanUtils.copyProperties((Object)goods, (Object)((Object)entity));
            entity.setId(UUIDGenerator.generate());
            entity.setCusCode(customerMsgRespVo.getCustomerCode());
            entity.setCusName(customerMsgRespVo.getCustomerName());
            entity.setCusOrgCode(customerMsgRespVo.getOrgCode());
            entity.setCusOrgName(customerMsgRespVo.getOrgName());
            entity.setCusChannelCode(customerMsgRespVo.getChannel());
            entity.setCusChannelName(customerMsgRespVo.getChannelName());
            entity.setOfenFlag(ofens.contains(entity.getProductCode()) ? YesNoEnum.YesNoCodeNumberEnum.YES.getCode() : YesNoEnum.YesNoCodeNumberEnum.NO.getCode());
            Boolean promotionFlag = promotionMap.get(entity.getProductCode());
            entity.setPromotionFlag(promotionFlag == null || promotionFlag == false ? YesNoEnum.YesNoCodeNumberEnum.NO.getCode() : YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
            entity.setCus(customerMsgRespVo);
            entity.setUpdateDate(DateUtil.dateNow2Str());
            entity.setUpdateDateSecond(DateUtil.dateNowStrHms());
            reList.add(entity);
        }
        return reList;
    }

    public static CusAvailablelistEntity copyGoodsVo(CusAvailablelistEntity entity, MdmProductAdviseRespVo vo) {
        if (null == vo) {
            return entity;
        }
        String id = entity.getId();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
        entity.setId(id);
        return entity;
    }
}

