/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.bpmrole.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.bpmrole.mapper.MdmBpmRoleMapper;
import com.biz.crm.bpmrole.model.MdmBpmRoleEntity;
import com.biz.crm.bpmrole.service.MdmBpmRoleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleReqVo;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleSelectReqVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRedisRespVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleSelectRespVo;
import com.biz.crm.position.service.MdmPositionBpmRoleService;
import com.biz.crm.util.BpmRoleUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmBpmRoleServiceExpandImpl"})
public class MdmBpmRoleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmBpmRoleMapper, MdmBpmRoleEntity>
implements MdmBpmRoleService {
    private static final Logger log = LoggerFactory.getLogger(MdmBpmRoleServiceImpl.class);
    @Resource
    private MdmBpmRoleMapper mdmBpmRoleMapper;
    @Resource
    private MdmPositionBpmRoleService mdmPositionBpmRoleService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    @Resource
    private RocketMQProducer rocketMQProducer;

    @Override
    public PageResult<MdmBpmRoleRespVo> findList(MdmBpmRoleReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmBpmRoleRespVo> list = this.mdmBpmRoleMapper.findList((Page<MdmBpmRoleRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmBpmRoleRespVo detail(String id, String bpmRoleCode) {
        MdmBpmRoleEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)bpmRoleCode)) && (one = (MdmBpmRoleEntity)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)bpmRoleCode), MdmBpmRoleEntity::getBpmRoleCode, (Object)bpmRoleCode)).one()) != null) {
            return (MdmBpmRoleRespVo)CrmBeanUtil.copy((Object)one, MdmBpmRoleRespVo.class);
        }
        return null;
    }

    @Override
    public List<MdmBpmRoleRespVo> queryBatchByBpmRoleCodeList(List<String> bpmRoleCodeList) {
        List list;
        List collect;
        if (CollectionUtil.listNotEmptyNotSizeZero(bpmRoleCodeList) && !(collect = bpmRoleCodeList.stream().filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList())).isEmpty() && (list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmBpmRoleEntity::getBpmRoleCode, collect)).list()) != null && list.size() > 0) {
            return CrmBeanUtil.copyList((List)list, MdmBpmRoleRespVo.class);
        }
        return new ArrayList<MdmBpmRoleRespVo>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmBpmRoleReqVo reqVo) {
        reqVo.setId(null);
        Assert.hasText((String)reqVo.getBpmRoleName(), (String)"\u7f3a\u5931\u6d41\u7a0b\u89d2\u8272\u540d\u79f0");
        MdmBpmRoleEntity entity = (MdmBpmRoleEntity)CrmBeanUtil.copy((Object)reqVo, MdmBpmRoleEntity.class);
        if (StringUtils.isEmpty((String)entity.getBpmRoleCode())) {
            entity.setBpmRoleCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_BPM_ROLE_CODE.getCode()));
        } else {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmBpmRoleEntity::getBpmRoleCode, (Object)reqVo.getBpmRoleCode())).select(new SFunction[]{MdmBpmRoleEntity::getBpmRoleCode}).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u5f53\u524d\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002");
        }
        List nameList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmBpmRoleEntity::getBpmRoleName, (Object)reqVo.getBpmRoleName())).select(new SFunction[]{MdmBpmRoleEntity::getBpmRoleName}).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)nameList), (String)"\u5f53\u524d\u6d41\u7a0b\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002");
        this.save(entity);
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuObject != null) {
            this.crmLogSendUtil.sendForAdd(menuObject.toString(), entity.getId(), entity.getBpmRoleCode(), CrmBeanUtil.copy((Object)entity, MdmBpmRoleReqVo.class));
        }
        this.sendBpmRoleAdd(Collections.singletonList(CrmBeanUtil.copy((Object)entity, MdmBpmRoleRespVo.class)));
        BpmRoleUtil.deleteAllCache();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmBpmRoleReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u7f3a\u5931id");
        Assert.hasText((String)reqVo.getBpmRoleCode(), (String)"\u7f3a\u5931\u6d41\u7a0b\u89d2\u8272\u7f16\u7801");
        Assert.hasText((String)reqVo.getBpmRoleName(), (String)"\u7f3a\u5931\u6d41\u7a0b\u89d2\u8272\u540d\u79f0");
        MdmBpmRoleEntity entity = (MdmBpmRoleEntity)this.getById((Serializable)((Object)reqVo.getId()));
        MdmBpmRoleReqVo oldObject = (MdmBpmRoleReqVo)CrmBeanUtil.copy((Object)entity, MdmBpmRoleReqVo.class);
        Assert.notNull((Object)entity, (String)"\u65e0\u6548\u7684id");
        Assert.isTrue((boolean)entity.getBpmRoleCode().equals(reqVo.getBpmRoleCode()), (String)"\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        List nameList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmBpmRoleEntity::getBpmRoleName, (Object)reqVo.getBpmRoleName())).ne(BaseIdEntity::getId, (Object)reqVo.getId())).select(new SFunction[]{MdmBpmRoleEntity::getBpmRoleName, BaseIdEntity::getId}).list().stream().filter(x -> !reqVo.getId().equals(x.getId())).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtil.listEmpty(nameList), (String)"\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)entity);
        this.updateById(entity);
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuObject != null) {
            MdmBpmRoleReqVo newObject = (MdmBpmRoleReqVo)CrmBeanUtil.copy((Object)entity, MdmBpmRoleReqVo.class);
            this.crmLogSendUtil.sendForUpdate(menuObject.toString(), reqVo.getId(), entity.getBpmRoleCode(), (Object)oldObject, (Object)newObject);
        }
        this.sendBpmRoleUpdate(Collections.singletonList(CrmBeanUtil.copy((Object)entity, MdmBpmRoleRespVo.class)));
        BpmRoleUtil.deleteByBpmRoleCode(Collections.singletonList(entity.getBpmRoleCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmBpmRoleEntity entity = (MdmBpmRoleEntity)this.getById((Serializable)((Object)id));
            Assert.notNull((Object)entity, (String)"\u65e0\u6548\u7684id");
            this.mdmPositionBpmRoleService.removeByBpmRole(entity.getBpmRoleCode());
        });
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        List code = list.stream().map(MdmBpmRoleEntity::getBpmRoleCode).collect(Collectors.toList());
        Object menuObject = ThreadLocalUtil.getObj((String)"menuCode");
        if (menuObject != null) {
            list.forEach(item -> this.crmLogSendUtil.sendForDel(menuObject.toString(), item.getId(), item.getBpmRoleCode(), item));
        }
        this.removeByIds(ids);
        this.sendBpmRoleDelete(CrmBeanUtil.copyList((List)list, MdmBpmRoleRespVo.class));
        BpmRoleUtil.deleteByBpmRoleCode(code);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            list.forEach(x -> x.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
            this.updateBatchById(list);
            this.sendBpmRoleUpdate(CrmBeanUtil.copyList((List)list, MdmBpmRoleRespVo.class));
            BpmRoleUtil.deleteByBpmRoleCode(list.stream().map(MdmBpmRoleEntity::getBpmRoleCode).collect(Collectors.toList()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            list.forEach(x -> x.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
            this.updateBatchById(list);
            this.sendBpmRoleUpdate(CrmBeanUtil.copyList((List)list, MdmBpmRoleRespVo.class));
            BpmRoleUtil.deleteByBpmRoleCode(list.stream().map(MdmBpmRoleEntity::getBpmRoleCode).collect(Collectors.toList()));
        }
    }

    @Override
    public List<MdmBpmRoleSelectRespVo> selectList(MdmBpmRoleSelectReqVo reqVo) {
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        ArrayList<MdmBpmRoleSelectRespVo> list = new ArrayList<MdmBpmRoleSelectRespVo>();
        HashSet<String> codeList = new HashSet<String>(16);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList(codeList));
        }
        if (pageSize > 0) {
            list.addAll(this.mdmBpmRoleMapper.bpmRoleSelectList((Page<MdmBpmRoleSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo));
        }
        return list;
    }

    @Override
    public Set<String> findBpmRoleCodeSetByPositionCodeList(List<String> positionCodeList) {
        Assert.notEmpty(positionCodeList, (String)"\u804c\u4f4d\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        return this.mdmPositionBpmRoleService.findBpmRoleCodeSetByPositionCodeList(positionCodeList);
    }

    @Override
    public List<MdmBpmRoleRedisRespVo> findRedisListByBpmRoleCodeList(List<String> bpmRoleCodeList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(bpmRoleCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CollectionUtil.listNotEmptyNotSizeZero(bpmRoleCodeList), MdmBpmRoleEntity::getBpmRoleCode, bpmRoleCodeList)).list()))) {
            return CrmBeanUtil.copyList((List)list, MdmBpmRoleRedisRespVo.class);
        }
        return new ArrayList<MdmBpmRoleRedisRespVo>();
    }

    @Override
    public List<MdmBpmRoleRedisRespVo> findRedisList() {
        List list = this.lambdaQuery().list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return CrmBeanUtil.copyList((List)list, MdmBpmRoleRedisRespVo.class);
        }
        return new ArrayList<MdmBpmRoleRedisRespVo>();
    }

    protected void sendBpmRoleAdd(List<MdmBpmRoleRespVo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        log.info("\u804c\u4f4d\u65b0\u589e\u53d1\u9001MQ\u6d88\u606f\uff1a{}", list);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("BPM_ROLE_ADD_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(list));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        log.info("\u804c\u4f4d\u65b0\u589e\u53d1\u9001MQ\u6d88\u606f\u6210\u529f\uff1a{}", list);
    }

    protected void sendBpmRoleUpdate(List<MdmBpmRoleRespVo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        log.info("\u804c\u4f4d\u7f16\u8f91\u53d1\u9001MQ\u6d88\u606f\uff1a{}", list);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("BPM_ROLE_UPDATE_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(list));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        log.info("\u804c\u4f4d\u7f16\u8f91\u53d1\u9001MQ\u6d88\u606f\u6210\u529f\uff1a{}", list);
    }

    protected void sendBpmRoleDelete(List<MdmBpmRoleRespVo> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        log.info("\u804c\u4f4d\u5220\u9664\u53d1\u9001MQ\u6d88\u606f\uff1a{}", list);
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setTag("BPM_ROLE_DELETE_TAG");
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString(list));
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        log.info("\u804c\u4f4d\u5220\u9664\u53d1\u9001MQ\u6d88\u606f\u6210\u529f\uff1a{}", list);
    }
}

