/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.mdm.customer.CustomerCodeConditionReqVo;
import com.biz.crm.nebular.mdm.customer.CustomerProductRespVo;
import com.biz.crm.nebular.mdm.customer.CustomerSaleRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAndOrgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactPageRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCountReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCountRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDistanceContactPageReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.customer.MdmPositionCustomerSearchReqVo;
import com.biz.crm.nebular.mdm.customer.MdmUpdateCusOrgCodeReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerUpdateReqVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmCustomerMsgController"})
@Api(tags={"\u5ba2\u6237\u4fe1\u606f"})
@CrmGlobalLog
public class MdmCustomerMsgController {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerMsgController.class);
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;

    @ApiOperation(value="\u5ba2\u6237\u4fe1\u606f\u9875\u9762\u67e5\u8be2\u4e3b\u5217\u8868\uff08\u5176\u5b83\u529f\u80fd\u8bf7\u52ff\u4f7f\u7528\uff09")
    @PostMapping(value={"/pageList"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerMsgRespVo>> selectPage(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        PageResult<MdmCustomerMsgRespVo> result = this.mdmCustomerMsgService.findList(mdmCustomerMsgReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/page"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerMsgRespVo>> page(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        mdmCustomerMsgReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        PageResult<MdmCustomerMsgRespVo> result = this.mdmCustomerMsgService.findList(mdmCustomerMsgReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u4ea7\u54c1\u9500\u552e\u62a5\u8868\u67e5\u8be2")
    @PostMapping(value={"/findPageList"})
    @CrmDictMethod
    public Result<PageResult<CustomerProductRespVo>> findPageList(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        PageResult<CustomerProductRespVo> pageList = this.mdmCustomerMsgService.findPageList(mdmCustomerMsgReqVo);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5ba2\u6237\u9500\u552e\u62a5\u8868\u67e5\u8be2")
    @PostMapping(value={"/findCustomerPageList"})
    @CrmDictMethod
    public Result<PageResult<CustomerSaleRespVo>> findCustomerPageList(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        PageResult<CustomerSaleRespVo> list = this.mdmCustomerMsgService.findCustomerPageList(mdmCustomerMsgReqVo);
        return Result.ok(list);
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u83b7\u53d6\u5f53\u524d\u5c42\u7ea7\u6240\u6709\u5ba2\u6237\u7f16\u7801\u96c6\u5408")
    @PostMapping(value={"/findByOrgCodeList"})
    public Result<List<String>> findByOrgCodeList(@RequestBody List<String> list) {
        return Result.ok(this.mdmCustomerMsgService.findByOrgCodeList(list));
    }

    @ApiOperation(value="\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="customerCode", value="\u5ba2\u6237\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/query"})
    @CrmDictMethod
    public Result<MdmCustomerMsgRespVo> query(@RequestParam(value="id", required=false) String id, @RequestParam(value="customerCode", required=false) String customerCode) {
        MdmCustomerMsgRespVo model = this.mdmCustomerMsgService.query(id, customerCode);
        return Result.ok((Object)model);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result<MdmCustomerMsgRespVo> save(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.mdmCustomerMsgService.save(mdmCustomerMsgReqVo);
        return Result.ok((Object)this.mdmCustomerMsgService.query(null, mdmCustomerMsgReqVo.getCustomerCode()));
    }

    @ApiOperation(value="\u65b0\u589e\u5e76\u63d0\u4ea4\u6d41\u7a0b")
    @PostMapping(value={"/saveAndSubmit"})
    public Result<Object> saveAndSubmit(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return Result.ok((String)this.mdmCustomerMsgService.saveAndSubmit(mdmCustomerMsgReqVo));
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result<Object> update(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.mdmCustomerMsgService.update(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0\u5e76\u63d0\u4ea4")
    @PostMapping(value={"/updateAndSubmit"})
    public Result<Object> updateAndSubmit(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        this.mdmCustomerMsgService.updateAndSubmit(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result<Object> delete(@RequestBody List<String> ids) {
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setIds(ids);
        this.mdmCustomerMsgService.deleteBatch(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u542f\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result<Object> enable(@RequestBody List<String> ids) {
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setIds(ids);
        this.mdmCustomerMsgService.enableBatch(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7981\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result<Object> disable(@RequestBody List<String> ids) {
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setIds(ids);
        this.mdmCustomerMsgService.disableBatch(mdmCustomerMsgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u4fee\u6539\u5ba2\u6237\u7ec4\u7ec7")
    @PostMapping(value={"/updateOrgCodeByCondition"})
    public Result<Object> updateOrgCodeByCondition(@RequestBody MdmUpdateCusOrgCodeReqVo mdmUpdateCusOrgCodeReqVo) {
        this.mdmCustomerMsgService.updateOrgCodeByCondition(mdmUpdateCusOrgCodeReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u4fee\u6539\u5ba2\u6237\u7684\u4f01\u4e1a\u7ec4\u7ec7")
    @PostMapping(value={"/batchUpdateCustomerOrg"})
    public Result<Object> batchUpdateCustomerOrg(@RequestBody MdmOrgCustomerUpdateReqVo reqVo) {
        this.mdmCustomerMsgService.batchUpdateCustomerOrg(reqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u53ca\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u5ba2\u6237")
    @PostMapping(value={"/findCurrentAndSubCustomerList"})
    public Result<List<MdmCustomerMsgRespVo>> findCurrentAndSubCustomerList(@RequestBody MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo) {
        List<MdmCustomerMsgRespVo> currentAndSubCustomerList = this.mdmCustomerMsgService.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
        return Result.ok(currentAndSubCustomerList);
    }

    @ApiOperation(value="\u5ba2\u6237\u4e0b\u62c9\u6846")
    @PostMapping(value={"/findCustomerSelectList"})
    public Result<List<MdmCustomerMsgSelectRespVo>> findCustomerSelectList(@RequestBody MdmCustomerMsgReqVo reqVo) {
        return Result.ok(this.mdmCustomerMsgService.list(reqVo));
    }

    @ApiOperation(value="\u5ba2\u6237\u4e0b\u62c9\u6846\uff08\u9650\u5236\u6570\u91cf\uff09")
    @PostMapping(value={"/select"})
    public Result<List<MdmCustomerMsgSelectRespVo>> select(@RequestBody MdmCustomerMsgSelectReqVo reqVo) {
        return Result.ok(this.mdmCustomerMsgService.findCustomerSelectList(reqVo));
    }

    @ApiOperation(value="\u5ba2\u6237\u4e0b\u62c9\u6846\uff08\u7528\u6237\u7ba1\u7406\u9875\u9762\u4f7f\u7528\uff09")
    @PostMapping(value={"/findCustomerNotRelateUserSelectList"})
    public Result<List<MdmCustomerMsgSelectRespVo>> findCustomerNotRelateUserSelectList(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return Result.ok(this.mdmCustomerMsgService.findCustomerNotRelateUserSelectList(mdmCustomerMsgReqVo));
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u5ba2\u6237\u7f16\u7801")
    @PostMapping(value={"/findCustomerCodeConditionList"})
    public Result<List<String>> findCustomerCodeConditionList(@RequestBody CustomerCodeConditionReqVo customerCodeConditionReqVo) {
        return Result.ok(this.mdmCustomerMsgService.findCustomerCodeConditionList(customerCodeConditionReqVo));
    }

    @ApiOperation(value="\u6839\u636e\u804c\u4f4did\u6216\u804c\u4f4d\u7f16\u7801\u67e5\u8be2\u5bf9\u5e94\u5ba2\u6237\u4fe1\u606f")
    @PostMapping(value={"/findPositionCustomerList"})
    public Result<List<MdmCustomerMsgRespVo>> findPositionCustomerList(@RequestBody MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo) {
        return Result.ok(this.mdmCustomerMsgService.findPositionCustomerList(mdmPositionCustomerSearchReqVo));
    }

    @ApiOperation(value="\u5f53\u524d\u53ca\u4e0b\u7ea7\u804c\u4f4d\u7f16\u7801\u5bf9\u5e94\u7684\u5ba2\u6237\u96c6\u5408")
    @PostMapping(value={"/findCurrentAndSubPositionCustomer"})
    public Result<List<MdmCustomerMsgRespVo>> findCurrentAndSubPositionCustomer(@RequestBody MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo) {
        return Result.ok(this.mdmCustomerMsgService.findCurrentAndSubPositionCustomer(mdmPositionCustomerSearchReqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u804c\u4f4d\u7684\u5ba2\u6237\u5206\u9875\u5217\u8868\u53ca\u8054\u7cfb\u4eba")
    @PostMapping(value={"/listAndContactPage"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerContactPageRespVo>> listAndContactPage(@RequestBody MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo) {
        PageResult<MdmCustomerContactPageRespVo> result = this.mdmCustomerMsgService.listAndContactPage(mdmCustomerContactPageReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u67e5\u8be2\u5bf9\u63a5\u4eba\u5217\u8868")
    @PostMapping(value={"/dockingList"})
    public Result<List<MdmCustomerDockingRespVo>> dockingList(@RequestBody MdmCustomerDockingReqVo mdmCustomerDockingReqVo) {
        return Result.ok(this.mdmCustomerMsgService.dockingList(mdmCustomerDockingReqVo));
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u5ba2\u6237\u5206\u9875\u5217\u8868\u53ca\u4e3b\u8054\u7cfb\u4eba")
    @PostMapping(value={"/customerContactPage"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerContactPageRespVo>> customerContactPage(@RequestBody MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo) {
        PageResult<MdmCustomerContactPageRespVo> result = this.mdmCustomerMsgService.customerContactPage(mdmCustomerContactPageReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="sfa-\u6839\u636e\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u5ba2\u6237\u5206\u9875\u5217\u8868\u53ca\u4e3b\u8054\u7cfb\u4eba")
    @CrmDictMethod
    @PostMapping(value={"sfaFindCustomerContactPage"})
    public Result<List<MdmCustomerContactPageRespVo>> sfaFindCustomerContactPage(@RequestBody List<String> customerCodes) {
        return Result.ok(this.mdmCustomerMsgService.sfaFindCustomerContactPage(customerCodes));
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="mdmCustomerMsgReqVos", value="\u5ba2\u6237\u96c6\u5408", required=true, paramType="body")})
    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u96c6\u5408\u4fee\u6539\u7ecf\u7eac\u5ea6")
    @PostMapping(value={"/updateCoordinate"})
    public Result<Object> updateCoordinate(@RequestBody List<MdmCustomerMsgReqVo> mdmCustomerMsgReqVos) {
        this.mdmCustomerMsgService.updateCoordinate(mdmCustomerMsgReqVos);
        return Result.ok();
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @ApiOperation(value="\u51bb\u7ed3")
    @PostMapping(value={"/frozen"})
    public Result<Object> frozen(@RequestBody List<String> ids) {
        this.mdmCustomerMsgService.frozen(ids);
        return Result.ok();
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @ApiOperation(value="\u89e3\u51bb")
    @PostMapping(value={"/thaw"})
    public Result<Object> thaw(@RequestBody List<String> ids) {
        this.mdmCustomerMsgService.thaw(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u53ca\u4e0b\u7ea7\u804c\u4f4d\u5173\u8054\u7684\u5ba2\u6237\u6570\u91cf")
    @GetMapping(value={"/findPositionRelationCustomerCount"})
    public Result<Integer> findPositionRelationCustomerCount(@RequestParam(value="positionCode") String positionCode) {
        Integer count = this.mdmCustomerMsgService.findPositionRelationCustomerCount(positionCode);
        return Result.ok((Object)count);
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u804c\u4f4d\u5173\u8054\u7684\u5ba2\u6237\u6570\u91cf")
    @GetMapping(value={"/findCurrentPositionRelationCustomerCount"})
    public Result<Integer> findCurrentPositionRelationCustomerCount(@RequestParam(value="positionCode") String positionCode) {
        Integer count = this.mdmCustomerMsgService.findCurrentPositionRelationCustomerCount(positionCode);
        return Result.ok((Object)count);
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u5ba2\u6237\u4e3b\u8054\u7cfb\u4eba\u53ca\u8ddd\u79bb\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/distanceContactPage"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerContactPageRespVo>> distanceContactPage(@RequestBody MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo) {
        mdmCustomerDistanceContactPageReqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        PageResult<MdmCustomerContactPageRespVo> result = this.mdmCustomerMsgService.distanceContactPage(mdmCustomerDistanceContactPageReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u5ba2\u6237\u4e3b\u8054\u7cfb\u4eba\u53ca\u8ddd\u79bb\u5206\u9875\u5217\u8868\uff08\u53ef\u4ee5\u67e5\u5230\u975e\u5ba1\u6279\u901a\u8fc7\u7684\uff09")
    @PostMapping(value={"/distanceContactNoBpmFilterPage"})
    @CrmDictMethod
    public Result<PageResult<MdmCustomerContactPageRespVo>> distanceContactNoBpmFilterPage(@RequestBody MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo) {
        PageResult<MdmCustomerContactPageRespVo> result = this.mdmCustomerMsgService.distanceContactPage(mdmCustomerDistanceContactPageReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u5f53\u524d\u53ca\u4e0b\u7ea7\u7ec4\u7ec7\u5bf9\u5e94\u7684\u5ba2\u6237")
    @PostMapping(value={"/findSubCustomerList"})
    public Result<List<MdmCustomerMsgRespVo>> findSubCustomerList(@RequestBody MdmCustomerAndOrgReqVo mdmCustomerOrgSearchReqVo) {
        return Result.ok(this.mdmCustomerMsgService.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo));
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8fAPP\u62a5\u8868\u5ba2\u6237\u4e0e\u62dc\u8bbf(\u9ed8\u8ba4\u4eca\u5929)")
    @PostMapping(value={"/fingCustomerAndVisit"})
    public Result<MdmCustomerCountRespVo> fingCustomerAndVisit(@RequestBody MdmCustomerCountReqVo mdmCustomerCountReqVo) {
        return Result.ok((Object)this.mdmCustomerMsgService.fingCustomerAndVisit(mdmCustomerCountReqVo));
    }

    @ApiOperation(value="\u63d0\u4ea4\u5de5\u4f5c\u6d41\u5ba1\u6279")
    @PostMapping(value={"/submit"})
    public Result submit(@RequestBody MdmCustomerMsgReqVo reqVo) {
        this.mdmCustomerMsgService.submit(reqVo);
        return Result.ok((String)"\u63d0\u4ea4\u5ba1\u6279\u6210\u529f");
    }

    @ApiOperation(value="\u5de5\u4f5c\u6d41\u56de\u8c03\u63a5\u53e3")
    @PostMapping(value={"/activityCallBack"})
    public Result callback(@RequestBody ActivitiCallBackVo reqVo) {
        this.mdmCustomerMsgService.callback(reqVo);
        return Result.ok((String)"\u6d3b\u52a8\u5ba1\u6279\u56de\u8c03\u6210\u529f");
    }

    @ApiOperation(value="\u72b6\u6001\u5ba1\u6279\uff0c\u63d0\u4ea4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/statusApprovalSubmit"})
    public Result<Object> statusApprovalSubmit(@RequestBody List<String> ids) {
        this.mdmCustomerMsgService.statusApprovalSubmit(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u72b6\u6001\u5ba1\u6279\uff0c\u9a73\u56de")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/statusApprovalReject"})
    public Result<Object> statusApprovalReject(@RequestBody List<String> ids) {
        this.mdmCustomerMsgService.statusApprovalReject(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u72b6\u6001\u5ba1\u6279\uff0c\u5ba1\u6279\u901a\u8fc7")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/statusApprovalAgree"})
    public Result<Object> statusApprovalAgree(@RequestBody List<String> ids) {
        this.mdmCustomerMsgService.statusApprovalAgree(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u5ba2\u6237\u7ec4\u7ec7\u4e0b\u7684\u7ecf\u9500\u5546")
    @PostMapping(value={"/findCustomerByCustomerOrgCodeList"})
    public Result<List<MdmCustomerMsgRespVo>> findCustomerByCustomerOrgCodeList(@RequestBody List<String> customerOrgCodeList) {
        return Result.ok(this.mdmCustomerMsgService.findCustomerByCustomerOrgCodeList(customerOrgCodeList));
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f")
    @PostMapping(value={"/queryByCustomerCodeList"})
    @CrmDictMethod
    public Result<List<MdmCustomerMsgRespVo>> queryByCustomerCodeList(@RequestBody List<String> customerCodeList) {
        List<MdmCustomerMsgRespVo> modelList = this.mdmCustomerMsgService.queryByCustomerCodeList(customerCodeList);
        return Result.ok(modelList);
    }
}

