/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.customer.mapper.MdmCustomerTagMapper;
import com.biz.crm.customer.model.MdmCustomerTagEntity;
import com.biz.crm.customer.service.MdmCustomerTagService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTagRefreshVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTagReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTagRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class MdmCustomerTagServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerTagMapper, MdmCustomerTagEntity>
implements MdmCustomerTagService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerTagServiceImpl.class);
    @Autowired
    private MdmCustomerTagMapper mdmCustomerTagMapper;
    @Autowired
    private RocketMQProducer rocketMQProducer;

    @Override
    public List<MdmCustomerTagRespVo> findList(MdmCustomerTagReqVo reqVo) {
        List<MdmCustomerTagRespVo> list = this.mdmCustomerTagMapper.findList(reqVo);
        return list;
    }

    @Override
    @Transactional
    public void save(MdmCustomerTagReqVo reqVo) {
        this.doCheck(reqVo);
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerTagEntity::getClientCode, (Collection)Lists.newArrayList((Object[])new String[]{reqVo.getClientCode()}))).list();
        MdmCustomerTagEntity entity = (MdmCustomerTagEntity)CrmBeanUtil.copy((Object)reqVo, MdmCustomerTagEntity.class);
        this.save(entity);
        if (CollectionUtils.isEmpty((Collection)list)) {
            list = Lists.newArrayList();
        }
        list.add(entity);
        MdmCustomerTagRefreshVo refreshVo = new MdmCustomerTagRefreshVo();
        refreshVo.setClientCode(reqVo.getClientCode());
        refreshVo.setTagList(CrmBeanUtil.copyList((List)list, MdmCustomerTagRespVo.class));
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString((Object)refreshVo));
        rocketMQMessageBody.setTag("CUSTOMER_TAG_REFRESH");
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    @Override
    public void saveBatch(List<MdmCustomerTagReqVo> reqVos) {
        if (CollectionUtil.listNotEmpty(reqVos)) {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerTagEntity::getClientCode, (Collection)Lists.newArrayList((Object[])new String[]{reqVos.get(0).getClientCode()}))).list();
            ArrayList<MdmCustomerTagEntity> all = new ArrayList<MdmCustomerTagEntity>();
            if (CollectionUtils.isEmpty((Collection)list)) {
                list = Lists.newArrayList();
            }
            for (MdmCustomerTagReqVo reqVo : reqVos) {
                this.doCheck(reqVo);
                MdmCustomerTagEntity entity = (MdmCustomerTagEntity)CrmBeanUtil.copy((Object)reqVo, MdmCustomerTagEntity.class);
                all.add(entity);
                list.add(entity);
            }
            this.saveBatch(all);
            MdmCustomerTagRefreshVo refreshVo = new MdmCustomerTagRefreshVo();
            refreshVo.setClientCode(reqVos.get(0).getClientCode());
            refreshVo.setTagList(CrmBeanUtil.copyList((List)list, MdmCustomerTagRespVo.class));
            RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
            rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString((Object)refreshVo));
            rocketMQMessageBody.setTag("CUSTOMER_TAG_REFRESH");
            this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
    }

    @Override
    @Transactional
    public void delete(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"\u4e3b\u952eId\u4e0d\u80fd\u4e3a\u7a7a");
        MdmCustomerTagEntity entity = (MdmCustomerTagEntity)this.mdmCustomerTagMapper.selectById((Serializable)((Object)id));
        AssertUtils.isNotNull((Object)entity, (String)"\u6807\u7b7e\u4e0d\u5b58\u5728");
        if (YesNoEnum.yesNoEnum.ZERO.getValue().equals(entity.getTagType())) {
            throw new BusinessException("\u6b64\u6807\u7b7e\u4e0d\u53ef\u5220\u9664");
        }
        List<Object> list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerTagEntity::getClientCode, (Collection)Lists.newArrayList((Object[])new String[]{entity.getClientCode()}))).list();
        list = CollectionUtils.isEmpty((Collection)list) ? Lists.newArrayList() : list.stream().filter(mdmCustomerTagEntity -> !id.equals(mdmCustomerTagEntity.getId())).collect(Collectors.toList());
        this.removeById((Serializable)((Object)id));
        MdmCustomerTagRefreshVo refreshVo = new MdmCustomerTagRefreshVo();
        refreshVo.setClientCode(entity.getClientCode());
        refreshVo.setTagList(CollectionUtils.isEmpty(list) ? null : CrmBeanUtil.copyList(list, MdmCustomerTagRespVo.class));
        RocketMQMessageBody rocketMQMessageBody = new RocketMQMessageBody();
        rocketMQMessageBody.setMsgBody(JsonPropertyUtil.toJsonString((Object)refreshVo));
        rocketMQMessageBody.setTag("CUSTOMER_TAG_REFRESH");
        this.rocketMQProducer.convertAndSend(rocketMQMessageBody);
    }

    public void doCheck(MdmCustomerTagReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getClientCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTagType(), (String)"\u6807\u7b7e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getTagDescription(), (String)"\u6807\u7b7e\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    public List<MdmCustomerTagRespVo> queryTagByCodeList(List<String> customerCodeList) {
        List entityList;
        List<Object> voList = new ArrayList<MdmCustomerTagRespVo>();
        if (CollectionUtil.listNotEmptyNotSizeZero(customerCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(entityList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCustomerTagEntity::getClientCode, customerCodeList)).list()))) {
            voList = CrmBeanUtil.copyList((List)entityList, MdmCustomerTagRespVo.class);
        }
        return voList;
    }
}

