/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.login.service.MdmLoginHelpService;
import com.biz.crm.message.ShortMessage;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.webservice.mail.CrmMailMessage;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.Result;
import com.biz.crm.utils.LoginHelpUtil;
import com.biz.crm.webservice.mail.MailFeign;
import com.biz.crm.webservice.message.ShortMessageFeign;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmLoginHelpServiceExpandImpl"})
public class MdmLoginHelpServiceImpl
implements MdmLoginHelpService {
    private static final Logger log = LoggerFactory.getLogger(MdmLoginHelpServiceImpl.class);
    @Autowired
    private RedisService redisService;
    @Autowired
    private MdmDictDataService mdmDictDataService;
    @Autowired(required=false)
    private ShortMessageFeign shortMessageFeign;
    @Autowired(required=false)
    private MailFeign mailFeign;

    @Override
    public void checkLock(String account, LoginHelpUtil.AccountType accountType) {
        if (StringUtils.isEmpty((CharSequence)account)) {
            return;
        }
        long userLockMinutes = this.getLockMinutes(account, accountType);
        if (userLockMinutes != 0L) {
            if (LoginHelpUtil.AccountType.USER_NAME == accountType) {
                throw new BusinessException("\u7528\u6237\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u8bf7" + userLockMinutes + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
            }
            if (LoginHelpUtil.AccountType.PHONE == accountType) {
                throw new BusinessException("\u624b\u673a\u53f7\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u8bf7" + userLockMinutes + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
            }
            if (LoginHelpUtil.AccountType.EMAIL == accountType) {
                throw new BusinessException("\u90ae\u7bb1\u5df2\u7ecf\u88ab\u9501\u5b9a\uff0c\u8bf7" + userLockMinutes + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
            }
        }
    }

    @Override
    public void addError(String userName, String phone, String email) {
        Assert.hasText((String)userName, (String)"\u7528\u6237\u540d\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef");
        long lastTimes = this.addErrorAndGetTimes(userName, phone, email);
        if (lastTimes != 0L) {
            throw new BusinessException("\u7528\u6237\u540d\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + lastTimes + "\u6b21\u5c1d\u8bd5\u673a\u4f1a");
        }
        throw new BusinessException("\u7528\u6237\u540d\u4e0d\u5b58\u5728\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8d26\u53f7\u88ab\u9501\u5b9a\uff0c\u8bf7" + this.getMaxLockMinutes() + "\u5206\u949f\u540e\u518d\u5c1d\u8bd5");
    }

    @Override
    public void checkUserLogin(String enableStatus, String startTime, String endTime) {
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(enableStatus), (String)"\u7528\u6237\u672a\u542f\u7528");
        String now = DateUtil.dateNowHms();
        if (StringUtils.isNotEmpty((CharSequence)startTime)) {
            Assert.isTrue((now.compareTo(startTime) >= 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u672a\u751f\u6548");
        }
        if (StringUtils.isNotEmpty((CharSequence)endTime)) {
            Assert.isTrue((now.compareTo(endTime) <= 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u5df2\u5931\u6548");
        }
    }

    @Override
    public void checkUserType(String userType, String fromType) {
        Assert.hasText((String)userType, (String)"\u7f3a\u5931\u7528\u6237\u7c7b\u578b");
        Assert.hasText((String)fromType, (String)"\u7f3a\u5931\u767b\u5f55\u6765\u6e90");
        if (UserTypeEnum.USER.getCode().equals(userType) && LoginFromTypeEnum.CONSOLE.getValue().equals(fromType)) {
            return;
        }
        Map<String, DictDataVo> userTypeMap = this.mdmDictDataService.getDictDataDetailMap("user_type");
        Assert.isTrue((boolean)userTypeMap.containsKey(userType), (String)"\u672a\u8bc6\u522b\u7684\u7528\u6237\u7c7b\u578b");
        DictDataVo dictDataVo = userTypeMap.get(userType);
        String usableLoginFromType = (String)dictDataVo.getExtendMap().get("usable_login_from_type");
        Assert.hasText((String)usableLoginFromType, (String)"\u7528\u6237\u7c7b\u578b\u672a\u914d\u7f6e\u53ef\u7528\u767b\u5f55\u5165\u53e3");
        if (StringUtils.isNotEmpty((CharSequence)usableLoginFromType)) {
            HashSet<String> fromTypeSet = new HashSet<String>(Arrays.asList(usableLoginFromType.split(",")));
            Assert.isTrue((boolean)fromTypeSet.contains(fromType), (String)(UserTypeEnum.getDescByCode((String)userType) + "\u4e0d\u80fd\u767b\u5f55" + LoginFromTypeEnum.getDesc((String)fromType)));
        }
        if (LoginFromTypeEnum.CONSOLE.getValue().equals(fromType)) {
            Assert.isTrue((boolean)UserTypeEnum.USER.getCode().equals(userType), (String)"\u53ea\u6709\u4f01\u4e1a\u7528\u6237\u624d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        } else if (LoginFromTypeEnum.APP_SFA.getValue().equals(fromType)) {
            Assert.isTrue((UserTypeEnum.USER.getCode().equals(userType) || UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(userType) ? 1 : 0) != 0, (String)"\u8be5\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        } else if (LoginFromTypeEnum.APPLET_SFA.getValue().equals(fromType)) {
            Assert.isTrue((UserTypeEnum.USER.getCode().equals(userType) || UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(userType) ? 1 : 0) != 0, (String)"\u8be5\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        } else if (LoginFromTypeEnum.WEB_DMS.getValue().equals(fromType)) {
            Assert.isTrue((UserTypeEnum.CUSTOMER.getCode().equals(userType) || UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(userType) ? 1 : 0) != 0, (String)"\u8be5\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        } else if (LoginFromTypeEnum.APPLET_DMS.getValue().equals(fromType)) {
            Assert.isTrue((UserTypeEnum.CUSTOMER.getCode().equals(userType) || UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(userType) ? 1 : 0) != 0, (String)"\u8be5\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        } else if (LoginFromTypeEnum.APP_DMS.getValue().equals(fromType)) {
            Assert.isTrue((UserTypeEnum.CUSTOMER.getCode().equals(userType) || UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(userType) ? 1 : 0) != 0, (String)"\u8be5\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        } else if (LoginFromTypeEnum.OFFICIAL_ACCOUNTS_DMS.getValue().equals(fromType)) {
            Assert.isTrue((UserTypeEnum.CUSTOMER.getCode().equals(userType) || UserTypeEnum.CUSTOMER_EMPLOYEE.getCode().equals(userType) ? 1 : 0) != 0, (String)"\u8be5\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf");
        } else if (LoginFromTypeEnum.APPLET_TERMINAL.getValue().equals(fromType)) {
            Assert.isTrue((UserTypeEnum.TERMINAL.getCode().equals(userType) || UserTypeEnum.CUSTOMER.getCode().equals(userType) ? 1 : 0) != 0, (String)("\u8be5\u7528\u6237\u7c7b\u578b:" + userType + "\u4e0d\u80fd\u767b\u5f55\u5f53\u524d\u7cfb\u7edf"));
        }
    }

    @Override
    public long getLockMinutes(String account, LoginHelpUtil.AccountType accountType) {
        if (LoginHelpUtil.AccountType.USER_NAME == accountType) {
            return this.getLockMinutes("LOGIN_LOCK_USER_0319:", account);
        }
        if (LoginHelpUtil.AccountType.PHONE == accountType) {
            return this.getLockMinutes("LOGIN_LOCK_PHONE_0319:", account);
        }
        if (LoginHelpUtil.AccountType.EMAIL == accountType) {
            return this.getLockMinutes("LOGIN_LOCK_EMAIL_0319:", account);
        }
        return 0L;
    }

    @Override
    public void unlock(String userName, String phone, String email) {
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            this.redisService.hdel("LOGIN_LOCK_USER_0319:", new Object[]{userName});
            this.redisService.hdel("LOGIN_LOCK_USER_ERROR_TIMES_0319:", new Object[]{userName});
        }
        if (StringUtils.isNotEmpty((CharSequence)phone)) {
            this.redisService.hdel("LOGIN_LOCK_PHONE_0319:", new Object[]{phone});
            this.redisService.hdel("LOGIN_LOCK_PHONE_ERROR_TIMES_0319:", new Object[]{phone});
        }
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            this.redisService.hdel("LOGIN_LOCK_EMAIL_0319:", new Object[]{email});
            this.redisService.hdel("LOGIN_LOCK_EMAIL_ERROR_TIMES_0319:", new Object[]{email});
        }
    }

    @Override
    public long getMaxLockMinutes() {
        long maxLockSeconds = this.getMaxLockSeconds();
        BigDecimal divide = new BigDecimal(maxLockSeconds).divide(new BigDecimal(60), 0, 0);
        return divide.longValue();
    }

    @Override
    public String saveLoginVerificationCodeRelUser(String fromType, String userName, String account, LoginHelpUtil.AccountType accountType, LoginHelpUtil.VerificationCodeType verificationCodeType) {
        String verification = this.generateVerificationCode();
        if (LoginHelpUtil.AccountType.PHONE == accountType) {
            if (LoginHelpUtil.VerificationCodeType.LOGIN == verificationCodeType) {
                this.redisService.hset("LOGIN_PHONE_VERIFICATION_0319:" + fromType + ":" + account, verification, (Object)userName, 300L);
            }
            if (LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET == verificationCodeType) {
                this.redisService.hset("LOGIN_PHONE_RESET_VERIFICATION_0319:" + fromType + ":" + account, verification, (Object)userName, 300L);
            }
        }
        if (LoginHelpUtil.AccountType.EMAIL == accountType) {
            if (LoginHelpUtil.VerificationCodeType.LOGIN == verificationCodeType) {
                this.redisService.hset("LOGIN_EMAIL_VERIFICATION_0319:" + fromType + ":" + account, verification, (Object)userName, 3600L);
            }
            if (LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET == verificationCodeType) {
                this.redisService.hset("LOGIN_EMAIL_RESET_VERIFICATION_0319:" + fromType + ":" + account, verification, (Object)userName, 3600L);
            }
        }
        return verification;
    }

    @Override
    public void sendVerificationCode(String fromType, String verificationCode, String account, LoginHelpUtil.AccountType accountType, LoginHelpUtil.VerificationCodeType verificationCodeType) {
        if (LoginHelpUtil.AccountType.PHONE == accountType) {
            String template;
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setPhoneNumbers(account);
            shortMessage.setTemplateParam("{\"code\":\"" + verificationCode + "\"}");
            if (LoginHelpUtil.VerificationCodeType.LOGIN == verificationCodeType) {
                template = this.mdmDictDataService.getDictDataMap("message_template").get("system_login");
                Assert.hasText((String)template, (String)"\u672a\u914d\u7f6e\u624b\u673a\u9a8c\u8bc1\u7801\u767b\u5f55\u77ed\u4fe1\u6a21\u677f");
                shortMessage.setTemplateCode(template);
            }
            if (LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET == verificationCodeType) {
                template = this.mdmDictDataService.getDictDataMap("message_template").get("system_login_and_reset");
                Assert.hasText((String)template, (String)"\u672a\u914d\u7f6e\u624b\u673a\u9a8c\u8bc1\u7801\u91cd\u7f6e\u5bc6\u7801\u77ed\u4fe1\u6a21\u677f");
                shortMessage.setTemplateCode(template);
            }
            this.shortMessageFeign.sendMessage(shortMessage);
        }
        if (LoginHelpUtil.AccountType.EMAIL == accountType) {
            String subject = "";
            StringBuilder sb = new StringBuilder();
            if (LoginHelpUtil.VerificationCodeType.LOGIN == verificationCodeType) {
                sb.append("<p>\u60a8\u6b63\u5728\u5c1d\u8bd5\u901a\u8fc7\u90ae\u7bb1\u9a8c\u8bc1\u7801\u767b\u5f55</p>");
                subject = "\u767b\u5f55\u9a8c\u8bc1\u7801";
            }
            if (LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET == verificationCodeType) {
                sb.append("<p>\u60a8\u6b63\u5728\u5c1d\u8bd5\u901a\u8fc7\u90ae\u7bb1\u9a8c\u8bc1\u8eab\u4efd\u5e76\u91cd\u7f6e\u60a8\u7684\u5bc6\u7801</p>");
                subject = "\u91cd\u7f6e\u5bc6\u7801\u9a8c\u8bc1\u7801";
            }
            sb.append("<p>\u672c\u6b21\u9a8c\u8bc1\u7801\u4e3a\uff1a<strong>").append(verificationCode).append("</strong></p>");
            sb.append("<p>\u9a8c\u8bc1\u7801\u5c06\u57281\u5c0f\u65f6\u540e\u6216\u8005\u4f7f\u75281\u6b21\u540e\u81ea\u52a8\u5931\u6548</p>");
            sb.append("<p>\u8bf7\u52ff\u5c06\u9a8c\u8bc1\u7801\u544a\u8bc9\u4ed6\u4eba</p>");
            sb.append("<p>\u5982\u975e\u60a8\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u4e0d\u4e88\u7406\u4f1a</p>");
            CrmMailMessage crmMailMessage = new CrmMailMessage(null, null, Collections.singleton(account), subject, sb.toString());
            Result result = this.mailFeign.sendMail(crmMailMessage);
            Assert.isTrue((boolean)result.isSuccess(), (String)("\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff1a" + result.getMessage()));
        }
        log.debug("\u53d1\u9001\u9a8c\u8bc1\u7801\u6210\u529f\uff1a\u767b\u5f55\u7cfb\u7edf\uff1a{}\uff0c\u90ae\u7bb1/\u624b\u673a\u53f7\uff1a{}\uff0c\u9a8c\u8bc1\u7801\uff1a{}", new Object[]{LoginFromTypeEnum.getDesc((String)fromType), account, verificationCode});
    }

    @Override
    public Set<String> checkAndGetLockUserName(Set<String> userNameSet) {
        Map hmget;
        HashSet<String> lockUserNameSet = new HashSet<String>(16);
        if (!userNameSet.isEmpty() && (hmget = this.redisService.hmget("LOGIN_LOCK_USER_0319:")) != null) {
            lockUserNameSet.addAll(hmget.keySet().stream().map(x -> (String)x).filter(userNameSet::contains).collect(Collectors.toSet()));
        }
        return lockUserNameSet;
    }

    @Override
    public String checkVerificationCode(String fromType, String verificationCode, String account, LoginHelpUtil.AccountType accountType, LoginHelpUtil.VerificationCodeType verificationCodeType) {
        Object hget;
        String userName = null;
        if (LoginHelpUtil.AccountType.PHONE == accountType) {
            if (LoginHelpUtil.VerificationCodeType.LOGIN == verificationCodeType && (hget = this.redisService.hget("LOGIN_PHONE_VERIFICATION_0319:" + fromType + ":" + account, verificationCode)) != null) {
                this.redisService.del(new String[]{"LOGIN_PHONE_VERIFICATION_0319:" + fromType + ":" + account});
                userName = (String)hget;
            }
            if (LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET == verificationCodeType && (hget = this.redisService.hget("LOGIN_PHONE_RESET_VERIFICATION_0319:" + fromType + ":" + account, verificationCode)) != null) {
                this.redisService.del(new String[]{"LOGIN_PHONE_RESET_VERIFICATION_0319:" + fromType + ":" + account});
                userName = (String)hget;
            }
        }
        if (LoginHelpUtil.AccountType.EMAIL == accountType) {
            if (LoginHelpUtil.VerificationCodeType.LOGIN == verificationCodeType && (hget = this.redisService.hget("LOGIN_EMAIL_VERIFICATION_0319:" + fromType + ":" + account, verificationCode)) != null) {
                this.redisService.del(new String[]{"LOGIN_EMAIL_VERIFICATION_0319:" + fromType + ":" + account});
                userName = (String)hget;
            }
            if (LoginHelpUtil.VerificationCodeType.LOGIN_AND_RESET == verificationCodeType && (hget = this.redisService.hget("LOGIN_EMAIL_RESET_VERIFICATION_0319:" + fromType + ":" + account, verificationCode)) != null) {
                this.redisService.del(new String[]{"LOGIN_EMAIL_RESET_VERIFICATION_0319:" + fromType + ":" + account});
                userName = (String)hget;
            }
        }
        Assert.hasText(userName, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        return userName;
    }

    protected long addErrorAndGetTimes(String userName, String phone, String email) {
        long maxErrorTimes;
        Assert.hasText((String)userName, (String)"\u7f3a\u5931\u767b\u5f55\u8d26\u53f7");
        long lastTimes = maxErrorTimes = this.getMaxErrorTimes();
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            Object lockObj = this.redisService.hget("LOGIN_LOCK_USER_0319:", userName);
            if (lockObj != null) {
                lastTimes = 0L;
            } else {
                Object errorTimesObj = this.redisService.hget("LOGIN_LOCK_USER_ERROR_TIMES_0319:", userName);
                if (maxErrorTimes == 1L) {
                    this.lock(userName, phone, email);
                    lastTimes = 0L;
                } else {
                    int thisAfterAddTimes = 1;
                    if (errorTimesObj != null) {
                        thisAfterAddTimes += ((Integer)errorTimesObj).intValue();
                    }
                    if ((long)thisAfterAddTimes >= maxErrorTimes) {
                        this.lock(userName, phone, email);
                        lastTimes = 0L;
                    } else {
                        this.setErrorTimes(userName, phone, email, thisAfterAddTimes);
                        lastTimes = maxErrorTimes - (long)thisAfterAddTimes;
                    }
                }
            }
        }
        return lastTimes;
    }

    protected void lock(String userName, String phone, String email) {
        long lockSeconds = this.getMaxLockSeconds();
        long unlockDateTime = System.currentTimeMillis() + lockSeconds * 1000L;
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            this.redisService.hset("LOGIN_LOCK_USER_0319:", userName, (Object)unlockDateTime, lockSeconds);
            this.redisService.hdel("LOGIN_LOCK_USER_ERROR_TIMES_0319:", new Object[]{userName});
        }
        if (StringUtils.isNotEmpty((CharSequence)phone)) {
            this.redisService.hset("LOGIN_LOCK_PHONE_0319:", phone, (Object)unlockDateTime, lockSeconds);
            this.redisService.hdel("LOGIN_LOCK_PHONE_ERROR_TIMES_0319:", new Object[]{phone});
        }
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            this.redisService.hset("LOGIN_LOCK_EMAIL_0319:", email, (Object)unlockDateTime, lockSeconds);
            this.redisService.hdel("LOGIN_LOCK_EMAIL_ERROR_TIMES_0319:", new Object[]{email});
        }
    }

    protected void setErrorTimes(String userName, String phone, String email, int times) {
        long errorResetSeconds = this.getErrorResetSeconds();
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            this.redisService.hset("LOGIN_LOCK_USER_ERROR_TIMES_0319:", userName, (Object)times, errorResetSeconds);
        }
        if (StringUtils.isNotEmpty((CharSequence)phone)) {
            this.redisService.hset("LOGIN_LOCK_PHONE_ERROR_TIMES_0319:", phone, (Object)times, errorResetSeconds);
        }
        if (StringUtils.isNotEmpty((CharSequence)email)) {
            this.redisService.hset("LOGIN_LOCK_EMAIL_ERROR_TIMES_0319:", email, (Object)times, errorResetSeconds);
        }
    }

    protected long getLockMinutes(String lockKey, String name) {
        Long unlockDateTimeLong;
        long l;
        Object obj;
        if (StringUtils.isNotEmpty((CharSequence)name) && (obj = this.redisService.hget(lockKey, name)) != null && (l = (unlockDateTimeLong = (Long)obj) - System.currentTimeMillis()) > 0L) {
            BigDecimal divide = new BigDecimal(l).divide(new BigDecimal(60000L), 0, 0);
            return divide.longValue();
        }
        return 0L;
    }

    protected long getErrorResetSeconds() {
        try {
            String parameterValue = ParamUtil.getParameterValueNoException((String)"login_password_error_reset_minutes");
            if (StringUtils.isNotEmpty((CharSequence)parameterValue)) {
                return new BigDecimal(parameterValue).multiply(new BigDecimal("60")).setScale(0, RoundingMode.HALF_UP).longValue();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5bc6\u7801\u9519\u8bef\u91cd\u7f6e\u65f6\u95f4\u5931\u8d25");
        }
        return 64800L;
    }

    protected long getMaxErrorTimes() {
        try {
            String parameterValue = ParamUtil.getParameterValueNoException((String)"login_error_frequency");
            if (StringUtils.isNotEmpty((CharSequence)parameterValue)) {
                return Long.valueOf(parameterValue);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u5bc6\u7801\u6700\u5927\u8f93\u5165\u9519\u8bef\u6b21\u6570\u5931\u8d25");
        }
        return 5L;
    }

    protected long getMaxLockSeconds() {
        try {
            String parameterValue = ParamUtil.getParameterValueNoException((String)"login_lock_time");
            if (StringUtils.isNotEmpty((CharSequence)parameterValue)) {
                return new BigDecimal(parameterValue).multiply(new BigDecimal("60")).setScale(0, RoundingMode.HALF_UP).longValue();
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7528\u6237\u6700\u5927\u9501\u5b9a\u65f6\u957f\u5931\u8d25");
        }
        return 900L;
    }

    @Override
    public String generateVerificationCode() {
        int length = 6;
        double random = Math.random();
        return String.format("%0" + length + "d", new BigDecimal(random).multiply(new BigDecimal(Math.pow(10.0, length))).setScale(0, RoundingMode.HALF_UP).longValue());
    }
}

