/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.material.mapper.MdmMaterialMediaMapper;
import com.biz.crm.material.model.MdmMaterialMediaEntity;
import com.biz.crm.material.service.MdmMaterialMediaService;
import com.biz.crm.nebular.mdm.material.MdmMaterialMediaRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"MdmMaterialServiceExpandImpl"})
public class MdmMaterialMediaServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmMaterialMediaMapper, MdmMaterialMediaEntity>
implements MdmMaterialMediaService {
    private static final Logger log = LoggerFactory.getLogger(MdmMaterialMediaServiceImpl.class);

    @Override
    public List<MdmMaterialMediaRespVo> findMediaListByCondition(String materialId, String materialCode) {
        AssertUtils.isTrue((StringUtils.isNotEmpty((String)materialId) || StringUtils.isNotEmpty((String)materialCode) ? 1 : 0) != 0, (String)"\u7269\u6599id\u6216\u8005\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper objectLambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)objectLambdaQueryWrapper.eq(StringUtils.isNotEmpty((String)materialCode), MdmMaterialMediaEntity::getMaterialCode, (Object)materialCode)).eq(StringUtils.isNotEmpty((String)materialId), MdmMaterialMediaEntity::getMaterialId, (Object)materialId);
        List list = this.list((Wrapper)objectLambdaQueryWrapper);
        List mdmMaterialMediaRespVos = CrmBeanUtil.copyList((List)list, MdmMaterialMediaRespVo.class);
        return mdmMaterialMediaRespVos;
    }

    @Override
    public List<MdmMaterialMediaRespVo> findMediaListByIds(List<String> ids) {
        AssertUtils.isTrue((boolean)CollectionUtil.listNotEmptyNotSizeZero(ids), (String)"\u7269\u6599id\u6216\u8005\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper objectLambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)objectLambdaQueryWrapper.in(MdmMaterialMediaEntity::getMaterialId, ids)).eq(MdmMaterialMediaEntity::getBusinessType, (Object)"central");
        List list = this.list((Wrapper)objectLambdaQueryWrapper);
        List mdmMaterialMediaRespVos = CrmBeanUtil.copyList((List)list, MdmMaterialMediaRespVo.class);
        return mdmMaterialMediaRespVos;
    }
}

