/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.shoppingcart.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.customer.utils.ValidateUtils;
import com.biz.crm.eunm.dms.ShoppingCartEunm;
import com.biz.crm.nebular.mdm.availablelist.CusAvailablelistVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductSaleCompanyRespVo;
import com.biz.crm.nebular.mdm.shoppingcart.ShoppingCartVo;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.shoppingcart.entity.ShoppingCartEntity;
import com.biz.crm.shoppingcart.mapper.ShoppingCartMapper;
import com.biz.crm.shoppingcart.service.ShoppingCartService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"shoppingCartServiceExpandImpl"})
@Service(value="shoppingCartService")
public class ShoppingCartServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<ShoppingCartMapper, ShoppingCartEntity>
implements ShoppingCartService {
    @Autowired
    private ShoppingCartMapper shoppingCartMapper;
    @Resource
    private CusAvailablelistService cusAvailablelistService;
    @Resource
    private MdmProductService mdmProductService;

    @Override
    @Klock(keys={"shoppingcartlock", "#shoppingCartVo.cusCode"}, waitTime=20L, leaseTime=5L)
    @Transactional
    public void add(ShoppingCartVo shoppingCartVo) {
        ValidateUtils.validate(shoppingCartVo.getGoodsCode(), "\u8bf7\u9009\u5b9a\u5546\u54c1");
        ValidateUtils.validate(shoppingCartVo.getNum(), "\u8bf7\u6307\u5b9a\u5546\u54c1\u6570\u91cf");
        if (shoppingCartVo.getNum() == null || shoppingCartVo.getNum() <= 0) {
            shoppingCartVo.setNum(Integer.valueOf(1));
        }
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"cus_code", (Object)shoppingCartVo.getCusCode())).eq((Object)"goods_code", (Object)shoppingCartVo.getGoodsCode());
        ShoppingCartEntity entity = (ShoppingCartEntity)this.shoppingCartMapper.selectOne((Wrapper)wrapper);
        if (null == entity) {
            entity = new ShoppingCartEntity();
            BeanUtils.copyProperties((Object)shoppingCartVo, (Object)entity);
            this.shoppingCartMapper.insert(entity);
            return;
        }
        entity.setNum(Integer.valueOf(entity.getNum() + shoppingCartVo.getNum()));
        this.shoppingCartMapper.updateById(entity);
    }

    @Override
    @Klock(keys={"shoppingcartlock", "#shoppingCartVo.cusCode"}, waitTime=20L, leaseTime=5L)
    @Transactional
    public void adjustNum(ShoppingCartVo shoppingCartVo) {
        ValidateUtils.validate(shoppingCartVo.getId(), "\u8bf7\u9009\u5b9a\u5546\u54c1");
        ValidateUtils.validate(shoppingCartVo.getNum(), "\u8bf7\u6307\u5b9a\u5546\u54c1\u6570\u91cf");
        ShoppingCartEntity entity = (ShoppingCartEntity)this.shoppingCartMapper.selectById((Serializable)((Object)shoppingCartVo.getId()));
        if (null == entity) {
            throw new BusinessException("\u8be5\u5546\u54c1\u5df2\u88ab\u79fb\u9664\u8d2d\u7269\u8f66");
        }
        entity.setNum(shoppingCartVo.getNum());
        if (entity.getNum() <= 0) {
            throw new BusinessException("\u6570\u91cf\u975e\u6cd5");
        }
        this.shoppingCartMapper.updateById(entity);
    }

    @Override
    public Map<String, List<ShoppingCartVo>> list(ShoppingCartVo shoppingCartVo) {
        ValidateUtils.validate(shoppingCartVo.getCusCode(), "\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ShoppingCartEntity::getCusCode, (Object)shoppingCartVo.getCusCode());
        wrapper.like(StringUtils.isNotEmpty((CharSequence)shoppingCartVo.getGoodsCode()), ShoppingCartEntity::getGoodsCode, (Object)shoppingCartVo.getGoodsCode());
        wrapper.like(StringUtils.isNotEmpty((CharSequence)shoppingCartVo.getGoodsName()), ShoppingCartEntity::getGoodsName, (Object)shoppingCartVo.getGoodsName());
        List entities = this.shoppingCartMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return new HashMap<String, List<ShoppingCartVo>>();
        }
        List<String> goodsCodes = entities.stream().map(ShoppingCartEntity::getGoodsCode).collect(Collectors.toList());
        Map<String, CusAvailablelistVo> goodsInfos = this.cusAvailablelistService.findGoodsByCusAndGoodsCodes(goodsCodes, shoppingCartVo.getCusCode());
        Map<String, List<MdmProductSaleCompanyRespVo>> salesCompanis = this.mdmProductService.findSaleCompanyByProductCodeList(goodsCodes);
        TreeMap<String, List<ShoppingCartVo>> reMap = new TreeMap<String, List<ShoppingCartVo>>((o, s) -> StringUtils.compare((String)o, (String)s));
        Map unitMap = DictUtil.getDictValueMapsByCodes((String)"product_sale_unit");
        for (ShoppingCartEntity entity : entities) {
            MdmProductSaleCompanyRespVo salesCompany = null;
            if (!CollectionUtils.isEmpty((Collection)salesCompanis.get(entity.getGoodsCode()))) {
                salesCompany = salesCompanis.get(entity.getGoodsCode()).get(0);
            }
            ShoppingCartVo vo = new ShoppingCartVo();
            BeanUtils.copyProperties((Object)entity, (Object)vo);
            if (null != salesCompany && !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{salesCompany.getSaleCompanyCode(), salesCompany.getSaleCompanyName()})) {
                vo.setSalesCompanyCode(salesCompany.getSaleCompanyCode());
                vo.setSalesCompanyName(salesCompany.getSaleCompanyName());
            } else {
                vo.setSalesCompanyCode("0");
                vo.setSalesCompanyName("");
            }
            CusAvailablelistVo goodsInfo = goodsInfos.get(entity.getGoodsCode());
            if (null == goodsInfo) {
                vo.setGoodsState(ShoppingCartEunm.goodsStateEunm.DOWNSHELF.getCode());
            } else {
                vo.setGoodsState(ShoppingCartEunm.goodsStateEunm.NORMAL.getCode());
                vo.setGoodsInfo(goodsInfos.get(entity.getGoodsCode()));
                vo.getGoodsInfo().setSaleUnitName((String)unitMap.get(vo.getGoodsInfo().getSaleUnit()));
            }
            if (!reMap.containsKey(vo.getSalesCompanyCode())) {
                reMap.put(vo.getSalesCompanyCode(), new ArrayList());
            }
            ((List)reMap.get(vo.getSalesCompanyCode())).add(vo);
        }
        return reMap;
    }

    @Override
    @Klock(keys={"shoppingcartlock", "#cusCode"}, waitTime=20L, leaseTime=5L)
    @Transactional
    public void delByIds(List<String> ids, String cusCode) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.shoppingCartMapper.deleteBatchIds(ids);
    }

    @Override
    @Transactional
    public void addBatch(List<ShoppingCartVo> shoppingCartVos) {
        ValidateUtils.validate(shoppingCartVos, "\u6279\u91cf\u52a0\u5165\u8d2d\u7269\u8f66\u65f6\uff0c\u53c2\u6570\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        UserRedis userRedis = UserUtils.getUser();
        shoppingCartVos.forEach(shoppingCartVo -> {
            shoppingCartVo.setCusCode(userRedis.getCustcode());
            shoppingCartVo.setAccount(userRedis.getUsername());
            this.add((ShoppingCartVo)shoppingCartVo);
        });
    }

    @Override
    @Transactional
    public void clearShoppingCar(String cusCode, List<String> productCodes) {
        if (StringUtils.isEmpty((CharSequence)cusCode) || CollectionUtil.listEmpty(productCodes)) {
            return;
        }
        List<ShoppingCartVo> vos = this.findByCusCodeAndProductCodes(cusCode, productCodes);
        if (CollectionUtil.listEmpty(vos)) {
            return;
        }
        List<String> ids = vos.stream().map(UuidVo::getId).collect(Collectors.toList());
        this.delByIds(ids, cusCode);
    }

    @Override
    public List<ShoppingCartVo> findByCusCodeAndProductCodes(String cusCode, List<String> productCodes) {
        if (StringUtils.isEmpty((CharSequence)cusCode) || CollectionUtil.listEmpty(productCodes)) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper wrappers = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ShoppingCartEntity::getCusCode, (Object)cusCode)).in(ShoppingCartEntity::getGoodsCode, productCodes);
        List entities = ((ShoppingCartMapper)this.getBaseMapper()).selectList((Wrapper)wrappers);
        if (CollectionUtil.listEmpty((List)entities)) {
            return Lists.newArrayList();
        }
        return CrmBeanUtil.copyList((List)entities, ShoppingCartVo.class);
    }
}

