/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.model.MdmCustomerContactEntity;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.service.MdmCustomerContactService;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.customer.service.MdmCustomerSupplyService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.MdmCustomerOrTerminalEnum;
import com.biz.crm.eunm.sfa.SfaVisitEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerContactReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapDistrictRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmAmapDistrictStatisticianReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalCustomerElasticsearchPageReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalCustomerElasticsearchRespVo;
import com.biz.crm.position.model.MdmCustomerSupplyEntity;
import com.biz.crm.terminal.mapper.MdmTerminalElasticsearchRepository;
import com.biz.crm.terminal.model.MdmTerminalContactEntity;
import com.biz.crm.terminal.model.MdmTerminalCustomerElasticsearchEntity;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.model.MdmTerminalSupplyEntity;
import com.biz.crm.terminal.service.MdmTerminalContactService;
import com.biz.crm.terminal.service.MdmTerminalElasticsearchService;
import com.biz.crm.terminal.service.MdmTerminalROrgService;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.user.mapper.MdmUserMapper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.utils.EsBoolQueryBuilder;
import com.biz.crm.utils.EsBuilder;
import com.biz.crm.utils.EsScriptBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequestBuilder;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequestBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQueryBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class MdmTerminalElasticsearchServiceImpl
implements MdmTerminalElasticsearchService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalElasticsearchServiceImpl.class);
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private MdmTerminalElasticsearchRepository elasticsearchRepository;
    @Autowired
    private MdmTerminalService mdmTerminalService;
    @Autowired
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Autowired
    private MdmCustomerContactService mdmCustomerContactService;
    @Autowired
    private MdmCustomerSupplyService mdmCustomerSupplyService;
    @Autowired
    private MdmCustomerROrgService mdmCustomerROrgService;
    @Autowired
    private MdmTerminalContactService mdmTerminalContactService;
    @Autowired
    private MdmTerminalROrgService mdmTerminalROrgService;
    @Autowired
    private MdmTerminalSupplyService mdmTerminalSupplyService;
    @Autowired
    private MdmUserMapper mdmUserMapper;

    @Override
    @EsDataPermission(position="positionCodeList.keyword", org="orgCodeList.keyword")
    public PageResult<MdmTerminalCustomerElasticsearchRespVo> listWithPage(MdmTerminalCustomerElasticsearchPageReqVo pageReqVo) {
        Double latitude = null;
        Double longitude = null;
        try {
            if (pageReqVo.getLatitude() != null) {
                latitude = Double.parseDouble(pageReqVo.getLatitude());
                Assert.isTrue((latitude >= 0.0 && latitude <= 90.0 ? 1 : 0) != 0, (String)("\u4e0d\u5408\u6cd5\u7684\u7eac\u5ea6:" + latitude));
            }
            if (pageReqVo.getLongitude() != null) {
                longitude = Double.parseDouble(pageReqVo.getLongitude());
            }
        }
        catch (NumberFormatException e) {
            log.error("\u5ba2\u6237\u7ec8\u7aef\u67e5\u8be2:" + e);
        }
        double distance = pageReqVo.getDistance() == null ? 5000.0 : pageReqVo.getDistance();
        Double finalLatitude = latitude;
        Double finalLongitude = longitude;
        BoolQueryBuilder boolQuery = EsBoolQueryBuilder.lambdaQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"enableStatus", (String)CrmEnableStatusEnum.ENABLE.getCode())).must(!StringUtils.isEmpty((CharSequence)pageReqVo.getName()), () -> QueryBuilders.matchPhraseQuery((String)"name", (Object)pageReqVo.getName())).must(!StringUtils.isEmpty((CharSequence)pageReqVo.getContactName()), () -> QueryBuilders.matchPhraseQuery((String)"contactName", (Object)pageReqVo.getContactName())).filter(!StringUtils.isEmpty((CharSequence)pageReqVo.getClientSubclass()), () -> QueryBuilders.termQuery((String)"clientSubClass.keyword", (String)pageReqVo.getClientSubclass())).filter(!StringUtils.isEmpty((CharSequence)pageReqVo.getClientType()), () -> QueryBuilders.termQuery((String)"clientType.keyword", (String)pageReqVo.getClientType())).filter(!StringUtils.isEmpty((CharSequence)pageReqVo.getChannel()), () -> QueryBuilders.termQuery((String)"channel.keyword", (String)pageReqVo.getChannel())).filter(latitude != null && longitude != null, () -> QueryBuilders.geoDistanceQuery((String)"placePoint").point(finalLatitude.doubleValue(), finalLongitude.doubleValue()).distance(distance, DistanceUnit.METERS)).build();
        EsBuilder esBuilder = EsBuilder.lambdaQuery().withQuery((QueryBuilder)boolQuery).withPageable(pageReqVo.getPageNum() - 1, pageReqVo.getPageSize());
        if (latitude != null && longitude != null) {
            esBuilder = esBuilder.withSort(latitude != null && longitude != null, () -> (GeoDistanceSortBuilder)SortBuilders.geoDistanceSort((String)"placePoint", (double)finalLatitude, (double)finalLongitude).unit(DistanceUnit.METERS).order(SortOrder.ASC));
        }
        PageResult<MdmTerminalCustomerElasticsearchEntity> pageResult = esBuilder.queryForPage(this.elasticsearchTemplate, MdmTerminalCustomerElasticsearchEntity.class);
        Map customerTypeMap = DictUtil.dictMap((String)"customer_type");
        Map terminalTypeMap = DictUtil.dictMap((String)"terminal_type");
        List data = pageResult.getData().stream().map(item -> {
            MdmTerminalCustomerElasticsearchRespVo respVo = (MdmTerminalCustomerElasticsearchRespVo)CrmBeanUtil.copy((Object)item, MdmTerminalCustomerElasticsearchRespVo.class);
            if (finalLatitude != null && finalLongitude != null) {
                respVo.setDistance((int)(GeoDistance.PLANE.calculate(Double.parseDouble(item.getLatitude()), Double.parseDouble(item.getLongitude()), finalLatitude.doubleValue(), finalLongitude.doubleValue(), DistanceUnit.METERS) + 0.5));
            }
            if (!StringUtils.isEmpty((CharSequence)respVo.getClientSubclass())) {
                if (SfaVisitEnum.ClientType.TERMINAL.getVal().equals(respVo.getClientType())) {
                    respVo.setClientSubclassName((String)terminalTypeMap.get(respVo.getClientSubclass()));
                } else {
                    respVo.setClientSubclassName((String)customerTypeMap.get(respVo.getClientSubclass()));
                }
            }
            respVo.setClientTypeName((String)SfaVisitEnum.ClientType.GETMAP.get(respVo.getClientType()));
            return respVo;
        }).collect(Collectors.toList());
        return PageResult.builder().count(pageResult.getCount()).data(data).build();
    }

    public void translationType(List<MdmTerminalCustomerElasticsearchEntity> list) {
        if (CollectionUtil.listNotEmpty(list)) {
            list.forEach(o -> {
                if (o.getClientType().equals(SfaVisitEnum.ClientType.DEALER.getVal())) {
                    o.setClientTypeName(SfaVisitEnum.ClientType.DEALER.getDesc());
                    if (StringUtils.isNotEmpty((CharSequence)o.getClientSubclass())) {
                        o.setClientSubclassName((String)MdmCustomerOrTerminalEnum.customerType.GETMAP.get(o.getClientSubclass()));
                    }
                } else if (o.getClientType().equals(SfaVisitEnum.ClientType.TERMINAL.getVal())) {
                    o.setClientTypeName(SfaVisitEnum.ClientType.TERMINAL.getDesc());
                    if (StringUtils.isNotEmpty((CharSequence)o.getClientSubclass())) {
                        o.setClientSubclassName((String)MdmCustomerOrTerminalEnum.terminalType.GETMAP.get(o.getClientSubclass()));
                    }
                }
            });
        }
    }

    @Override
    public void add(MdmTerminalVo mdmTerminalVo, MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        if (!this.elasticsearchTemplate.indexExists("mdm_terminal_customer_index3")) {
            this.elasticsearchTemplate.createIndex(MdmTerminalCustomerElasticsearchEntity.class);
        }
        if (!(mdmTerminalVo == null || StringUtils.isEmpty((CharSequence)mdmTerminalVo.getLongitude()) || StringUtils.isEmpty((CharSequence)mdmTerminalVo.getLatitude()) || CollectionUtils.isEmpty((Collection)mdmTerminalVo.getSupplys()))) {
            List customerCodeList;
            List positionCodeList;
            List supplys;
            List mainContact;
            MdmTerminalCustomerElasticsearchEntity elasticsearchEntity = (MdmTerminalCustomerElasticsearchEntity)CrmBeanUtil.copy((Object)mdmTerminalVo, MdmTerminalCustomerElasticsearchEntity.class);
            elasticsearchEntity.setName(mdmTerminalVo.getTerminalName());
            elasticsearchEntity.setCode(mdmTerminalVo.getTerminalCode());
            elasticsearchEntity.setPlacePoint(mdmTerminalVo.getLatitude() + "," + mdmTerminalVo.getLongitude());
            List contacts = mdmTerminalVo.getContacts();
            if (!CollectionUtils.isEmpty((Collection)contacts) && !CollectionUtils.isEmpty(mainContact = mdmTerminalVo.getContacts().stream().filter(x -> YesNoEnum.yesNoEnum.ONE.getValue().equals(x.getContactMain())).collect(Collectors.toList()))) {
                elasticsearchEntity.setContactName(((MdmTerminalContactVo)mainContact.get(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).getContactName());
            }
            supplys = (supplys = mdmTerminalVo.getSupplys()) == null ? new ArrayList() : supplys;
            elasticsearchEntity.setPositionCodes(supplys.stream().map(MdmTerminalSupplyVo::getPositionCode).collect(Collectors.joining(";")));
            if (!CollectionUtils.isEmpty((Collection)mdmTerminalVo.getContacts())) {
                elasticsearchEntity.setContactPhone(mdmTerminalVo.getContacts().stream().map(MdmTerminalContactVo::getContactPhone).collect(Collectors.joining(";")));
            }
            elasticsearchEntity.setAddress(mdmTerminalVo.getTerminalAddress());
            elasticsearchEntity.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
            elasticsearchEntity.setClientSubclass(mdmTerminalVo.getTerminalType());
            elasticsearchEntity.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
            elasticsearchEntity.setClientSubclass(mdmTerminalVo.getTerminalType());
            if (!StringUtils.isEmpty((CharSequence)mdmTerminalVo.getOrgCode())) {
                elasticsearchEntity.setOrgCodeList(Arrays.asList(mdmTerminalVo.getOrgCode().split(",")));
            }
            if (!CollectionUtils.isEmpty(positionCodeList = supplys.stream().map(MdmTerminalSupplyVo::getPositionCode).filter(x -> !StringUtils.isEmpty((CharSequence)x)).distinct().collect(Collectors.toList()))) {
                elasticsearchEntity.setPositionCodeList(positionCodeList);
            }
            if (!CollectionUtils.isEmpty(customerCodeList = supplys.stream().map(MdmTerminalSupplyVo::getCustomerCode).filter(x -> !StringUtils.isEmpty((CharSequence)x)).distinct().collect(Collectors.toList()))) {
                elasticsearchEntity.setCustomerCodeList(customerCodeList);
            }
            this.elasticsearchRepository.save(elasticsearchEntity);
            return;
        }
        if (!(mdmCustomerMsgReqVo == null || StringUtils.isEmpty((CharSequence)mdmCustomerMsgReqVo.getLongitude()) || StringUtils.isEmpty((CharSequence)mdmCustomerMsgReqVo.getLatitude()) || CollectionUtils.isEmpty((Collection)mdmCustomerMsgReqVo.getMdmCustomerDockingVos()))) {
            List mainContact;
            MdmTerminalCustomerElasticsearchEntity elasticsearchEntity = (MdmTerminalCustomerElasticsearchEntity)CrmBeanUtil.copy((Object)mdmCustomerMsgReqVo, MdmTerminalCustomerElasticsearchEntity.class);
            elasticsearchEntity.setName(mdmCustomerMsgReqVo.getUserName());
            elasticsearchEntity.setCode(mdmCustomerMsgReqVo.getCustomerCode());
            elasticsearchEntity.setPlacePoint(mdmCustomerMsgReqVo.getLatitude() + "," + mdmCustomerMsgReqVo.getLongitude());
            if (!CollectionUtils.isEmpty((Collection)mdmCustomerMsgReqVo.getMdmCustomerContactVos()) && !CollectionUtils.isEmpty(mainContact = mdmCustomerMsgReqVo.getMdmCustomerContactVos().stream().filter(x -> YesNoEnum.yesNoEnum.ONE.getValue().equals(x.getContactMain())).collect(Collectors.toList()))) {
                elasticsearchEntity.setContactName(((MdmCustomerContactReqVo)mainContact.get(YesNoEnum.YesNoCodeNumberEnum.NO.getCode())).getContactName());
            }
            if (mdmCustomerMsgReqVo.getMdmCustomerDockingVos() != null) {
                elasticsearchEntity.setPositionCodes(mdmCustomerMsgReqVo.getMdmCustomerDockingVos().stream().map(MdmCustomerDockingReqVo::getPositionCode).collect(Collectors.joining(";")));
                List positionCodeList = mdmCustomerMsgReqVo.getMdmCustomerDockingVos().stream().map(MdmCustomerDockingReqVo::getPositionCode).filter(x -> !StringUtils.isEmpty((CharSequence)x)).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(positionCodeList)) {
                    elasticsearchEntity.setPositionCodeList(positionCodeList);
                }
            }
            elasticsearchEntity.setContactPhone(mdmCustomerMsgReqVo.getCustomerContact());
            elasticsearchEntity.setAddress(mdmCustomerMsgReqVo.getRegisteredAddress());
            elasticsearchEntity.setClientType(SfaVisitEnum.ClientType.DEALER.getVal());
            elasticsearchEntity.setClientSubclass(mdmCustomerMsgReqVo.getCustomerType());
            if (!StringUtils.isEmpty((CharSequence)mdmCustomerMsgReqVo.getOrgCode())) {
                elasticsearchEntity.setOrgCodeList(Arrays.asList(mdmCustomerMsgReqVo.getOrgCode().split(",")));
            }
            this.elasticsearchRepository.save(elasticsearchEntity);
        }
    }

    @Override
    public void add(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        List mdmCustomerContactVos;
        List<String> positionCodeList;
        Assert.notNull((Object)mdmCustomerMsgReqVo, (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmCustomerMsgReqVo.getId(), (String)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        MdmTerminalCustomerElasticsearchEntity entity = (MdmTerminalCustomerElasticsearchEntity)CrmBeanUtil.copy((Object)mdmCustomerMsgReqVo, MdmTerminalCustomerElasticsearchEntity.class);
        entity.setName(mdmCustomerMsgReqVo.getCustomerName());
        entity.setCode(mdmCustomerMsgReqVo.getCustomerCode());
        String latitude = mdmCustomerMsgReqVo.getLatitude();
        String longitude = mdmCustomerMsgReqVo.getLongitude();
        if (!StringUtils.isEmpty((CharSequence)latitude) && !StringUtils.isEmpty((CharSequence)longitude)) {
            try {
                Double.valueOf(latitude);
                Double.valueOf(longitude);
                entity.setPlacePoint(latitude + "," + longitude);
            }
            catch (NumberFormatException e) {
                log.error("\u7ecf\u7eac\u5ea6\u683c\u5f0f\u9519\u8bef" + latitude + ":" + longitude);
            }
        }
        entity.setAddress(mdmCustomerMsgReqVo.getRegisteredAddress());
        entity.setClientType(SfaVisitEnum.ClientType.DEALER.getVal());
        entity.setClientSubclass(mdmCustomerMsgReqVo.getCustomerType());
        if (!StringUtils.isEmpty((CharSequence)mdmCustomerMsgReqVo.getOrgCode())) {
            entity.setOrgCodeList(Arrays.asList(mdmCustomerMsgReqVo.getOrgCode().split(",")));
        }
        if (mdmCustomerMsgReqVo.getMdmCustomerDockingVos() != null && !CollectionUtils.isEmpty(positionCodeList = mdmCustomerMsgReqVo.getMdmCustomerDockingVos().stream().map(MdmCustomerDockingReqVo::getPositionCode).filter(x -> !StringUtils.isEmpty((CharSequence)x)).distinct().collect(Collectors.toList()))) {
            entity.setPositionCodeList(positionCodeList);
            List<String> nameList = this.mdmUserMapper.findSupplyNameList(positionCodeList);
            if (!CollectionUtils.isEmpty(nameList)) {
                entity.setSupplyNameList(nameList);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(mdmCustomerContactVos = mdmCustomerMsgReqVo.getMdmCustomerContactVos()))) {
            mdmCustomerContactVos.stream().filter(x -> String.valueOf(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()).equals(x.getContactMain())).findAny().ifPresent(x -> {
                entity.setContactName(x.getContactName());
                entity.setContactPhone(x.getContactPhone());
            });
        }
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.elasticsearchRepository.save(entity);
    }

    @Override
    public void add(MdmTerminalVo mdmTerminalVo) {
        List supplys;
        List contacts;
        Assert.notNull((Object)mdmTerminalVo, (String)"\u7ec8\u7aef\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmTerminalVo.getId(), (String)"\u7ec8\u7aefid\u4e0d\u80fd\u4e3a\u7a7a");
        MdmTerminalCustomerElasticsearchEntity entity = (MdmTerminalCustomerElasticsearchEntity)CrmBeanUtil.copy((Object)mdmTerminalVo, MdmTerminalCustomerElasticsearchEntity.class);
        entity.setName(mdmTerminalVo.getTerminalName());
        entity.setCode(mdmTerminalVo.getTerminalCode());
        String latitude = mdmTerminalVo.getLatitude();
        String longitude = mdmTerminalVo.getLongitude();
        if (!StringUtils.isEmpty((CharSequence)latitude) && !StringUtils.isEmpty((CharSequence)longitude)) {
            try {
                Double.valueOf(latitude);
                Double.valueOf(longitude);
                entity.setPlacePoint(latitude + "," + longitude);
            }
            catch (NumberFormatException e) {
                log.error("\u7ecf\u7eac\u5ea6\u683c\u5f0f\u9519\u8bef" + latitude + ":" + longitude);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(contacts = mdmTerminalVo.getContacts()))) {
            contacts.stream().filter(x -> String.valueOf(YesNoEnum.YesNoCodeNumberEnum.YES.getCode()).equals(x.getContactMain())).findAny().ifPresent(x -> {
                entity.setContactPhone(x.getContactPhone());
                entity.setContactName(x.getContactName());
            });
        }
        if (!CollectionUtils.isEmpty((Collection)(supplys = mdmTerminalVo.getSupplys()))) {
            List customerCodeList;
            List positionCodeList = supplys.stream().map(MdmTerminalSupplyVo::getPositionCode).filter(x -> !StringUtils.isEmpty((CharSequence)x)).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(positionCodeList)) {
                entity.setPositionCodeList(positionCodeList);
            }
            if (!CollectionUtils.isEmpty(customerCodeList = supplys.stream().map(MdmTerminalSupplyVo::getCustomerCode).filter(x -> !StringUtils.isEmpty((CharSequence)x)).distinct().collect(Collectors.toList()))) {
                entity.setCustomerCodeList(customerCodeList);
            }
        }
        entity.setAddress(mdmTerminalVo.getTerminalAddress());
        entity.setClientType(SfaVisitEnum.ClientType.TERMINAL.getVal());
        entity.setClientSubclass(mdmTerminalVo.getTerminalType());
        if (!StringUtils.isEmpty((CharSequence)mdmTerminalVo.getOrgCode())) {
            entity.setOrgCodeList(Arrays.asList(mdmTerminalVo.getOrgCode().split(",")));
        }
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        this.elasticsearchRepository.save(entity);
        this.elasticsearchTemplate.refresh("mdm_terminal_customer_index3");
    }

    @Override
    public void delete(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        ((DeleteByQueryRequestBuilder)((DeleteByQueryRequestBuilder)DeleteByQueryAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this.elasticsearchTemplate.getClient()).source(new String[]{"mdm_terminal_customer_index3"})).filter((QueryBuilder)QueryBuilders.termsQuery((String)"id.keyword", ids))).get();
    }

    @Override
    public void reset() {
        if (this.elasticsearchTemplate.indexExists("mdm_terminal_customer_index3")) {
            this.elasticsearchRepository.deleteAll();
        }
        this.resetCustomer();
        this.resetTerminal();
    }

    @Override
    public List<MdmAmapDistrictRespVo> listCondition(MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo) {
        List statisticianTypeList = mdmAmapDistrictStatisticianReqVo.getStatisticianTypeList();
        String amapDistrictCode = mdmAmapDistrictStatisticianReqVo.getAmapDistrictCode();
        String customerOrTerminalName = mdmAmapDistrictStatisticianReqVo.getCustomerOrTerminalName();
        String supplyFullName = mdmAmapDistrictStatisticianReqVo.getSupplyFullName();
        NativeSearchQueryBuilder queryBuilder = new NativeSearchQueryBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!CollectionUtils.isEmpty((Collection)statisticianTypeList)) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"clientSubclass.keyword", (Collection)statisticianTypeList));
        }
        if (!StringUtils.isEmpty((CharSequence)amapDistrictCode)) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"districtCode.keyword", (String)amapDistrictCode));
        }
        if (!StringUtils.isEmpty((CharSequence)customerOrTerminalName)) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"name", (Object)customerOrTerminalName));
        }
        if (!StringUtils.isEmpty((CharSequence)supplyFullName)) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"supplyNameList", (Object)supplyFullName));
        }
        Integer pageNum = Optional.ofNullable(mdmAmapDistrictStatisticianReqVo.getPageNum()).orElse(0);
        Integer pageSize = Optional.ofNullable(mdmAmapDistrictStatisticianReqVo.getPageSize()).orElse(1000);
        NativeSearchQuery query = queryBuilder.withFilter((QueryBuilder)boolQueryBuilder).withPageable((Pageable)PageRequest.of((int)pageNum, (int)pageSize)).build();
        List entityList = this.elasticsearchTemplate.queryForList((SearchQuery)query, MdmTerminalCustomerElasticsearchEntity.class);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return Collections.emptyList();
        }
        return entityList.stream().map(x -> {
            String[] split;
            MdmAmapDistrictRespVo respVo = new MdmAmapDistrictRespVo();
            respVo.setAmapCode(amapDistrictCode);
            respVo.setStatisticianCode(x.getCode());
            respVo.setStatisticianName(x.getName());
            respVo.setStatisticianAddress(x.getAddress());
            respVo.setStatisticianType(x.getClientSubclass());
            respVo.setStatisticianContactName(x.getContactName());
            respVo.setStatisticianContactPhone(x.getContactPhone());
            String placePoint = x.getPlacePoint();
            if (!StringUtils.isEmpty((CharSequence)placePoint) && (split = placePoint.split(",")).length > 1) {
                respVo.setLatitude(split[0]);
                respVo.setLongitude(split[1]);
            }
            return respVo;
        }).collect(Collectors.toList());
    }

    @Override
    public void enable(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        BulkByScrollResponse response = (BulkByScrollResponse)((UpdateByQueryRequestBuilder)((UpdateByQueryRequestBuilder)((UpdateByQueryRequestBuilder)UpdateByQueryAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this.elasticsearchTemplate.getClient()).source(new String[]{"mdm_terminal_customer_index3"})).filter((QueryBuilder)QueryBuilders.termsQuery((String)"id", ids))).script(EsScriptBuilder.updateScript(Collections.singletonMap("enableStatus", CrmEnableStatusEnum.ENABLE.getCode())))).get();
    }

    @Override
    public void disable(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        BulkByScrollResponse response = (BulkByScrollResponse)((UpdateByQueryRequestBuilder)((UpdateByQueryRequestBuilder)((UpdateByQueryRequestBuilder)UpdateByQueryAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this.elasticsearchTemplate.getClient()).source(new String[]{"mdm_terminal_customer_index3"})).filter((QueryBuilder)QueryBuilders.termsQuery((String)"id", ids))).script(EsScriptBuilder.updateScript(Collections.singletonMap("enableStatus", CrmEnableStatusEnum.DISABLE.getCode())))).get();
    }

    @Override
    public void updateByCodeList(List<String> codeList, Map<String, Object> map) {
        if (!CollectionUtils.isEmpty(codeList) && !ObjectUtils.isEmpty(map)) {
            ((UpdateByQueryRequestBuilder)((UpdateByQueryRequestBuilder)((UpdateByQueryRequestBuilder)UpdateByQueryAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this.elasticsearchTemplate.getClient()).source(new String[]{"mdm_terminal_customer_index3"})).filter((QueryBuilder)QueryBuilders.termsQuery((String)"code.keyword", codeList))).script(EsScriptBuilder.updateScript(map))).get();
        }
    }

    @Override
    public void updateById(String id, Map<String, Object> params) {
        Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        if (params == null || params.size() < 1) {
            return;
        }
        UpdateRequest updateRequest = new UpdateRequest();
        updateRequest.doc(params);
        UpdateQuery build = new UpdateQueryBuilder().withUpdateRequest(updateRequest).withClass(MdmTerminalCustomerElasticsearchEntity.class).withId(id).build();
        this.elasticsearchTemplate.update(build);
    }

    private void resetTerminal() {
        List list = this.mdmTerminalService.lambdaQuery().list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List<String> terminalCodeList = list.stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList());
        Map<String, List<String>> orgCodeMap = this.mdmTerminalROrgService.findOrgCodeList(terminalCodeList);
        Map contactEntityMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmTerminalContactService.lambdaQuery().in(MdmTerminalContactEntity::getTerminalCode, terminalCodeList)).eq(MdmTerminalContactEntity::getContactMain, (Object)YesNoEnum.yesNoEnum.ONE.getValue())).select(new SFunction[]{MdmTerminalContactEntity::getTerminalCode, MdmTerminalContactEntity::getContactName, MdmTerminalContactEntity::getContactPhone}).list().stream().collect(Collectors.toMap(MdmTerminalContactEntity::getTerminalCode, Function.identity()));
        Map<String, List<MdmTerminalSupplyEntity>> supplyMap = ((LambdaQueryChainWrapper)this.mdmTerminalSupplyService.lambdaQuery().in(MdmTerminalSupplyEntity::getTerminalCode, terminalCodeList)).select(new SFunction[]{MdmTerminalSupplyEntity::getTerminalCode, MdmTerminalSupplyEntity::getCustomerCode, MdmTerminalSupplyEntity::getPositionCode}).list().stream().collect(Collectors.groupingBy(MdmTerminalSupplyEntity::getTerminalCode));
        list.parallelStream().forEach(x -> {
            List supplyEntities;
            MdmTerminalContactEntity contactEntity;
            MdmTerminalVo terminalVo = (MdmTerminalVo)CrmBeanUtil.copy((Object)x, MdmTerminalVo.class);
            List orgCodeList = (List)orgCodeMap.get(x.getTerminalCode());
            if (!CollectionUtils.isEmpty((Collection)orgCodeList)) {
                terminalVo.setOrgCode(String.join((CharSequence)",", orgCodeList));
            }
            if ((contactEntity = (MdmTerminalContactEntity)contactEntityMap.get(terminalVo.getTerminalCode())) != null) {
                MdmTerminalContactVo contactVo = new MdmTerminalContactVo();
                contactVo.setContactMain(YesNoEnum.yesNoEnum.ONE.getValue());
                contactVo.setContactName(contactEntity.getContactName());
                contactVo.setContactPhone(contactEntity.getContactPhone());
                contactVo.setTerminalCode(terminalVo.getTerminalCode());
                terminalVo.setContacts(Collections.singletonList(contactVo));
            }
            if ((supplyEntities = (List)supplyMap.get(terminalVo.getTerminalCode())) != null) {
                List supplyVos = CrmBeanUtil.copyList((List)supplyEntities, MdmTerminalSupplyVo.class);
                terminalVo.setSupplys(supplyVos);
            }
            this.add(terminalVo);
        });
    }

    private void resetCustomer() {
        List customerEntities = this.mdmCustomerMsgService.lambdaQuery().list();
        if (!CollectionUtils.isEmpty((Collection)customerEntities)) {
            Lists.partition((List)customerEntities, (int)500).parallelStream().forEach(x -> {
                List mdmCustomerMsgReqVos = CrmBeanUtil.copyList((List)x, MdmCustomerMsgReqVo.class);
                List<String> customerCodeList = x.stream().map(MdmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                Map contactEntityMap = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmCustomerContactService.lambdaQuery().in(MdmCustomerContactEntity::getCustomerCode, customerCodeList)).eq(MdmCustomerContactEntity::getContactMain, (Object)YesNoEnum.yesNoEnum.ONE.getValue())).select(new SFunction[]{MdmCustomerContactEntity::getCustomerCode, MdmCustomerContactEntity::getContactName, MdmCustomerContactEntity::getContactPhone}).list().stream().collect(Collectors.toMap(MdmCustomerContactEntity::getCustomerCode, Function.identity(), (x1, x2) -> x1));
                Map supplyMap = ((LambdaQueryChainWrapper)this.mdmCustomerSupplyService.lambdaQuery().in(MdmCustomerSupplyEntity::getCustomerCode, customerCodeList)).select(new SFunction[]{MdmCustomerSupplyEntity::getPositionCode, MdmCustomerSupplyEntity::getCustomerCode}).list().stream().collect(Collectors.groupingBy(MdmCustomerSupplyEntity::getCustomerCode, Collectors.mapping(MdmCustomerSupplyEntity::getPositionCode, Collectors.toList())));
                Map<String, List<String>> orgMap = this.mdmCustomerROrgService.findOrgCodeList(customerCodeList);
                for (MdmCustomerMsgReqVo mdmCustomerMsgReqVo : mdmCustomerMsgReqVos) {
                    List<String> orgCodeList;
                    List positionCodeList;
                    String customerCode = mdmCustomerMsgReqVo.getCustomerCode();
                    MdmCustomerContactEntity mdmCustomerContactEntity = (MdmCustomerContactEntity)contactEntityMap.get(customerCode);
                    if (mdmCustomerContactEntity != null) {
                        mdmCustomerContactEntity.setContactMain(YesNoEnum.yesNoEnum.ONE.getValue());
                        mdmCustomerMsgReqVo.setMdmCustomerContactVos(Collections.singletonList(CrmBeanUtil.copy((Object)mdmCustomerContactEntity, MdmCustomerContactReqVo.class)));
                    }
                    if (!CollectionUtils.isEmpty(positionCodeList = supplyMap.get(customerCode))) {
                        List dockingReqVos = positionCodeList.stream().map(k -> {
                            MdmCustomerDockingReqVo mdmCustomerDockingReqVo = new MdmCustomerDockingReqVo();
                            mdmCustomerDockingReqVo.setCustomerCode(customerCode);
                            mdmCustomerDockingReqVo.setPositionCode(k);
                            return mdmCustomerDockingReqVo;
                        }).collect(Collectors.toList());
                        mdmCustomerMsgReqVo.setMdmCustomerDockingVos(dockingReqVos);
                    }
                    if (!CollectionUtils.isEmpty(orgCodeList = orgMap.get(customerCode))) {
                        mdmCustomerMsgReqVo.setOrgCode(String.join((CharSequence)",", orgCodeList));
                    }
                    this.add(mdmCustomerMsgReqVo);
                }
            });
        }
    }
}

