/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.sfa.SfaVisitStatisticsTypeEnum;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalFormReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalFormRespVo;
import com.biz.crm.terminal.mapper.MdmTerminalFormMapper;
import com.biz.crm.terminal.service.MdmTerminalFormService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MdmTerminalFormServiceImpl
implements MdmTerminalFormService {
    @Resource
    private MdmTerminalFormMapper mdmTerminalFormMapper;

    @Override
    public PageResult<MdmTerminalFormRespVo> findList(MdmTerminalFormReqVo reqVo) {
        SfaVisitStatisticsTypeEnum.VisitStatisticsTypeEnum visitStatisticsType = SfaVisitStatisticsTypeEnum.VisitStatisticsTypeEnum.getByCode((String)reqVo.getVisitStatisticsType());
        AssertUtils.isNotNull((Object)visitStatisticsType, (String)"\u672a\u77e5\u7684\u62dc\u8bbf\u67e5\u770b\u7c7b\u578b");
        int week = 0;
        Integer month = 0;
        AssertUtils.isNotEmpty((String)reqVo.getQueryTime(), (String)"\u8bf7\u9009\u62e9\u67e5\u8be2\u65e5\u671f");
        if (visitStatisticsType != null) {
            Date parse = DateUtil.parse((String)reqVo.getQueryTime(), (String)"yyyy-MM-dd");
            switch (visitStatisticsType) {
                case WEEK: {
                    Date mondayDate = DateUtil.getFirstDayOfWeek((Date)parse);
                    Calendar now = Calendar.getInstance();
                    now.setTime(mondayDate);
                    week = now.get(4);
                    now.add(5, 6);
                    String monday = DateUtil.getYYYYMMDD((Date)mondayDate);
                    String sunday = DateUtil.getYYYYMMDD((Date)now.getTime());
                    reqVo.setStartTime(monday);
                    reqVo.setEndTime(sunday);
                    reqVo.setQueryTime(reqVo.getQueryTime().substring(0, 7));
                    break;
                }
                case MONTH: {
                    reqVo.setQueryTime(reqVo.getQueryTime().substring(0, 7));
                    month = Integer.parseInt(reqVo.getQueryTime().substring(5, 7));
                    break;
                }
            }
        }
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmTerminalFormRespVo> list = this.mdmTerminalFormMapper.findList((Page<MdmTerminalFormRespVo>)page, reqVo);
        String weekStr = "\u7b2c" + week + "\u5468";
        for (MdmTerminalFormRespVo v : list) {
            v.setDate(reqVo.getQueryTime());
            if (visitStatisticsType == SfaVisitStatisticsTypeEnum.VisitStatisticsTypeEnum.WEEK) {
                v.setWeek(weekStr);
            }
            if (visitStatisticsType != SfaVisitStatisticsTypeEnum.VisitStatisticsTypeEnum.MONTH) continue;
            v.setMonth(month.toString());
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

