/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.controller;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelWeChatReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelWeChatRespVo;
import com.biz.crm.user.service.MdmUserRelWeChatService;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmUserRelWeChatController"})
@Api(tags={"MDM-\u7528\u6237\u7ba1\u7406-\u5173\u8054\u5fae\u4fe1"})
public class MdmUserRelWeChatController {
    private static final Logger log = LoggerFactory.getLogger(MdmUserRelWeChatController.class);
    @Autowired
    private MdmUserRelWeChatService mdmUserRelWeChatService;

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u5173\u8054\u7684\u5fae\u4fe1\u5217\u8868", httpMethod="POST")
    @PostMapping(value={"/findUserRelWeChatList"})
    public Result<List<MdmUserRelWeChatRespVo>> findUserRelWeChatList(@RequestBody MdmUserRelWeChatReqVo reqVo) {
        return Result.ok(this.mdmUserRelWeChatService.findUserRelWeChatList(reqVo));
    }

    @ApiOperation(value="\u89e3\u7ed1\u6307\u5b9a\u5173\u8054\u7684\u5fae\u4fe1", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u7528\u6237\u5173\u8054\u5fae\u4fe1\u8868\u7684id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/unbindUserWeChat"})
    public Result unbindUserWeChat(@RequestBody List<String> ids) {
        this.mdmUserRelWeChatService.unbindByIds(ids);
        return Result.ok((String)"\u89e3\u7ed1\u6210\u529f");
    }

    @ApiOperation(value="\u7ed1\u5b9a\u6307\u5b9a\u5173\u8054\u7684\u5fae\u4fe1", httpMethod="POST")
    @PostMapping(value={"/bindUserWeChat"})
    public Result bindUserWeChat(@RequestParam(value="openId") String openId, @RequestParam(value="fromType") String fromType) {
        MdmUserRelWeChatReqVo bindReq = new MdmUserRelWeChatReqVo();
        UserRedis user = UserUtils.getUser();
        bindReq.setUserName(user.getUsername());
        bindReq.setOriginModule(fromType);
        bindReq.setLoginStatus(YesNoEnum.yesNoEnum.ONE.getValue());
        bindReq.setOpenId(openId);
        this.mdmUserRelWeChatService.bind(bindReq);
        return Result.ok((String)"\u7ed1\u5b9a\u6210\u529f");
    }

    @ApiOperation(value="\u7ed1\u5b9a\u6307\u5b9a\u5173\u8054\u7684\u5fae\u4fe1", httpMethod="POST")
    @PostMapping(value={"/bindUserWeChatVerificationPhone"})
    public Result bindUserWeChatVerificationPhone(@RequestParam(value="openId") String openId, @RequestParam(value="phone") String phone, @RequestParam(value="code") String code) {
        MdmUserRelWeChatReqVo bindReq = new MdmUserRelWeChatReqVo();
        UserRedis user = UserUtils.getUser();
        bindReq.setUserName(user.getUsername());
        bindReq.setOriginModule("applet_terminal");
        bindReq.setLoginStatus(YesNoEnum.yesNoEnum.ONE.getValue());
        bindReq.setOpenId(openId);
        this.mdmUserRelWeChatService.bindUserWeChatVerificationPhone(bindReq, phone, code);
        return Result.ok((String)"\u7ed1\u5b9a\u6210\u529f");
    }
}

