/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.utils;

import com.biz.crm.availablelist.entity.CusAvailablelistEntity;
import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleAreaVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleGoodsVo;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAndOrgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.stereotype.Component;

@Component
public class EsSynchronismUtil {
    private static final Logger log = LoggerFactory.getLogger(EsSynchronismUtil.class);
    @Autowired
    private MdmProductService mdmProductService;
    @Autowired
    private CusAvailablelistService cusAvailablelistService;
    @Autowired
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public void addEs(AvailableListRuleVo availableListRuleVo, String ruleCode) {
        log.info("\u65b0\u589e\u53ef\u8d2d\u89c4\u5219\u540e\u5f00\u59cb\u540c\u6b65es\u4fe1\u606f----");
        if (CollectionUtils.isEmpty((Collection)availableListRuleVo.getAreaes()) || CollectionUtils.isEmpty((Collection)availableListRuleVo.getGoods())) {
            return;
        }
        List goodsCodes = availableListRuleVo.getGoods();
        List<String> goodsCodeList = goodsCodes.stream().map(AvailableListRuleGoodsVo::getGoodsCode).collect(Collectors.toList());
        List<String> goodsLevelCodeList = goodsCodes.stream().map(AvailableListRuleGoodsVo::getProductLevelCode).collect(Collectors.toList());
        List<MdmProductRespVo> mdmProductRespVos = this.mdmProductService.queryBatchByProductLevelCodeList(goodsLevelCodeList);
        List<String> goodsCodeLists = mdmProductRespVos.stream().map(MdmProductRespVo::getProductCode).collect(Collectors.toList());
        List<Object> goods = Lists.newArrayList();
        goods = CollectionUtils.isNotEmpty(goodsCodeList) ? this.mdmProductService.adviseQuery(goodsCodeList) : this.mdmProductService.adviseQuery(goodsCodeLists);
        List areaes = availableListRuleVo.getAreaes();
        List cusCodes = areaes.stream().map(o -> o.getCusCode()).collect(Collectors.toList());
        List orgCodeLists = areaes.stream().map(AvailableListRuleAreaVo::getOrgCode).collect(Collectors.toList());
        MdmCustomerAndOrgReqVo customerAndOrgReqVo = new MdmCustomerAndOrgReqVo();
        customerAndOrgReqVo.setOrgCodeList(orgCodeLists);
        List cusCodeOrgLists = this.mdmCustomerMsgService.findCurrentAndSubCustomerList(customerAndOrgReqVo).stream().map(MdmCustomerMsgRespVo::getCustomerCode).collect(Collectors.toList());
        if (StringUtils.isNotEmpty((String)((String)cusCodes.get(0)))) {
            for (String cusCode : cusCodes) {
                this.cusAvailablelistService.syncCusAvailableList(goods, cusCode, ruleCode);
            }
        } else {
            for (String cusCode : cusCodeOrgLists) {
                this.cusAvailablelistService.syncCusAvailableList(goods, cusCode, ruleCode);
            }
        }
        log.info("\u5ba2\u6237\u53ef\u8d2d\u5546\u54c1\u5217\u8868\u4fe1\u606f\u540c\u6b65\u5b8c\u6210-----");
    }

    public void editEs(AvailableListRuleVo availableListRuleVo) {
        log.info("\u7f16\u8f91\u53ef\u8d2d\u89c4\u5219\u540e\u5f00\u59cb\u540c\u6b65es\u4fe1\u606f----");
        List goodsCodes = availableListRuleVo.getGoods();
        List<String> goodsCodeList = goodsCodes.stream().map(AvailableListRuleGoodsVo::getGoodsCode).collect(Collectors.toList());
        List<String> goodsLevelCodeList = goodsCodes.stream().map(AvailableListRuleGoodsVo::getProductLevelCode).collect(Collectors.toList());
        List<MdmProductRespVo> mdmProductRespVos = this.mdmProductService.queryBatchByProductLevelCodeList(goodsLevelCodeList);
        List<String> goodsCodeLists = mdmProductRespVos.stream().map(MdmProductRespVo::getProductCode).collect(Collectors.toList());
        List<Object> goods = Lists.newArrayList();
        goods = CollectionUtils.isNotEmpty(goodsCodeList) ? this.mdmProductService.adviseQuery(goodsCodeList) : this.mdmProductService.adviseQuery(goodsCodeLists);
        List areaes = availableListRuleVo.getAreaes();
        List cusCodes = areaes.stream().map(o -> o.getCusCode()).collect(Collectors.toList());
        List orgCodeLists = areaes.stream().map(AvailableListRuleAreaVo::getOrgCode).collect(Collectors.toList());
        MdmCustomerAndOrgReqVo customerAndOrgReqVo = new MdmCustomerAndOrgReqVo();
        customerAndOrgReqVo.setOrgCodeList(orgCodeLists);
        List cusCodeOrgLists = this.mdmCustomerMsgService.findCurrentAndSubCustomerList(customerAndOrgReqVo).stream().map(MdmCustomerMsgRespVo::getCustomerCode).collect(Collectors.toList());
        DeleteQuery deleteQuery = new DeleteQuery();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"availableRuleCode.keyword", (String)availableListRuleVo.getRuleCode()));
        deleteQuery.setQuery((QueryBuilder)boolQueryBuilder);
        this.elasticsearchTemplate.delete(deleteQuery, CusAvailablelistEntity.class);
        this.elasticsearchTemplate.refresh("cusavailablelistindex");
        log.info("\u6267\u884c\u5220\u9664[{}]***************\r\n", (Object)availableListRuleVo.getRuleCode());
        if (StringUtils.isNotEmpty((String)((String)cusCodes.get(0)))) {
            for (String cusCode : cusCodes) {
                this.cusAvailablelistService.editSyncCusAvailableList(goods, cusCode, availableListRuleVo.getRuleCode());
            }
        } else {
            for (String cusCode : cusCodeOrgLists) {
                this.cusAvailablelistService.editSyncCusAvailableList(goods, cusCode, availableListRuleVo.getRuleCode());
            }
        }
        log.info("\u5ba2\u6237\u53ef\u8d2d\u5546\u54c1\u5217\u8868\u4fe1\u606f\u540c\u6b65\u5b8c\u6210-----");
    }
}

