package com.biz.crm.msg.wework;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;


/**
 * 企业微信配置
 *  @author: luoqi
 *  @Date: 2020-10-9 16:07
 *  @version: V1.0
 *  @Description:
 */
@Component
public class WeworkConfigurer {

    @Value("${wework.corpid:}")
    private String corpid;
    /**
     * 企业微信公司 corpid
     */
    public static final String CORPID = "corpid";
    @Value("${wework.corpsecret:}")
    private String corpsecret;
    /**
     * 企业微信公司 corpsecret 应用密钥
     */
    public static final String CORPSECRET = "corpsecret";
    /**
     * access_token获取地址
     */
    @Value("${wework.tokenUrl:https://qyapi.weixin.qq.com/cgi-bin/gettoken}")
    private String tokenUrl;

    /**
     * 创建群聊地址
     */
    @Value("${wework.appchatCreateUrl:https://qyapi.weixin.qq.com/cgi-bin/appchat/create}")
    private String appchatCreateUrl;

    /**
     * 发送群聊消息
     */
    @Value("${wework.appchatCreateUrl:https://qyapi.weixin.qq.com/cgi-bin/appchat/send}")
    private String appchatSendUrl;

    /**
     * 修改群聊信息
     */
    @Value("${wework.appchatCreateUrl:https://qyapi.weixin.qq.com/cgi-bin/appchat/update}")
    private String appchatUpdateUrl;
    /**
     * 获取群聊信息
     */
    @Value("${wework.appchatCreateUrl:https://qyapi.weixin.qq.com/cgi-bin/appchat/get}")
    private String appchatGetUrl;

    public String getAppchatUpdateUrl() {
        return appchatUpdateUrl;
    }

    public String getAppchatGetUrl() {
        return appchatGetUrl;
    }

    public String getAppchatSendUrl() {
        return appchatSendUrl;
    }

    public String getAppchatCreateUrl() {
        return appchatCreateUrl;
    }

    public String getCorpid() {
        return corpid;
    }

    public String getCorpsecret() {
        return corpsecret;
    }

    public String getTokenUrl() {
        return tokenUrl;
    }


}
