/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.msg.wework;

import com.biz.crm.msg.wework.WeworkAccessToken;
import com.biz.crm.msg.wework.WeworkConfigurer;
import com.biz.crm.msg.wework.WeworkConstant;
import com.biz.crm.msg.wework.vo.AbstractAppchatSendReq;
import com.biz.crm.msg.wework.vo.AppchatCreateReq;
import com.biz.crm.msg.wework.vo.AppchatUpdateReq;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WeworkAppchatApi {
    private static final Logger log = LoggerFactory.getLogger(WeworkAppchatApi.class);
    @Autowired
    private WeworkConfigurer weworkConfigurer;
    @Autowired
    private WeworkAccessToken weworkAccessToken;

    public void appchatCreate(AppchatCreateReq req) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().queryParam("access_token", new Object[]{this.weworkAccessToken.getAccessToken()}).contentType(ContentType.JSON).body((Object)req).when().log().all()).post(this.weworkConfigurer.getAppchatCreateUrl(), new Object[0])).then()).log().all()).body("errcode", (Matcher)WeworkConstant.MATCHER_ERRCODE, new Object[0])).extract().response();
    }

    public void appchatUpdate(AppchatUpdateReq req) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().queryParam("access_token", new Object[]{this.weworkAccessToken.getAccessToken()}).contentType(ContentType.JSON).body((Object)req).when().log().all()).post(this.weworkConfigurer.getAppchatUpdateUrl(), new Object[0])).then()).log().all()).body("errcode", (Matcher)WeworkConstant.MATCHER_ERRCODE, new Object[0])).extract().response();
    }

    public void appchatSend(AbstractAppchatSendReq req) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().queryParam("access_token", new Object[]{this.weworkAccessToken.getAccessToken()}).contentType(ContentType.JSON).body((Object)req).when().log().all()).post(this.weworkConfigurer.getAppchatSendUrl(), new Object[0])).then()).log().all()).body("errcode", (Matcher)WeworkConstant.MATCHER_ERRCODE, new Object[0])).extract().response();
    }

    public Map<String, Object> appchatGet(String chatid) {
        if (StringUtils.isBlank((CharSequence)chatid)) {
            return null;
        }
        Response response = (Response)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().param("access_token", new Object[]{this.weworkAccessToken.getAccessToken()}).param("chatid", new Object[]{chatid}).when().log().all()).get(this.weworkConfigurer.getAppchatGetUrl(), new Object[0])).then()).log().all()).body("errcode", (Matcher)WeworkConstant.MATCHER_ERRCODE, new Object[0])).extract().response();
        Map jsonInfo = (Map)response.path("chat_info", new String[0]);
        if (null == jsonInfo) {
            log.warn("\u83b7\u53d6\u5fae\u4fe1\u7fa4\u804a\u4f1a\u8bdd\u5931\u8d25 >>> chatid = {}", (Object)chatid);
            return null;
        }
        return jsonInfo;
    }
}

