/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.msg.wework;

import com.biz.crm.msg.wework.WeworkConfigurer;
import com.biz.crm.msg.wework.WeworkConstant;
import com.biz.crm.service.RedisService;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WeworkAccessToken {
    private static final Logger log = LoggerFactory.getLogger(WeworkAccessToken.class);
    @Autowired
    private WeworkConfigurer weworkConfigurer;
    @Autowired
    private RedisService redisService;

    public String getAccessToken() {
        String token = (String)this.redisService.get("ACCESS_TOKEN_AS_WEWORK");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = this.loadToken();
        }
        return token;
    }

    private String loadToken() {
        Response response = (Response)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().param("corpid", new Object[]{this.weworkConfigurer.getCorpid()}).param("corpsecret", new Object[]{this.weworkConfigurer.getCorpsecret()}).when().log().all()).get(this.weworkConfigurer.getTokenUrl(), new Object[0])).then()).log().all()).body("errcode", (Matcher)WeworkConstant.MATCHER_ERRCODE, new Object[0])).extract().response();
        String token = (String)response.path("access_token", new String[0]);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            boolean redisUpdate = this.redisService.setMinutes("ACCESS_TOKEN_AS_WEWORK", (Object)token, 115L);
            if (!redisUpdate) {
                log.warn("\u7f13\u5b58\u4f01\u4e1a\u5fae\u4fe1 access_token \u5931\u8d25");
            }
            return token;
        }
        log.warn("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1 access_token \u5931\u8d25");
        return null;
    }
}

