package com.biz.crm.config;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.util.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * @ClassName: OperatorInterceptor
 * @Description:
 * @Author: xuduan
 * @Date: 2019/7/17 上午11:45
 **/
@Slf4j
@Component
@ConditionalOnMissingBean(name = "operatorInterceptorExtend")
public class OperatorInterceptor implements MetaObjectHandler {
    @Override
    public void insertFill(MetaObject metaObject) {
        log.debug("新增自动填充值");
        String nowDate = DateUtil.formatDate();
        String nowDatehs = DateUtil.formatShortTime();
        UserRedis user = UserUtils.getUser();
        setFieldValByName("createDate", nowDate, metaObject);
        setFieldValByName("createDateSecond", nowDatehs, metaObject);
        setFieldValByName("createDateAll", LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss), metaObject);
        Object status = getFieldValByName("delFlag", metaObject);
        if (status == null || status.toString().equals("")) {
            setFieldValByName("delFlag", CrmDelFlagEnum.NORMAL.getCode(), metaObject);
        }
        Object enableStatus = getFieldValByName("enableStatus", metaObject);
        if (enableStatus == null || enableStatus.toString().equals("")) {
            setFieldValByName("enableStatus", CrmEnableStatusEnum.ENABLE.getCode(), metaObject);
        }
        if (user != null) {
            String username = user.getUsername();
            Object createCode = metaObject.getValue("createCode");
            if (ObjectUtils.isNull(createCode)&&username != null && !username.trim().equals("")) {
                setFieldValByName("createCode", username, metaObject);
            }
            String realname = user.getRealname();
            Object createName = metaObject.getValue("createName");
            if (ObjectUtils.isNull(createName)&&realname != null && !realname.trim().equals("")) {
                setFieldValByName("createName", realname, metaObject);
            }
            String orgcode = user.getOrgcode();
            Object createOrgCode = metaObject.getValue("createOrgCode");
            if (ObjectUtils.isNull(createOrgCode)&&orgcode != null && !orgcode.trim().equals("")) {
                setFieldValByName("createOrgCode", orgcode, metaObject);
            }
            String orgname = user.getOrgname();
            Object createOrgName = metaObject.getValue("createOrgName");
            if (ObjectUtils.isNull(createOrgName)&&orgname != null && !orgname.trim().equals("")) {
                setFieldValByName("createOrgName", orgname, metaObject);
            }
            String poscode = user.getPoscode();
            Object createPosCode = metaObject.getValue("createPosCode");
            if (ObjectUtils.isNull(createPosCode)) {
                setFieldValByName("createPosCode", poscode, metaObject);
            }
            String posname = user.getPosname();
            Object createPosName = metaObject.getValue("createPosName");
            if (ObjectUtils.isNull(createPosName)) {
                setFieldValByName("createPosName", posname, metaObject);
            }
        }
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        log.debug("修改自动填充值");
        String nowDate = DateUtil.formatDate();
        String nowDatehs = DateUtil.formatShortTime();
        UserRedis user = UserUtils.getUser();
        this.setFieldValByName("updateDate", nowDate, metaObject);
        this.setFieldValByName("updateDateSecond", nowDatehs, metaObject);
        this.setFieldValByName("updateDateAll", LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss), metaObject);
        if (user != null) {
            String username = user.getUsername();
            if (username != null && !username.trim().equals("")) {
                setFieldValByName("updateCode", username, metaObject);
            }
            String realname = user.getRealname();
            if (realname != null && !realname.trim().equals("")) {
                setFieldValByName("updateName", realname, metaObject);
            }
            String orgcode = user.getOrgcode();
            if (orgcode != null && !orgcode.trim().equals("")) {
                setFieldValByName("updateOrgCode", orgcode, metaObject);
            }
            String orgname = user.getOrgname();
            if (orgname != null && !orgname.trim().equals("")) {
                setFieldValByName("updateOrgName", orgname, metaObject);
            }
            String poscode = user.getPoscode();
            if (poscode != null && !poscode.trim().equals("")) {
                setFieldValByName("updatePosCode", poscode, metaObject);
            }
            String posname = user.getPosname();
            if (posname != null && !posname.trim().equals("")) {
                setFieldValByName("updatePosName", posname, metaObject);
            }
        }
    }
}
