package com.biz.crm.listener;

import com.baomidou.mybatisplus.annotation.TableId;
import com.biz.crm.base.Datasource;
import com.biz.crm.config.ClassUtil;
import com.biz.crm.sqlupdate.*;
import com.biz.crm.sqlupdate.mysql.MysqlUserTablesService;
import com.biz.crm.sqlupdate.oracle.OracleUserTablesService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.persistence.Index;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.listener
 * @Description: TODO
 * @date 2021/3/16 下午12:46
 */
@Slf4j
@Component
@Order(0)
public class CrmSqlListener implements ApplicationListener<ApplicationReadyEvent> {
    @Value("${spring.jpa.hibernate.ddl-auto:none}")
    private String ddl;
    @Autowired
    private OracleUserTablesService oracleUserTablesService;
    @Autowired
    private MysqlUserTablesService mysqlUserTablesService;
    private static List<Class<?>> classPaths = new ArrayList<>();

    @Override
    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        if(!"update".equalsIgnoreCase(ddl)){
            log.info("当前配置不执行对比==>");
            return;
        }
        log.info("开始执行CRM表对比监听==>");
        log.info("当前DB环境==>" + Datasource.datasource);
        if(Datasource.oracleFlag){
            doOracle();
        }else if(Datasource.mysqlFlag){
            doMysql();
        }
        classPaths = null;
        log.info("结束执行CRM表对比监听==>");
    }

    //处理mysql
    private void doMysql(){
        getDataClass();
        List<CrmTableVo> crmTableVos =  getData();
        mysqlUserTablesService.updateSql(crmTableVos);
    }

    //处理oracle
    private void doOracle(){
        getDataClass();
        List<CrmTableVo> crmTableVos =  getData();
        oracleUserTablesService.updateSql(crmTableVos);
    }

    /**
     */
    private void getDataClass() {
        String voPackagePath = "com.biz.crm";
        String[] pageagePath = voPackagePath.split(",");
        for(String path : pageagePath){
            List<Class<?>> currentClasses = ClassUtil.getClasses(path);
            if(!CollectionUtils.isEmpty(currentClasses)){
                for(Class c : currentClasses){
                  if(c.isAnnotationPresent(CrmTable.class)){
                      classPaths.add(c);
                  }
                }
            }
        }
    }

    private List<CrmTableVo> getData(){
        List<CrmTableVo> crmTableVos = new ArrayList<>();
        for(Class<?> item : classPaths){
            CrmTableVo crmTableVo = new CrmTableVo();
            CrmTable crmTable =  item.getAnnotation(CrmTable.class);
            crmTableVo.setName(crmTable.name().toUpperCase());
            crmTableVo.setTableNote(crmTable.tableNote());
            Index[] indexes=  crmTable.indexes();
            List<IndexVo> indexVos = new ArrayList<>();
            if(indexes!=null){
                for(Index index : indexes){
                    IndexVo indexVo = new IndexVo();
                    indexVo.setColumnList(index.columnList());
                    indexVo.setName(index.name().toUpperCase());
                    indexVo.setUnique(index.unique());
                    indexVos.add(indexVo);
                }
                crmTableVo.setIndexVos(indexVos);
            }

            List<Field> fields = new ArrayList<>();
            Class c = item;
            while (c.getSuperclass()!=null){
                fields.addAll(Arrays.asList(c.getDeclaredFields()));
                c = c.getSuperclass();
            }
            List<CrmColumnVo> crmColumnVos = new ArrayList<>();
            if(fields!=null){
                for(Field field : fields){
                    CrmColumn crmColumn =  field.getAnnotation(CrmColumn.class);
                    if(crmColumn==null){continue;}
                    CrmColumnVo crmColumnVo = new CrmColumnVo();
                    crmColumnVo.setLength(crmColumn.length());
                    crmColumnVo.setMysqlType(crmColumn.mysqlType());
                    crmColumnVo.setName(crmColumn.name().toUpperCase());
                    crmColumnVo.setNullable(crmColumn.nullable());
                    crmColumnVo.setUnique(crmColumn.unique());
                    crmColumnVo.setOracleType(crmColumn.oracleType());
                    crmColumnVo.setNote(crmColumn.note());
                    crmColumnVo.setDefaultValue(crmColumn.defaultValue());
                    crmColumnVo.setOrder(crmColumn.order());
                    crmColumnVos.add(crmColumnVo);
                    if(field.isAnnotationPresent(TableId.class)){
                        crmTableVo.setKey(crmColumnVo);
                    }
                }
                if (crmColumnVos.size() > 0) {
                    crmColumnVos = crmColumnVos.stream().sorted(((x1, x2) -> x1.getOrder() - x2.getOrder())).collect(Collectors.toList());
                }
                crmTableVo.setCrmColumnVos(crmColumnVos);
            }
            crmTableVos.add(crmTableVo);
        }
        return crmTableVos;
    }

}
