package com.biz.crm.config;

import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.biz.crm.interceptor.DataPermission;
import com.biz.crm.interceptor.DataPermissionInterceptor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.config
 * @Description: TODO
 * @date 2020/8/25 下午3:02
 */
@Configuration
@Slf4j
public class MybatisPlusConfig {


    /**
     * 分页插件
     */
    @Bean
    public PaginationInterceptor paginationInterceptor() {
        final long limit  = 5000L;
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        //你的最大单页限制数量，默认 500 条，小于 0 如 -1 不受限制)
        paginationInterceptor.setLimit(limit);
        log.info("注册分页插件,你的最大单页限制数量:"+limit);
        return paginationInterceptor;
    }
}
