package com.biz.crm.interceptor;

import com.biz.crm.eunm.mdm.MdmPermissionObjEnum;
import com.biz.crm.nebular.mdm.permission.MdmCurrentPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmCurrentUserPermissionRespVo;
import com.biz.crm.util.SqlUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.mapping.Collection;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @Project crm
 * @PackageName com.biz.crm.interceptor
 * @ClassName HandlePrivilegeSqlServiceImpl
 * @Author HuangLong
 * @Date 2020/11/24 17:53
 * @Description 产品组预置组织和职位的权限拦截,其他的需要各项目自己去实现
 */
@Component(value = "HandlePrivilegeSqlService")
public class HandlePrivilegeSqlServiceImpl implements HandlePrivilegeSqlService{
    @Override
    public String handler(SqlPrivilege sqlPrivilege, MdmCurrentPermissionRespVo dataPermission) {
        StringBuffer sqlBuffer = new StringBuffer();
        List<MdmCurrentUserPermissionRespVo> userPermissionList = dataPermission.getUserPermissionList();
        if(CollectionUtils.isNotEmpty(userPermissionList)){
            Set<String> posList= Sets.newHashSet();
            Set<String> orgList= Sets.newHashSet();
            userPermissionList.forEach(o->{
                if(StringUtils.equals(MdmPermissionObjEnum.ORG.getCode(),o.getPermissionObjCode())){
                    this.getAllValue(o.getPermissionValueList(),orgList);
                }
                if(StringUtils.equals(MdmPermissionObjEnum.POSITION.getCode(),o.getPermissionObjCode())){
                    this.getAllValue(o.getPermissionValueList(),posList);
                }
            });
            if(StringUtils.isNotEmpty(sqlPrivilege.orgCode())&&CollectionUtils.isNotEmpty(orgList)){
                //拼接组织的SQL
                String orgSql = SqlUtil.setSqlIn(orgList.toArray(new String[orgList.size()]),sqlPrivilege.orgCode(),true,"");
                sqlBuffer.append(orgSql);
            }
            if(StringUtils.isNotEmpty(sqlPrivilege.posCode())&&CollectionUtils.isNotEmpty(posList)){
                //拼接职位的SQL
                String posSql = SqlUtil.setSqlIn(posList.toArray(new String[posList.size()]),sqlPrivilege.posCode(),true,"");
                sqlBuffer.append(posSql);
            }
        }
        return sqlBuffer.toString();
    }
    private Set<String> getAllValue(List<String> permissionValueList,Set<String> set){
        if(!CollectionUtils.isEmpty(permissionValueList)){
            set.addAll(permissionValueList);
        }
        return set;
    }
}
