/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.biz.crm.util.DateUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class OperatorInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(OperatorInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        String name = invocation.getMethod().getName();
        log.debug("Exec MethodName is {}", (Object)name);
        SqlCommandType sqlCommandType = null;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof MappedStatement) {
                MappedStatement ms = (MappedStatement)arg;
                sqlCommandType = ms.getSqlCommandType();
                if (sqlCommandType != SqlCommandType.INSERT && sqlCommandType != SqlCommandType.UPDATE) break;
                continue;
            }
            if (arg instanceof Map) {
                Map map = (Map)arg;
                this.putProperty(map, sqlCommandType);
                for (Object value : map.values()) {
                    if (value instanceof Collection) {
                        for (Object e : (Collection)value) {
                            this.setProperty(e, sqlCommandType);
                        }
                        continue;
                    }
                    this.setProperty(value, sqlCommandType);
                }
                continue;
            }
            this.setProperty(arg, sqlCommandType);
        }
        return invocation.proceed();
    }

    private void putProperty(Map map, SqlCommandType sqlCommandType) {
        try {
            UserRedis user = UserUtils.getUser();
            if (user == null) {
                return;
            }
            String nowDate = DateUtil.formatDate();
            String nowDatehs = DateUtil.formatShortTime();
            if (SqlCommandType.INSERT == sqlCommandType) {
                if (map.containsKey("createCode")) {
                    map.putIfAbsent("createCode", user.getUsername());
                }
                if (map.containsKey("createName")) {
                    map.putIfAbsent("createName", user.getRealname());
                }
                if (map.containsKey("createDate")) {
                    map.putIfAbsent("createDate", nowDate);
                }
                if (map.containsKey("createDateSecond")) {
                    map.putIfAbsent("createDateSecond", nowDatehs);
                }
                if (map.containsKey("createOrgCode")) {
                    map.putIfAbsent("createOrgCode", user.getOrgcode());
                }
                if (map.containsKey("createOrgName")) {
                    map.putIfAbsent("createOrgName", user.getOrgname());
                }
                if (map.containsKey("createPosCode")) {
                    map.putIfAbsent("createPosCode", user.getPoscode());
                }
                if (map.containsKey("createPosName")) {
                    map.putIfAbsent("createPosName", user.getPosname());
                }
            } else if (SqlCommandType.UPDATE == sqlCommandType) {
                if (map.containsKey("updateDate")) {
                    map.putIfAbsent("updateDate", nowDate);
                }
                if (map.containsKey("updateDateSecond")) {
                    map.putIfAbsent("updateDateSecond", nowDatehs);
                }
                if (map.containsKey("updateCode")) {
                    map.putIfAbsent("updateCode", nowDatehs);
                }
                if (map.containsKey("updateName")) {
                    map.putIfAbsent("updateName", nowDatehs);
                }
                if (map.containsKey("updateOrgCode")) {
                    map.putIfAbsent("updateOrgCode", nowDatehs);
                }
                if (map.containsKey("updateOrgName")) {
                    map.putIfAbsent("updateOrgName", nowDatehs);
                }
                if (map.containsKey("updatePosCode")) {
                    map.putIfAbsent("updatePosCode", nowDatehs);
                }
                if (map.containsKey("updatePosName")) {
                    map.putIfAbsent("updatePosName", nowDatehs);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    private void setProperty(Object obj, SqlCommandType sqlCommandType) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return;
        }
        try {
            UserRedis user = UserUtils.getUser();
            if (user == null) {
                return;
            }
            String nowDate = DateUtil.formatDate();
            String nowDatehs = DateUtil.formatShortTime();
            if (SqlCommandType.INSERT == sqlCommandType) {
                Map mapProperty = BeanUtils.describe((Object)obj);
                if (mapProperty.containsKey("createDate") && StringUtils.isEmpty((String)((String)mapProperty.get("createDate")))) {
                    BeanUtils.setProperty((Object)obj, (String)"createDate", (Object)nowDate);
                }
                if (mapProperty.containsKey("createDateSecond") && StringUtils.isEmpty((String)((String)mapProperty.get("createDateSecond")))) {
                    BeanUtils.setProperty((Object)obj, (String)"createDateSecond", (Object)nowDatehs);
                }
                if (mapProperty.containsKey("createCode") && StringUtils.isEmpty((String)((String)mapProperty.get("createCode")))) {
                    BeanUtils.setProperty((Object)obj, (String)"createCode", (Object)user.getUsername());
                }
                if (mapProperty.containsKey("createName") && StringUtils.isEmpty((String)((String)mapProperty.get("createName")))) {
                    BeanUtils.setProperty((Object)obj, (String)"createName", (Object)user.getRealname());
                }
                if (mapProperty.containsKey("createOrgCode") && StringUtils.isEmpty((String)((String)mapProperty.get("createOrgCode")))) {
                    BeanUtils.setProperty((Object)obj, (String)"createOrgCode", (Object)user.getOrgcode());
                }
                if (mapProperty.containsKey("createOrgName") && StringUtils.isEmpty((String)((String)mapProperty.get("createOrgName")))) {
                    BeanUtils.setProperty((Object)obj, (String)"createOrgName", (Object)user.getOrgname());
                }
                if (mapProperty.containsKey("createPosCode") && StringUtils.isEmpty((String)((String)mapProperty.get("createPosCode")))) {
                    BeanUtils.setProperty((Object)obj, (String)"createPosCode", (Object)user.getPoscode());
                }
                if (mapProperty.containsKey("createPosName") && StringUtils.isEmpty((String)((String)mapProperty.get("createPosName")))) {
                    BeanUtils.setProperty((Object)obj, (String)"createPosName", (Object)user.getPosname());
                }
            } else if (SqlCommandType.UPDATE == sqlCommandType) {
                Map mapProperty = BeanUtils.describe((Object)obj);
                if (mapProperty.containsKey("updateDate") && StringUtils.isEmpty((String)((String)mapProperty.get("updateDate")))) {
                    BeanUtils.setProperty((Object)obj, (String)"updateDate", (Object)nowDate);
                }
                if (mapProperty.containsKey("updateDateSecond") && StringUtils.isEmpty((String)((String)mapProperty.get("updateDateSecond")))) {
                    BeanUtils.setProperty((Object)obj, (String)"updateDateSecond", (Object)nowDatehs);
                }
                if (mapProperty.containsKey("updateCode") && StringUtils.isEmpty((String)((String)mapProperty.get("updateCode")))) {
                    BeanUtils.setProperty((Object)obj, (String)"updateCode", (Object)user.getUsername());
                }
                if (mapProperty.containsKey("updateName") && StringUtils.isEmpty((String)((String)mapProperty.get("updateName")))) {
                    BeanUtils.setProperty((Object)obj, (String)"updateName", (Object)user.getRealname());
                }
                if (mapProperty.containsKey("updateOrgCode") && StringUtils.isEmpty((String)((String)mapProperty.get("updateOrgCode")))) {
                    BeanUtils.setProperty((Object)obj, (String)"updateOrgCode", (Object)user.getOrgcode());
                }
                if (mapProperty.containsKey("updateOrgName") && StringUtils.isEmpty((String)((String)mapProperty.get("updateOrgName")))) {
                    BeanUtils.setProperty((Object)obj, (String)"updateOrgName", (Object)user.getOrgname());
                }
                if (mapProperty.containsKey("updatePosCode") && StringUtils.isEmpty((String)((String)mapProperty.get("updatePosCode")))) {
                    BeanUtils.setProperty((Object)obj, (String)"updatePosCode", (Object)user.getPoscode());
                }
                if (mapProperty.containsKey("updatePosName") && StringUtils.isEmpty((String)((String)mapProperty.get("updatePosName")))) {
                    BeanUtils.setProperty((Object)obj, (String)"updatePosName", (Object)user.getPosname());
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

