package com.biz.crm.util;


import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.privilege.OperationAuthobj;
import com.biz.crm.common.privilege.PrivilegeConstants;
import com.biz.crm.common.privilege.PrivilegeSearchVo;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.interceptor.HandlePrivilegeSqlService;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.mdm.permission.MdmDataPermissionFeign;
import com.biz.crm.nebular.mdm.permission.MdmCurrentPermissionRespVo;
import jodd.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.catalina.Globals;
import org.apache.commons.collections4.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.eisp.operation
 * @Description: TODO
 * @date 2019/9/19 下午2:09
 */
@Slf4j
public class OperationConfig {
    private static MdmDataPermissionFeign mdmDataPermissionFeign;
    /**
     * 根据指定条件创建权限sql
     *
     * @return
     */
    public static String createOperationSql(SqlPrivilege sqlPrivilege) {
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        Object functionCodeObj = ThreadLocalUtil.getObj(GlobalParam.FUNCTION_CODE);
        String menuCode= Objects.nonNull(menuCodeObj) ? menuCodeObj.toString() : null ;
        String functionCode= Objects.nonNull(functionCodeObj) ? functionCodeObj.toString() : null ;
        StringBuffer stringBuffer = new StringBuffer();
        //如果当前功能尚未约定传这两个值,就不做权限拦截
        if(StringUtils.isEmpty(functionCode)||StringUtils.isEmpty(menuCode)){
            return stringBuffer.toString();
        }
        if(mdmDataPermissionFeign==null){
            mdmDataPermissionFeign = (MdmDataPermissionFeign) SpringApplicationContextUtil.getApplicationContext().getBean("MdmDataPermissionFeign");
        }
        UserRedis userRedis = UserUtils.getUser();
        if(userRedis==null){
            //未登录不允许查询
            stringBuffer.append(PrivilegeConstants.NO_OPERATION);
            return stringBuffer.toString();
        }
        if(GlobalParam.Admin_Name.equalsIgnoreCase(userRedis.getUsername())){
            //超级管理员查所有
            return stringBuffer.toString();
        }

        MdmCurrentPermissionRespVo dataPermission = mdmDataPermissionFeign.currentUserDataPermission(menuCode, functionCode).getResult();
        if(Objects.isNull(dataPermission)){
            log.error("mdm数据权限接口调用失败");
            stringBuffer.append(PrivilegeConstants.NO_OPERATION);
            return stringBuffer.toString();
        }
        //如果当前菜单尚未配置数据权限,直接允许查询所有
        if(CollectionUtils.isEmpty(dataPermission.getPermissionObjCodeList())){
            return stringBuffer.toString();
        }
        if(CollectionUtils.isEmpty(dataPermission.getUserPermissionList())){
            log.error("当前查询用户->{},未配置菜单->{},功能->{},的数据权限",userRedis.getUsername(),menuCode,functionCode);
            stringBuffer.append(PrivilegeConstants.NO_OPERATION);
        }
        List<HandlePrivilegeSqlService> handlePrivilegeSqlServices =SpringApplicationContextUtil.getApplicationContext().getBean("HandlePrivilegeSqlService",List.class);
        if(CollectionUtils.isNotEmpty(handlePrivilegeSqlServices)){
            for (HandlePrivilegeSqlService handlePrivilegeSqlService : handlePrivilegeSqlServices) {
                String sql = handlePrivilegeSqlService.handler(sqlPrivilege, dataPermission);
                if(StringUtils.isNotEmpty(sql)){
                    if(stringBuffer.length()==0){
                        stringBuffer.append(" 2=2 ");
                    }
                    stringBuffer.append(" and(");
                    stringBuffer.append(sql);
                    stringBuffer.append(") ");
                }

            }
        }
        String sql = stringBuffer.toString();
        return stringBuffer.toString();
    }


}
