package com.biz.crm.config;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.*;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;

/**
 * @ClassName: OperatorInterceptor
 * @Description:
 * @Author: xuduan
 * @Date: 2019/7/17 上午11:45
 **/
@Slf4j
@Component
public class OperatorInterceptor implements MetaObjectHandler {
    @Override
    public void insertFill(MetaObject metaObject) {
        log.debug("新增自动填充值");
        String nowDate = DateUtil.formatDate();
        String nowDatehs = DateUtil.formatShortTime();
        UserRedis user = UserUtils.getUser();
        setFieldValByName("createDate", nowDate, metaObject);
        setFieldValByName("createDateSecond", nowDatehs, metaObject);
        Object status =  getFieldValByName("delFlag",metaObject);
        if(status==null||status.toString().equals("")){
            setFieldValByName("delFlag", CrmDelFlagEnum.NORMAL.getCode(), metaObject);
        }
        Object enableStatus =  getFieldValByName("enableStatus",metaObject);
        if(enableStatus==null||enableStatus.toString().equals("")){
            setFieldValByName("enableStatus", CrmEnableStatusEnum.ENABLE.getCode(), metaObject);
        }
        if(user!=null){
            setFieldValByName("createCode", user.getUsername(), metaObject);
            setFieldValByName("createName", user.getRealname(), metaObject);
            setFieldValByName("createOrgCode", user.getOrgcode(), metaObject);
            setFieldValByName("createOrgName", user.getOrgname(), metaObject);
            setFieldValByName("createPosCode", user.getPoscode(), metaObject);
            setFieldValByName("createPosName", user.getPosname(), metaObject);
        }
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        log.debug("修改自动填充值");
        String nowDate = DateUtil.formatDate();
        String nowDatehs = DateUtil.formatShortTime();
        UserRedis user = UserUtils.getUser();
        this.setFieldValByName("updateDate", nowDate, metaObject);
        this.setFieldValByName("updateDateSecond", nowDatehs, metaObject);
        if(user!=null){
            this.setFieldValByName("updateCode", user.getUsername(), metaObject);
            this.setFieldValByName("updateName", user.getRealname(), metaObject);
            this.setFieldValByName("updateOrgCode", user.getOrgcode(), metaObject);
            this.setFieldValByName("updateOrgName", user.getOrgname(), metaObject);
            this.setFieldValByName("updatePosCode", user.getPoscode(), metaObject);
            this.setFieldValByName("updatePosName", user.getPosname(), metaObject);
        }
    }
}
