package com.biz.crm.sqlupdate.mysql;

import com.biz.crm.sqlupdate.CrmColumnVo;
import com.biz.crm.sqlupdate.CrmTableVo;
import com.biz.crm.sqlupdate.IndexVo;
import com.biz.crm.sqlupdate.mapper.DoMysqlUpdateSqlMapper;
import com.biz.crm.sqlupdate.mysql.vo.MysqlTable;
import com.biz.crm.sqlupdate.oracle.vo.AllTabColsVo;
import com.biz.crm.sqlupdate.vo.PrimaryKey;
import com.biz.crm.sqlupdate.vo.TableColumnNote;
import com.biz.crm.sqlupdate.vo.TableIndex;
import com.biz.crm.sqlupdate.vo.TableNote;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.sqlupdate.oracle
 * @Description: TODO
 * @date 2021/3/16 下午1:25
 */
@Service
public class MysqlUserTablesService {
    @Resource
    private DoMysqlUpdateSqlMapper doMysqlUpdateSqlMapper;
    //当前数据库
    public static String database = null;
    private void intiDataBase(){
        if(StringUtils.isEmpty(database)){
            database = doMysqlUpdateSqlMapper.selectDatabase();
        }
    }
    /**
     * 获取所有表
     * @return
     */
    private Map<String,MysqlTable> getAllTables() {
        intiDataBase();
        Map<String,MysqlTable> map = new HashMap<>();
        List<MysqlTable> userTables = doMysqlUpdateSqlMapper.getAlltable();
        if(CollectionUtil.listNotEmptyNotSizeZero(userTables)){
            for(MysqlTable oracleUserTables : userTables){
                String tableName = oracleUserTables.getTableName().toUpperCase();
                map.put(tableName,oracleUserTables);
            }
        }
        return map;
    }
    /**
     * 执行更新
     * @param crmTableVos
     */
    public void updateSql(List<CrmTableVo> crmTableVos){
        if(CollectionUtil.listNotEmptyNotSizeZero(crmTableVos)){
            //所有存在的表
            Map<String,MysqlTable> mapTable =  getAllTables() ;
            for(CrmTableVo crmTableVo : crmTableVos){
                String tableName = crmTableVo.getName();
                if(mapTable.containsKey(tableName)){
                    updateTable(crmTableVo);
                }else {
                    initTable(crmTableVo);
                }
            }
        }
    }

    /**
     * 新增表
     * 1、创建表
     * 2、创建主键
     * 3、创建索引
     * 4、创建注释
     * 5、更新表注释
     */
    private void initTable(CrmTableVo crmTableVo){
        //1、创建表
        doMysqlUpdateSqlMapper.createTable(crmTableVo);
        //2、创建主键
        if (crmTableVo.getKey()!=null){
            doMysqlUpdateSqlMapper.updatePrimaryKey(crmTableVo);
        }
        //3、创建索引
        if(CollectionUtil.listNotEmptyNotSizeZero(crmTableVo.getIndexVos())){
            for(IndexVo indexVo : crmTableVo.getIndexVos()){
                doMysqlUpdateSqlMapper.updateIndex(indexVo,crmTableVo);
            }
        }
        //4、创建注释
        if(CollectionUtil.listNotEmptyNotSizeZero(crmTableVo.getCrmColumnVos())){
          for(CrmColumnVo crmColumnVo : crmTableVo.getCrmColumnVos() ){
              doMysqlUpdateSqlMapper.commentTable(crmColumnVo,crmTableVo.getName());
          }
        }
        //5、更新表注释
        updateTableNote(crmTableVo);

    }

    /**
     * 更新表注释
     * @param crmTableVo
     */
    private void updateTableNote(CrmTableVo crmTableVo){
        TableNote tableNote =  doMysqlUpdateSqlMapper.getTableNote(crmTableVo.getName());
        if(tableNote!=null&& StringUtils.isNotEmpty(tableNote.getComments())){
          //TODO
        }else {
            if(StringUtils.isNotEmpty(crmTableVo.getTableNote())){
                doMysqlUpdateSqlMapper.updateTableNote(crmTableVo);
            }
        }
    }

    /**
     * 更新列注释
     */
    private void updateTableColumnNote(CrmTableVo crmTableVo){
        List<TableColumnNote> columnNotes =  doMysqlUpdateSqlMapper.getColumnNote(crmTableVo.getName());
        if(CollectionUtil.listEmpty(columnNotes)){
            return;
        }
        Map<String,TableColumnNote> map = new HashMap<>();
        for(TableColumnNote note : columnNotes){
            map.put(note.getColumnName().toUpperCase(),note);
        }
        for(CrmColumnVo crmColumnVo : crmTableVo.getCrmColumnVos()){
            //字段不存在或者 现有表字段未写注释 但是本次字段有注释
            if(StringUtils.isEmpty(crmColumnVo.getNote())){
                continue;
            }
            if(!map.containsKey(crmColumnVo.getName())||StringUtils.isEmpty(map.get(crmColumnVo.getName()).getNote())){
                doMysqlUpdateSqlMapper.commentTable(crmColumnVo,crmTableVo.getName());
            }
        }
    }

    /**
     * 修改表
     */
    private void updateTable(CrmTableVo crmTableVo){
        List<AllTabColsVo> tabColsVos =  doMysqlUpdateSqlMapper.getAllTab(crmTableVo.getName());
        Map<String,AllTabColsVo> mapCols = new HashMap<>();
        for(AllTabColsVo allTabColsVo : tabColsVos){
           String columnName = allTabColsVo.getColumnName().toUpperCase();
            mapCols.put(columnName,allTabColsVo);
        }
        if(CollectionUtil.listNotEmptyNotSizeZero(crmTableVo.getCrmColumnVos())){
            for(CrmColumnVo crmColumnVo : crmTableVo.getCrmColumnVos()){
              if(mapCols.containsKey(crmColumnVo.getName())){
                  continue;
              }else {
                  //新增字段
                  doMysqlUpdateSqlMapper.addCols(crmColumnVo,crmTableVo.getName());
                  //新增注解
                  doMysqlUpdateSqlMapper.commentTable(crmColumnVo,crmTableVo.getName());
              }
            }
            //更新主键
            updatePrimaryKeys(crmTableVo);
        }
        //更新表注释
        updateTableNote(crmTableVo);
        //更新列注释
        updateTableColumnNote(crmTableVo);
        //处理索引
        updateIndex(crmTableVo);

    }

    /**
     * 更新主键
     * @param crmTableVo
     */
    private void updatePrimaryKeys(CrmTableVo crmTableVo){
        if(crmTableVo.getKey()==null){
            return;
        }
        //查询所有主键
        List<PrimaryKey> primaryKeys = doMysqlUpdateSqlMapper.getPrimaryKey(crmTableVo.getName());
        if(CollectionUtil.listEmpty(primaryKeys)){
            return;
        }
        Map<String, PrimaryKey> map = new HashMap<>();
        for(PrimaryKey item : primaryKeys){
            map.put(item.getColumnName().toUpperCase(),item);
        }
        if(!map.containsKey(crmTableVo.getKey().getName())){
            doMysqlUpdateSqlMapper.updatePrimaryKey(crmTableVo);
        }
    }

    /**
     * 处理索引
     * @param crmTableVo
     */
    private void updateIndex(CrmTableVo crmTableVo){
        if(CollectionUtil.listEmpty(crmTableVo.getIndexVos())){
            return;
        }
        List<TableIndex> indexList =   doMysqlUpdateSqlMapper.getAllIndex(crmTableVo.getName());
        Map<String, TableIndex> map = new HashMap<>();
        for(TableIndex index :  indexList){
          String columnName = index.getColumnName().toUpperCase();
          if(crmTableVo.getKey()!=null&&crmTableVo.getKey().getName().equals(columnName)){
              continue;
          }
            map.put(index.getIndexName().toUpperCase(),index);
        }
        for(IndexVo indexVo : crmTableVo.getIndexVos()){
            if(map.containsKey(indexVo.getName())){
                continue;
            }
            doMysqlUpdateSqlMapper.updateIndex(indexVo,crmTableVo);
        }
    }

}
