package com.biz.crm.sqlupdate.provider;

import com.biz.crm.sqlupdate.CrmColumnVo;
import com.biz.crm.sqlupdate.CrmTableVo;
import com.biz.crm.sqlupdate.IndexVo;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.sqlupdate.provider
 * @Description: TODO
 * @date 2021/3/16 下午5:20
 */
@Slf4j
public class DoUpdateOracleSqlProvider {
    //oracle 构建
    public String createTable(Map<String, Object> map) {
        CrmTableVo crmTableVo = (CrmTableVo) map.get("crmTableVo");
        log.info("新建表==>"+crmTableVo.getName());
        StringBuffer sql = new StringBuffer();
        sql.append(" CREATE TABLE ").append(crmTableVo.getName());
        sql.append(" (");
        boolean flag = false;
        for(CrmColumnVo crmColumn : crmTableVo.getCrmColumnVos()){
            if(flag){
                sql.append(" ,");
            }else {
                flag = true;
            }
            sql.append(" ").append(crmColumn.getName()).append(" ");
            if(!crmColumn.getOracleType().equals("VARCHAR2")){
                sql.append(crmColumn.getOracleType());
            }else {
                sql.append(crmColumn.getOracleType()).append(" (").append(crmColumn.getLength()).append(" )");
            }
        }
        sql.append(" )");
        return sql.toString();
    }

    /**
     * 更新表注释
     * @param map
     * @return
     */
    public String updateTableNote(Map<String, Object> map){
        CrmTableVo crmTableVo = (CrmTableVo) map.get("crmTableVo");
        log.info("更新表注释==>"+crmTableVo.getName()+":"+crmTableVo.getTableNote());
        StringBuffer sql = new StringBuffer();
        sql.append("COMMENT ON TABLE ").append(crmTableVo.getName()).append(" IS '").append(crmTableVo.getTableNote()).append("'");
        return sql.toString();
    }

    //oracle 新增列注释
    public String commentTable(Map<String, Object> map){
        CrmColumnVo crmColumnVo = (CrmColumnVo)map.get("crmColumnVo");
        String tableName = (String)map.get("tableName");
        log.info("新增列注释==>"+tableName+":"+crmColumnVo.getName()+":"+crmColumnVo.getNote());
        StringBuffer sql = new StringBuffer();
        sql.append("COMMENT ON COLUMN ");
        sql.append(tableName);
        sql.append(" .").append(crmColumnVo.getName()).append(" is").append(" '").append(crmColumnVo.getNote()).append(" '");
        return sql.toString();
    }

    /**
     * 添加索引
     * @param map
     * @return
     */
    public String updateIndex(Map<String, Object> map){
        IndexVo indexVo = (IndexVo)map.get("indexVo");
        CrmTableVo crmTableVo = (CrmTableVo) map.get("crmTableVo");
        log.info("添加索引==>"+crmTableVo.getTableNote()+":"+crmTableVo.getName()+":"+crmTableVo.getCrmColumnVos());
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE INDEX ");
        sql.append(indexVo.getName());
        sql.append(" on ").append(crmTableVo.getName());
        sql.append(" (");
        sql.append(indexVo.getColumnList());
        sql.append(" ) ");
      return sql.toString();
    }

    /**
     * 新增列
     * @param map
     * @return
     */
    public String addCols(Map<String, Object> map){
        CrmColumnVo crmColumnVo = (CrmColumnVo)map.get("crmColumnVo");
        String tableName = (String)map.get("tableName");
        log.info("新增列==>"+tableName+":"+crmColumnVo.getName());
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ");
        sql.append(tableName).append(" ");
        sql.append(" ADD ( ");
        sql.append(crmColumnVo.getName());
        if(!crmColumnVo.getOracleType().equals("VARCHAR2")){
            sql.append(crmColumnVo.getOracleType());
        }else {
            sql.append(crmColumnVo.getOracleType()).append(" (").append(crmColumnVo.getLength()).append(" )");
        }
        sql.append(" )");
        return sql.toString();
    }

    /**
     * 更新主键
     * @param map
     * @return
     */
    public String updatePrimaryKey(Map<String, Object> map){
        CrmTableVo crmTableVo = (CrmTableVo) map.get("crmTableVo");
        log.info("更新主键==>"+crmTableVo.getName()+":"+crmTableVo.getKey().getName());
        StringBuffer sql = new StringBuffer();
        sql.append("ALTER TABLE ").append(crmTableVo.getName());
        sql.append(" ADD CONSTRAINT ").append(crmTableVo.getName()).append("_PK").append(" PRIMARY KEY");
        sql.append(" ( ");
        sql.append(crmTableVo.getKey().getName());
        sql.append(" )");
        return sql.toString();
    }

    //得到所有列
    public String getAllTab(Map<String, Object> map){
      String tableName = (String)map.get("tableName");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT COLUMN_NAME,DATA_TYPE  FROM all_tab_cols WHERE table_name =");
        sql.append(" '");
        sql.append(tableName);
        sql.append("'");
        return sql.toString();
    }
    //得到所有主键
    public String getPrimaryKey(Map<String, Object> map){
        String tableName = (String)map.get("tableName");
        StringBuffer sql = new StringBuffer();
        sql.append(" select CU.CONSTRAINT_NAME,CU.COLUMN_NAME,CU.TABLE_NAME from user_cons_columns cu, user_constraints au where cu.constraint_name = au.constraint_name and au.constraint_type =  ")
                .append("'P").append("'").append(" and au.table_name ='").append(tableName).append("'");
        return sql.toString();
    }
    //获取所有索引
    public String getAllIndex(Map<String, Object> map){
        String tableName = (String)map.get("tableName");
        StringBuffer sql = new StringBuffer();
        sql.append("select T.INDEX_NAME,T.TABLE_NAME,T.COLUMN_NAME from user_ind_columns t,user_indexes i where t.index_name = i.index_name and t.table_name = i.table_name and t.table_name = ");
        sql.append("'").append(tableName);
        sql.append("'");
        return sql.toString();
    }

    //查询指定表注释
    public String getTableNote(Map<String, Object> map){
       String tableName = (String)map.get("tableName");
       StringBuffer sql = new StringBuffer();
       sql.append("select TABLE_NAME,COMMENTS from user_tab_comments where TABLE_NAME=");
       sql.append("'");
       sql.append(tableName);
       sql.append("'");
       return sql.toString();
   }

    /**
     * 获取所有列注释
     * @param map
     * @return
     */
   public String getColumnNote(Map<String, Object> map){
       String tableName = (String)map.get("tableName");
       StringBuffer sql = new StringBuffer();
       sql.append("select TABLE_NAME,COLUMN_NAME,COMMENTS as note from user_col_comments where TABLE_NAME= ");
       sql.append("'");
       sql.append(tableName);
       sql.append("'");
       return sql.toString();

   }

}
