package com.biz.crm.sqlupdate.mapper;

import com.biz.crm.sqlupdate.CrmColumnVo;
import com.biz.crm.sqlupdate.CrmTableVo;
import com.biz.crm.sqlupdate.IndexVo;
import com.biz.crm.sqlupdate.oracle.vo.AllTabColsVo;
import com.biz.crm.sqlupdate.provider.DoUpdateMysqlSqlProvider;
import com.biz.crm.sqlupdate.vo.PrimaryKey;
import com.biz.crm.sqlupdate.vo.TableColumnNote;
import com.biz.crm.sqlupdate.vo.TableIndex;
import com.biz.crm.sqlupdate.vo.TableNote;
import com.biz.crm.sqlupdate.provider.DoUpdateOracleSqlProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;

import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.sqlupdate.mapper
 * @Description: TODO
 * @date 2021/3/16 下午5:19
 */
public interface DoOracleUpdateSqlMapper {
    /**
     * 新建表
     * @param crmTableVo
     */
    @UpdateProvider(type = DoUpdateOracleSqlProvider.class, method ="createTable")
    void createTable(@Param("crmTableVo") CrmTableVo crmTableVo);

    /**
     * 添加列注释
     * @param crmColumnVo
     * @param tableName
     */
    @UpdateProvider(type = DoUpdateOracleSqlProvider.class, method ="commentTable")
    void commentTable(@Param("crmColumnVo") CrmColumnVo crmColumnVo,@Param("tableName") String tableName);

    //添加索引
    @UpdateProvider(type = DoUpdateOracleSqlProvider.class, method ="updateIndex")
    void updateIndex(@Param("indexVo") IndexVo indexVo,@Param("crmTableVo") CrmTableVo crmTableVo);


    //更新主键
    @UpdateProvider(type = DoUpdateOracleSqlProvider.class, method ="updatePrimaryKey")
    void updatePrimaryKey(@Param("crmTableVo") CrmTableVo crmTableVo);

    /**
     * 新增字段
     */
    @UpdateProvider(type = DoUpdateOracleSqlProvider.class, method ="addCols")
    void addCols(@Param("crmColumnVo") CrmColumnVo crmColumnVo,@Param("tableName") String tableName);

    /**
     * 更新表注释
     * @param crmTableVo
     */
    @UpdateProvider(type = DoUpdateOracleSqlProvider.class, method ="updateTableNote")
    void updateTableNote(@Param("crmTableVo") CrmTableVo crmTableVo);

    /**
     * 查询所有列
     * @param tableName
     * @return
     */
    @SelectProvider(type = DoUpdateOracleSqlProvider.class, method ="getAllTab")
    List<AllTabColsVo> getAllTab(@Param("tableName") String tableName);

    /**
     * 查询所有主键
     * @param tableName
     * @return
     */
    @SelectProvider(type = DoUpdateOracleSqlProvider.class, method ="getPrimaryKey")
    List<PrimaryKey> getPrimaryKey(@Param("tableName") String tableName);

    /**
     * 查询所有索引
     * @param tableName
     * @return
     */
    @SelectProvider(type = DoUpdateOracleSqlProvider.class, method ="getAllIndex")
    List<TableIndex> getAllIndex(@Param("tableName") String tableName);

    /**
     * 查询表注释
     * @param tableName
     * @return
     */
    @SelectProvider(type = DoUpdateOracleSqlProvider.class, method ="getTableNote")
    TableNote getTableNote(@Param("tableName") String tableName);

    /**
     * 查询列注释
     * @param tableName
     * @return
     */
    @SelectProvider(type = DoUpdateOracleSqlProvider.class, method ="getColumnNote")
    List<TableColumnNote> getColumnNote(@Param("tableName") String tableName);
}
