/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.interceptor.HandlePrivilegeSqlService;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.mdm.permission.MdmDataPermissionFeign;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.permission.MdmCurrentPermissionRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class OperationConfig {
    private static final Logger log = LoggerFactory.getLogger(OperationConfig.class);
    private static MdmDataPermissionFeign mdmDataPermissionFeign;
    private static MdmPositionFeign mdmPositionFeign;

    public static String createOperationSql(SqlPrivilege sqlPrivilege) {
        List handlePrivilegeSqlServices;
        Object menuCodeObj = ThreadLocalUtil.getObj((String)"menuCode");
        Object functionCodeObj = ThreadLocalUtil.getObj((String)"functionCode");
        String menuCode = Objects.nonNull(menuCodeObj) ? menuCodeObj.toString() : null;
        String functionCode = Objects.nonNull(functionCodeObj) ? functionCodeObj.toString() : null;
        StringBuffer stringBuffer = new StringBuffer();
        if (StringUtils.isEmpty((String)functionCode) || StringUtils.isEmpty((String)menuCode)) {
            return stringBuffer.toString();
        }
        if (mdmDataPermissionFeign == null) {
            mdmDataPermissionFeign = (MdmDataPermissionFeign)SpringApplicationContextUtil.getApplicationContext().getBean("MdmDataPermissionFeign");
        }
        if (mdmPositionFeign == null) {
            mdmPositionFeign = (MdmPositionFeign)SpringApplicationContextUtil.getApplicationContext().getBean("MdmPositionFeign");
        }
        UserRedis userRedis = UserUtils.getUser();
        Map dataPermissionRoleMap = DictUtil.dictMap((String)"data_permission_role");
        String positionCode = userRedis.getPoscode();
        Assert.hasText((String)positionCode, (String)"\u7528\u6237\u6ca1\u6709\u5f53\u524d\u804c\u4f4d\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        ArrayList<String> roleCodes = new ArrayList();
        Result codeByPosition = mdmPositionFeign.findRoleCodeByPosition(Collections.singletonList(positionCode));
        if (!codeByPosition.isSuccess()) {
            log.error("mdm\u804c\u4f4d\u67e5\u8be2\u89d2\u8272\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        } else {
            roleCodes = (List)codeByPosition.getResult();
        }
        if (userRedis == null) {
            stringBuffer.append("1=2");
            return stringBuffer.toString();
        }
        if ("admin".equalsIgnoreCase(userRedis.getUsername())) {
            return stringBuffer.toString();
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(roleCodes) && OperationConfig.validatePermission(dataPermissionRoleMap, roleCodes).booleanValue()) {
            return stringBuffer.toString();
        }
        MdmCurrentPermissionRespVo dataPermission = (MdmCurrentPermissionRespVo)mdmDataPermissionFeign.currentUserDataPermission(menuCode, functionCode).getResult();
        if (Objects.isNull(dataPermission)) {
            log.error("mdm\u6570\u636e\u6743\u9650\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            stringBuffer.append("1=2");
            return stringBuffer.toString();
        }
        if (CollectionUtils.isEmpty((Collection)dataPermission.getPermissionObjCodeList())) {
            return stringBuffer.toString();
        }
        if (CollectionUtils.isEmpty((Collection)dataPermission.getUserPermissionList())) {
            log.error("\u5f53\u524d\u67e5\u8be2\u7528\u6237->{},\u672a\u914d\u7f6e\u83dc\u5355->{},\u529f\u80fd->{},\u7684\u6570\u636e\u6743\u9650", new Object[]{userRedis.getUsername(), menuCode, functionCode});
            stringBuffer.append("1=2");
        }
        if (CollectionUtils.isNotEmpty((Collection)(handlePrivilegeSqlServices = (List)SpringApplicationContextUtil.getApplicationContext().getBean("HandlePrivilegeSqlService", List.class)))) {
            for (HandlePrivilegeSqlService handlePrivilegeSqlService : handlePrivilegeSqlServices) {
                String sql = handlePrivilegeSqlService.handler(sqlPrivilege, dataPermission);
                if (!StringUtils.isNotEmpty((String)sql)) continue;
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(" 2=2 ");
                }
                stringBuffer.append(" and(");
                stringBuffer.append(sql);
                stringBuffer.append(") ");
            }
        }
        String sql = stringBuffer.toString();
        return stringBuffer.toString();
    }

    private static Boolean validatePermission(Map<String, String> dataPermissionRoleMap, List<String> roleCodes) {
        if (MapUtils.isEmpty(dataPermissionRoleMap)) {
            log.error("\u6570\u636e\u5b57\u5178\u7f16\u7801\uff1a{}\u7684\u6570\u636e\u6743\u9650\u653e\u884c\u89d2\u8272\u672a\u914d\u7f6e", (Object)"data_permission_role");
            return false;
        }
        Boolean flag = false;
        for (String roleCode : roleCodes) {
            if (!dataPermissionRoleMap.containsKey(roleCode)) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

