/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.interceptor;

import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.util.OperationConfig;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class DataPermissionInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DataPermissionInterceptor.class);
    static int MAPPED_STATEMENT_INDEX = 0;
    static int PARAMETER_INDEX = 1;

    public Object intercept(Invocation invocation) throws Throwable {
        String sql;
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[MAPPED_STATEMENT_INDEX];
        String id = mappedStatement.getId();
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        if (ObjectUtils.notEqual((Object)SqlCommandType.SELECT, (Object)sqlCommandType)) {
            return invocation.proceed();
        }
        Configuration configuration = mappedStatement.getConfiguration();
        Object parameter1 = args[PARAMETER_INDEX];
        Object target = invocation.getTarget();
        StatementHandler handler = configuration.newStatementHandler((Executor)target, mappedStatement, parameter1, RowBounds.DEFAULT, null, null);
        BoundSql boundSql = handler.getBoundSql();
        String mSql = sql = boundSql.getSql();
        String substring = id.substring(0, id.lastIndexOf("."));
        Method[] methods = Class.forName(substring).getMethods();
        String mName = mappedStatement.getId().substring(id.lastIndexOf(".") + 1, id.length());
        if (mName.endsWith("_COUNT")) {
            mName = mName.substring(0, mName.length() - 6);
        }
        for (Method method : methods) {
            if (!method.isAnnotationPresent(SqlPrivilege.class) || !mName.equals(method.getName())) continue;
            SqlPrivilege sqlPrivilege = method.getAnnotation(SqlPrivilege.class);
            if (!sqlPrivilege.flag()) break;
            String privilegeSql = OperationConfig.createOperationSql(sqlPrivilege);
            mSql = StringUtils.isNotEmpty((CharSequence)privilegeSql) ? sql.replaceFirst("2[\\s]?=[\\s]?2", privilegeSql) : sql;
            BoundSqlSource boundSqlSource = new BoundSqlSource(boundSql);
            MappedStatement newMappedStatement = this.copyFromMappedStatement(mappedStatement, boundSqlSource);
            MetaObject metaObject = MetaObject.forObject((Object)newMappedStatement, (ObjectFactory)new DefaultObjectFactory(), (ObjectWrapperFactory)new DefaultObjectWrapperFactory(), (ReflectorFactory)new DefaultReflectorFactory());
            metaObject.setValue("sqlSource.boundSql.sql", (Object)mSql);
            args[DataPermissionInterceptor.MAPPED_STATEMENT_INDEX] = newMappedStatement;
            break;
        }
        return invocation.proceed();
    }

    public Object plugin(Object object) {
        return Plugin.wrap((Object)object, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuffer keyProperties = new StringBuffer();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    private class BoundSqlSource
    implements SqlSource {
        private BoundSql boundSql;

        private BoundSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

