/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.time.LocalDateTime;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OperatorInterceptor
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(OperatorInterceptor.class);

    public void insertFill(MetaObject metaObject) {
        Object enableStatus;
        log.debug("\u65b0\u589e\u81ea\u52a8\u586b\u5145\u503c");
        String nowDate = DateUtil.formatDate();
        String nowDatehs = DateUtil.formatShortTime();
        UserRedis user = UserUtils.getUser();
        this.setFieldValByName("createDate", nowDate, metaObject);
        this.setFieldValByName("createDateSecond", nowDatehs, metaObject);
        this.setFieldValByName("createDateAll", LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss), metaObject);
        Object status = this.getFieldValByName("delFlag", metaObject);
        if (status == null || status.toString().equals("")) {
            this.setFieldValByName("delFlag", CrmDelFlagEnum.NORMAL.getCode(), metaObject);
        }
        if ((enableStatus = this.getFieldValByName("enableStatus", metaObject)) == null || enableStatus.toString().equals("")) {
            this.setFieldValByName("enableStatus", CrmEnableStatusEnum.ENABLE.getCode(), metaObject);
        }
        if (user != null) {
            String posname;
            String poscode;
            String orgname;
            this.setFieldValByName("createCode", user.getUsername(), metaObject);
            this.setFieldValByName("createName", user.getRealname(), metaObject);
            String orgcode = user.getOrgcode();
            if (orgcode != null && !orgcode.trim().equals("")) {
                this.setFieldValByName("createOrgCode", orgcode, metaObject);
            }
            if ((orgname = user.getOrgname()) != null && !orgname.trim().equals("")) {
                this.setFieldValByName("createOrgName", orgname, metaObject);
            }
            if ((poscode = user.getPoscode()) != null && !poscode.trim().equals("")) {
                this.setFieldValByName("createPosCode", poscode, metaObject);
            }
            if ((posname = user.getPosname()) != null && !posname.trim().equals("")) {
                this.setFieldValByName("createPosName", posname, metaObject);
            }
        }
    }

    public void updateFill(MetaObject metaObject) {
        log.debug("\u4fee\u6539\u81ea\u52a8\u586b\u5145\u503c");
        String nowDate = DateUtil.formatDate();
        String nowDatehs = DateUtil.formatShortTime();
        UserRedis user = UserUtils.getUser();
        this.setFieldValByName("updateDate", nowDate, metaObject);
        this.setFieldValByName("updateDateSecond", nowDatehs, metaObject);
        this.setFieldValByName("updateDateAll", LocalDateTime.now().format(CrmDateUtils.yyyyMMddHHmmss), metaObject);
        if (user != null) {
            this.setFieldValByName("updateCode", user.getUsername(), metaObject);
            this.setFieldValByName("updateName", user.getRealname(), metaObject);
            this.setFieldValByName("updateOrgCode", user.getOrgcode(), metaObject);
            this.setFieldValByName("updateOrgName", user.getOrgname(), metaObject);
            this.setFieldValByName("updatePosCode", user.getPoscode(), metaObject);
            this.setFieldValByName("updatePosName", user.getPosname(), metaObject);
        }
    }
}

