/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.subarea;

import com.biz.crm.base.BusinessException;
import com.biz.crm.service.RedisService;
import com.biz.crm.subarea.mapper.SubareaMapper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SubareaUtil {
    @Value(value="${crm.subarea.data:3}")
    private String SubareaData;
    @Value(value="${crm.subarea.flag:N}")
    private String subareaFlag;
    public static String issubarea = "N";
    public static Map<String, String> subareaMap = new HashMap<String, String>();
    private static RedisService redisService;
    private static SubareaMapper subareaMapper;

    @PostConstruct
    public void setFlag() {
        issubarea = this.subareaFlag;
    }

    @Autowired
    public static void setSubareaMapper(SubareaMapper subareaMapper) {
        SubareaUtil.subareaMapper = subareaMapper;
    }

    @Autowired
    public static void setRedisService(RedisService redisService) {
        SubareaUtil.redisService = redisService;
    }

    public static boolean isSubarea() {
        return issubarea.equals("Y");
    }

    public static String getData(String yyyyMMdd) {
        String year = yyyyMMdd.substring(0, 4);
        String month = yyyyMMdd.substring(5, 7);
        return year + subareaMap.get(month);
    }

    public static String getSubareaTable(String yyyyMMdd, String tableName) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new BusinessException("[tableName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!SubareaUtil.isSubarea()) {
            return tableName;
        }
        if (StringUtils.isEmpty((CharSequence)yyyyMMdd)) {
            return tableName;
        }
        String subareatableName = subareaMapper.getTableNameCache(tableName, SubareaUtil.getData(yyyyMMdd));
        subareatableName = StringUtils.isEmpty((CharSequence)subareatableName) ? tableName : subareatableName;
        return subareatableName;
    }

    static {
        subareaMap.put("01", "1");
        subareaMap.put("02", "1");
        subareaMap.put("03", "1");
        subareaMap.put("04", "2");
        subareaMap.put("05", "2");
        subareaMap.put("06", "2");
        subareaMap.put("07", "3");
        subareaMap.put("08", "3");
        subareaMap.put("09", "3");
        subareaMap.put("10", "4");
        subareaMap.put("11", "4");
        subareaMap.put("12", "4");
    }
}

