/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.subarea.service.impl;

import com.biz.crm.sqlupdate.CrmColumnVo;
import com.biz.crm.sqlupdate.CrmTableVo;
import com.biz.crm.sqlupdate.IndexVo;
import com.biz.crm.sqlupdate.mapper.DoOracleUpdateSqlMapper;
import com.biz.crm.sqlupdate.mapper.OracleBaseMapper;
import com.biz.crm.sqlupdate.oracle.vo.AllTabColsVo;
import com.biz.crm.sqlupdate.vo.PrimaryKey;
import com.biz.crm.sqlupdate.vo.TableIndex;
import com.biz.crm.subarea.mapper.SubareaMapper;
import com.biz.crm.util.CollectionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class SubareaOracleService {
    @Resource
    private SubareaMapper subareaMapper;
    @Resource
    private OracleBaseMapper oracleBaseMapper;
    @Resource
    private DoOracleUpdateSqlMapper doOracleUpdateSqlMapper;

    public String createTable(String tableName, String subareaDate) {
        String subareaTableName = this.subareaMapper.getTableName(tableName, subareaDate);
        if (StringUtils.isEmpty((CharSequence)subareaTableName)) {
            subareaTableName = tableName + subareaDate;
            List<AllTabColsVo> allTabColsVos = this.oracleBaseMapper.getAllColumn(tableName);
            List<PrimaryKey> primaryKeys = this.doOracleUpdateSqlMapper.getPrimaryKey(tableName);
            List<TableIndex> tableIndexs = this.oracleBaseMapper.getAllIndex(tableName);
            CrmTableVo crmTableVo = this.createCrmTableVo(subareaDate, subareaTableName, tableName, allTabColsVos, primaryKeys, tableIndexs);
            this.doOracleUpdateSqlMapper.createTable(crmTableVo);
            if (CollectionUtil.listNotEmptyNotSizeZero(crmTableVo.getCrmColumnVos())) {
                for (CrmColumnVo crmColumnVo : crmTableVo.getCrmColumnVos()) {
                    this.doOracleUpdateSqlMapper.commentTable(crmColumnVo, crmTableVo.getName());
                }
            }
            if (crmTableVo.getKey() != null) {
                this.doOracleUpdateSqlMapper.updatePrimaryKey(crmTableVo);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(crmTableVo.getIndexVos())) {
                for (IndexVo indexVo : crmTableVo.getIndexVos()) {
                    this.doOracleUpdateSqlMapper.updateIndex(indexVo, crmTableVo);
                }
            }
        }
        return subareaTableName;
    }

    private CrmTableVo createCrmTableVo(String subareaDate, String subareaTableName, String tableName, List<AllTabColsVo> allTabColsVos, List<PrimaryKey> primaryKeys, List<TableIndex> tableIndexs) {
        CrmColumnVo crmColumnVo;
        CrmTableVo crmTableVo = new CrmTableVo();
        crmTableVo.setName(subareaTableName.toUpperCase());
        crmTableVo.setTableNote(tableName + "\u5206\u533a");
        ArrayList<CrmColumnVo> crmColumnVos = new ArrayList<CrmColumnVo>();
        for (AllTabColsVo item : allTabColsVos) {
            crmColumnVo = new CrmColumnVo();
            crmColumnVo.setNote(item.getComments());
            crmColumnVo.setName(item.getColumnName());
            crmColumnVo.setOracleType(item.getDataType());
            if (item.getDataType().equalsIgnoreCase("VARCHAR2")) {
                crmColumnVo.setOracleType("VARCHAR2");
                crmColumnVo.setLength(Integer.valueOf(item.getDataLength()));
            } else if (item.getDataType().equalsIgnoreCase("NUMBER")) {
                crmColumnVo.setOracleType("NUMBER(" + item.getDataPrecision() + "," + item.getDataScale() + ")");
            }
            crmColumnVo.setNullable(true);
            crmColumnVos.add(crmColumnVo);
        }
        crmTableVo.setCrmColumnVos(crmColumnVos);
        HashSet<String> setPk = new HashSet<String>();
        if (CollectionUtil.listNotEmpty(primaryKeys)) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < primaryKeys.size(); ++i) {
                if (i == 0) {
                    stringBuffer.append(primaryKeys.get(i).getColumnName());
                } else {
                    stringBuffer.append(",").append(primaryKeys.get(i).getColumnName());
                }
                setPk.add(primaryKeys.get(i).getConstraintName().toUpperCase());
            }
            crmColumnVo = new CrmColumnVo();
            crmColumnVo.setName(stringBuffer.toString());
            crmTableVo.setPrimaryKey(subareaTableName + "_PK");
            crmTableVo.setKey(crmColumnVo);
        }
        if (CollectionUtil.listNotEmpty(tableIndexs)) {
            ArrayList<IndexVo> indexVos = new ArrayList<IndexVo>();
            HashMap map = new HashMap();
            for (TableIndex tableIndex : tableIndexs) {
                if (setPk.contains(tableIndex.getIndexName().toUpperCase())) continue;
                String indexName = tableIndex.getIndexName().toUpperCase();
                if (map.containsKey(indexName)) {
                    ((List)map.get(indexName)).add(tableIndex);
                    continue;
                }
                ArrayList<TableIndex> temp = new ArrayList<TableIndex>();
                temp.add(tableIndex);
                map.put(indexName, temp);
            }
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    IndexVo indexVo = new IndexVo();
                    List tableIndices = (List)entry.getValue();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < tableIndices.size(); ++i) {
                        if (i == 0) {
                            stringBuffer.append(((TableIndex)tableIndices.get(i)).getColumnName().toUpperCase());
                            if (((TableIndex)tableIndices.get(i)).getUniqueness().equalsIgnoreCase("UNIQUE")) {
                                indexVo.setUnique(true);
                                continue;
                            }
                            indexVo.setUnique(false);
                            continue;
                        }
                        stringBuffer.append(",").append(((TableIndex)tableIndices.get(i)).getColumnName().toUpperCase());
                    }
                    indexVo.setColumnList(stringBuffer.toString());
                    indexVo.setName((String)entry.getKey() + subareaDate);
                    indexVos.add(indexVo);
                }
            }
            crmTableVo.setIndexVos(indexVos);
        }
        return crmTableVo;
    }
}

