/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.sqlupdate.mysql;

import com.biz.crm.sqlupdate.CrmColumnVo;
import com.biz.crm.sqlupdate.CrmTableVo;
import com.biz.crm.sqlupdate.IndexVo;
import com.biz.crm.sqlupdate.mapper.DoMysqlUpdateSqlMapper;
import com.biz.crm.sqlupdate.mysql.vo.MysqlTable;
import com.biz.crm.sqlupdate.oracle.vo.AllTabColsVo;
import com.biz.crm.sqlupdate.vo.PrimaryKey;
import com.biz.crm.sqlupdate.vo.TableColumnNote;
import com.biz.crm.sqlupdate.vo.TableIndex;
import com.biz.crm.sqlupdate.vo.TableNote;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MysqlUserTablesService {
    @Autowired(required=false)
    private DoMysqlUpdateSqlMapper doMysqlUpdateSqlMapper;
    public static String database = null;

    private void intiDataBase() {
        if (StringUtils.isEmpty((String)database)) {
            database = this.doMysqlUpdateSqlMapper.selectDatabase();
        }
    }

    private Map<String, MysqlTable> getAllTables() {
        this.intiDataBase();
        HashMap<String, MysqlTable> map = new HashMap<String, MysqlTable>();
        List<MysqlTable> userTables = this.doMysqlUpdateSqlMapper.getAlltable();
        if (CollectionUtil.listNotEmptyNotSizeZero(userTables)) {
            for (MysqlTable oracleUserTables : userTables) {
                String tableName = oracleUserTables.getTableName().toUpperCase();
                map.put(tableName, oracleUserTables);
            }
        }
        return map;
    }

    public void updateSql(List<CrmTableVo> crmTableVos) {
        if (CollectionUtil.listNotEmptyNotSizeZero(crmTableVos)) {
            Map<String, MysqlTable> mapTable = this.getAllTables();
            for (CrmTableVo crmTableVo : crmTableVos) {
                String tableName = crmTableVo.getName();
                if (mapTable.containsKey(tableName)) {
                    this.updateTable(crmTableVo);
                    continue;
                }
                this.initTable(crmTableVo);
            }
        }
    }

    private void initTable(CrmTableVo crmTableVo) {
        this.doMysqlUpdateSqlMapper.createTable(crmTableVo);
        if (crmTableVo.getKey() != null) {
            this.doMysqlUpdateSqlMapper.updatePrimaryKey(crmTableVo);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(crmTableVo.getIndexVos())) {
            for (IndexVo indexVo : crmTableVo.getIndexVos()) {
                this.doMysqlUpdateSqlMapper.updateIndex(indexVo, crmTableVo);
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(crmTableVo.getCrmColumnVos())) {
            for (CrmColumnVo crmColumnVo : crmTableVo.getCrmColumnVos()) {
                this.doMysqlUpdateSqlMapper.commentTable(crmColumnVo, crmTableVo.getName());
            }
        }
        this.updateTableNote(crmTableVo);
    }

    private void updateTableNote(CrmTableVo crmTableVo) {
        TableNote tableNote = this.doMysqlUpdateSqlMapper.getTableNote(crmTableVo.getName());
        if ((tableNote == null || !StringUtils.isNotEmpty((String)tableNote.getComments())) && StringUtils.isNotEmpty((String)crmTableVo.getTableNote())) {
            this.doMysqlUpdateSqlMapper.updateTableNote(crmTableVo);
        }
    }

    private void updateTableColumnNote(CrmTableVo crmTableVo) {
        List<TableColumnNote> columnNotes = this.doMysqlUpdateSqlMapper.getColumnNote(crmTableVo.getName());
        if (CollectionUtil.listEmpty(columnNotes)) {
            return;
        }
        HashMap<String, TableColumnNote> map = new HashMap<String, TableColumnNote>();
        for (TableColumnNote note : columnNotes) {
            map.put(note.getColumnName().toUpperCase(), note);
        }
        for (CrmColumnVo crmColumnVo : crmTableVo.getCrmColumnVos()) {
            if (StringUtils.isEmpty((String)crmColumnVo.getNote()) || map.containsKey(crmColumnVo.getName()) && !StringUtils.isEmpty((String)((TableColumnNote)map.get(crmColumnVo.getName())).getNote())) continue;
            this.doMysqlUpdateSqlMapper.commentTable(crmColumnVo, crmTableVo.getName());
        }
    }

    private void updateTable(CrmTableVo crmTableVo) {
        List<AllTabColsVo> tabColsVos = this.doMysqlUpdateSqlMapper.getAllTab(crmTableVo.getName());
        HashMap<String, AllTabColsVo> mapCols = new HashMap<String, AllTabColsVo>();
        for (AllTabColsVo allTabColsVo : tabColsVos) {
            String columnName = allTabColsVo.getColumnName().toUpperCase();
            mapCols.put(columnName, allTabColsVo);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(crmTableVo.getCrmColumnVos())) {
            for (CrmColumnVo crmColumnVo : crmTableVo.getCrmColumnVos()) {
                if (mapCols.containsKey(crmColumnVo.getName())) continue;
                this.doMysqlUpdateSqlMapper.addCols(crmColumnVo, crmTableVo.getName());
                this.doMysqlUpdateSqlMapper.commentTable(crmColumnVo, crmTableVo.getName());
            }
            this.updatePrimaryKeys(crmTableVo);
        }
        this.updateTableNote(crmTableVo);
        this.updateTableColumnNote(crmTableVo);
        this.updateIndex(crmTableVo);
    }

    private void updatePrimaryKeys(CrmTableVo crmTableVo) {
        if (crmTableVo.getKey() == null) {
            return;
        }
        List<PrimaryKey> primaryKeys = this.doMysqlUpdateSqlMapper.getPrimaryKey(crmTableVo.getName());
        if (CollectionUtil.listEmpty(primaryKeys)) {
            return;
        }
        HashMap<String, PrimaryKey> map = new HashMap<String, PrimaryKey>();
        for (PrimaryKey item : primaryKeys) {
            map.put(item.getColumnName().toUpperCase(), item);
        }
        if (!map.containsKey(crmTableVo.getKey().getName())) {
            this.doMysqlUpdateSqlMapper.updatePrimaryKey(crmTableVo);
        }
    }

    private void updateIndex(CrmTableVo crmTableVo) {
        if (CollectionUtil.listEmpty(crmTableVo.getIndexVos())) {
            return;
        }
        List<TableIndex> indexList = this.doMysqlUpdateSqlMapper.getAllIndex(crmTableVo.getName());
        HashMap<String, TableIndex> map = new HashMap<String, TableIndex>();
        for (TableIndex index : indexList) {
            String columnName = index.getColumnName().toUpperCase();
            if (crmTableVo.getKey() != null && crmTableVo.getKey().getName().equals(columnName)) continue;
            map.put(index.getIndexName().toUpperCase(), index);
        }
        for (IndexVo indexVo : crmTableVo.getIndexVos()) {
            if (map.containsKey(indexVo.getName())) continue;
            this.doMysqlUpdateSqlMapper.updateIndex(indexVo, crmTableVo);
        }
    }
}

