package com.biz.crm.interceptor;

import com.biz.crm.eunm.mdm.MdmPermissionObjEnum;
import com.biz.crm.nebular.mdm.permission.MdmCurrentPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmCurrentUserPermissionRespVo;
import com.biz.crm.util.SqlUtil;
import com.google.common.collect.Sets;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @Project crm
 * @PackageName com.biz.crm.interceptor
 * @ClassName HandlePrivilegeSqlServiceImpl
 * @Author HuangLong
 * @Date 2020/11/24 17:53
 * @Description 产品组预置组织和职位的权限拦截, 其他的需要各项目自己去实现
 */
@Component(value = "HandlePrivilegeSqlService")
public class HandlePrivilegeSqlServiceImpl implements HandlePrivilegeSqlService {


    @Override
    public String handler(SqlPrivilege sqlPrivilege, MdmCurrentPermissionRespVo dataPermission) {
        Boolean multiPermission = false;
        StringBuffer sqlBuffer = new StringBuffer();
        List<MdmCurrentUserPermissionRespVo> userPermissionList = dataPermission.getUserPermissionList();
        if (CollectionUtils.isNotEmpty(userPermissionList)) {
            Set<String> posList = Sets.newHashSet();
            Set<String> orgList = Sets.newHashSet();
            Set<String> customerList = Sets.newHashSet();
            userPermissionList.forEach(o -> {
                if (StringUtils.equals(MdmPermissionObjEnum.ORG.getCode(), o.getPermissionObjCode())) {
                    this.getAllValue(o.getPermissionValueList(), orgList);
                }
                if (StringUtils.equals(MdmPermissionObjEnum.POSITION.getCode(), o.getPermissionObjCode())) {
                    this.getAllValue(o.getPermissionValueList(), posList);
                }
                if (StringUtils.equals(MdmPermissionObjEnum.CUSTOMER.getCode(), o.getPermissionObjCode())) {
                    this.getAllValue(o.getPermissionValueList(), customerList);
                }
            });
            List<String> excludePermissionObjCodeList = dataPermission.getExcludePermissionObjCodeList();
            if (CollectionUtils.isEmpty(excludePermissionObjCodeList) || !excludePermissionObjCodeList.contains(MdmPermissionObjEnum.ORG.getCode())) {
                if (!StringUtils.isEmpty(sqlPrivilege.extOrgSql()) && !CollectionUtils.isEmpty(orgList)) {
                    multiPermission = extMultiPermission(sqlPrivilege.extOrgSql(), multiPermission, sqlBuffer, orgList);
                } else if (StringUtils.isNotEmpty(sqlPrivilege.orgCode()) && CollectionUtils.isNotEmpty(orgList)) {
                    multiPermission = defaultMultiPermission(sqlPrivilege.orgCode(), multiPermission, sqlBuffer, orgList);
                } else if (StringUtils.isNotBlank(sqlPrivilege.inOrgSql()) && !CollectionUtils.isEmpty(orgList)) {
                    multiPermission = inMultiPermission(sqlPrivilege.inOrgSql(), multiPermission, sqlBuffer, orgList);
                }
            }
            if (CollectionUtils.isEmpty(excludePermissionObjCodeList) || !excludePermissionObjCodeList.contains(MdmPermissionObjEnum.POSITION.getCode())) {
                if (!StringUtils.isEmpty(sqlPrivilege.extPosSql()) && CollectionUtils.isNotEmpty(posList)) {
                    multiPermission = extMultiPermission(sqlPrivilege.extPosSql(), multiPermission, sqlBuffer, posList);
                } else if (StringUtils.isNotEmpty(sqlPrivilege.posCode()) && CollectionUtils.isNotEmpty(posList)) {
                    multiPermission = defaultMultiPermission(sqlPrivilege.posCode(), multiPermission, sqlBuffer, posList);
                } else if (!StringUtils.isEmpty(sqlPrivilege.inPositionSql()) && !CollectionUtils.isEmpty(posList)) {
                    multiPermission = inMultiPermission(sqlPrivilege.inPositionSql(), multiPermission, sqlBuffer, posList);
                }
            }
            if (CollectionUtils.isEmpty(excludePermissionObjCodeList) || !excludePermissionObjCodeList.contains(MdmPermissionObjEnum.POSITION.getCode())) {
                if (!StringUtils.isEmpty(sqlPrivilege.extCustSql()) && CollectionUtils.isNotEmpty(customerList)) {
                    multiPermission = extMultiPermission(sqlPrivilege.extCustSql(), multiPermission, sqlBuffer, customerList);
                } else if (StringUtils.isNotEmpty(sqlPrivilege.custCode()) && CollectionUtils.isNotEmpty(customerList)) {
                    multiPermission = defaultMultiPermission(sqlPrivilege.custCode(), multiPermission, sqlBuffer, customerList);
                } else if (!StringUtils.isEmpty(sqlPrivilege.inCustomerSql()) && !CollectionUtils.isEmpty(customerList)) {
                    multiPermission = inMultiPermission(sqlPrivilege.inCustomerSql(), multiPermission, sqlBuffer, customerList);
                }
            }
        }
        return sqlBuffer.toString();
    }

    private Boolean defaultMultiPermission(String field, Boolean multiPermission, StringBuffer sqlBuffer, Set<String> orgList) {
        multiPermission = extracted(multiPermission, sqlBuffer);
        String orgSql = SqlUtil.setSqlIn(orgList.toArray(new String[orgList.size()]), field, true, "");
        sqlBuffer.append(orgSql);
        return multiPermission;
    }

    public static void main(String[] args) {
        Set<String> set = new HashSet<>();
        set.add("1");
        set.add("2");
        set.add("3");
        StringBuffer sb = new StringBuffer();
        HandlePrivilegeSqlServiceImpl impl = new HandlePrivilegeSqlServiceImpl();
        Boolean flag = impl.inMultiPermission("a.terminal_code in(select terminal_code from mdm_terminal_r_org where org_code in )", false
                , sb, set);
        System.out.println("sb = " + sb);
    }

    public Boolean inMultiPermission(String extSql, Boolean multiPermission, StringBuffer sqlBuffer, Set<String> list) {
        multiPermission = extracted(multiPermission, sqlBuffer);
        String[] split = extSql.split(" ");
        String orgCode = split[split.length - 3];
        String s = SqlUtil.setSqlIn(list, orgCode, true, "");
        String prefix = extSql.substring(0, extSql.lastIndexOf(orgCode));
        sqlBuffer.append(prefix);
        sqlBuffer.append(s);
        return multiPermission;
    }

    private Boolean extMultiPermission(String extSql, Boolean multiPermission, StringBuffer sqlBuffer, Set<String> list) {
        multiPermission = extracted(multiPermission, sqlBuffer);
        sqlBuffer.append(" exists(");
        String sub1 = extSql.substring(0, extSql.lastIndexOf("and"));
        String sub2 = extSql.substring(extSql.lastIndexOf("and"));
        String[] split = sub2.split(" ");
        String s = SqlUtil.setSqlIn(list.toArray(new String[list.size()]), split[1], true, "");
        sqlBuffer.append(sub1).append(" and ").append(s);
        sqlBuffer.append(") ");
        return multiPermission;
    }

    private boolean extracted(Boolean multiPermission, StringBuffer sqlBuffer) {
        if (multiPermission) {
            sqlBuffer.append(" or ");
        } else {
            multiPermission = true;
        }
        return multiPermission;
    }

//    protected boolean extracted(boolean andSymbolized,StringBuffer sqlBuffer) {
//        if (andSymbolized) {
//            sqlBuffer.append(" ");
//        }else{
//            sqlBuffer.append(" or ");
//        }
//        return false;
//    }


    protected Set<String> getAllValue(List<String> permissionValueList, Set<String> set) {
        if (!CollectionUtils.isEmpty(permissionValueList)) {
            set.addAll(permissionValueList);
        }
        return set;
    }
}
