/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.base.aop;

import com.biz.crm.base.util.ExcelImportUtil;
import com.biz.crm.common.ParamCheck;
import com.biz.crm.nebular.mdm.enums.ParamCheckTypeEnum;
import com.biz.crm.repository.DictEntityRepository;
import com.bizunited.platform.kuiper.starter.common.excel.exception.ExcelMigrateException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ExcelImportAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelImportAspect.class);
    @Autowired
    private DictEntityRepository dictEntityRepository;

    @Before(value="@annotation(ExcelImport)")
    public void doBefore(JoinPoint joinPoint) throws IllegalAccessException, ParseException {
        LOGGER.info("-----------------------------\u5bfc\u5165\u529f\u80fd\u524d\u7f6e\u53c2\u6570\u5904\u7406-----------------------------");
        ExcelImportUtil.threadLocalExcelImportUtil.remove();
        String methodName = joinPoint.getSignature().getName();
        if (!"process".equals(methodName)) {
            LOGGER.info("\u58f0\u660e\u5b9a\u4e49\u9519\u8bef\uff0c\u8bf7\u5728\u5bfc\u5165\u529f\u80fd\u7684 process() \u65b9\u6cd5\u4e0a\u4f7f\u7528 @ExcelImport \u8fdb\u884c\u58f0\u660e\u3002 ");
            return;
        }
        Object[] params = joinPoint.getArgs();
        if (ArrayUtils.isEmpty((Object[])params)) {
            LOGGER.info("\u65b9\u6cd5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u65b9\u6cd5\u53c2\u6570");
            return;
        }
        Map mapParams = (Map)params[1];
        HttpServletRequest request = (HttpServletRequest)mapParams.get("request");
        ExcelImportUtil excelImportUtil = new ExcelImportUtil();
        excelImportUtil.setAccount(String.valueOf(mapParams.get("account")));
        excelImportUtil.setRequest(request);
        ExcelImportUtil.threadLocalExcelImportUtil.set(excelImportUtil);
        this.paramCheck(params[0]);
        LOGGER.info("-----------------------------\u5bfc\u5165\u529f\u80fd\u524d\u7f6e\u53c2\u6570\u5904\u7406\u5b8c\u6210-----------------------------");
    }

    private void paramCheck(Object obj) throws IllegalAccessException, ParseException {
        Field[] fields;
        if (null == obj) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Class<?> aClass = obj.getClass();
        for (Field field : fields = aClass.getDeclaredFields()) {
            field.setAccessible(true);
            Annotation[] annotations = field.getAnnotations();
            ParamCheck paramCheck = field.getAnnotation(ParamCheck.class);
            if (paramCheck == null) continue;
            this.paramBusinessCheck(field, paramCheck, obj);
        }
    }

    private void paramBusinessCheck(Field field, ParamCheck paramCheck, Object obj) throws IllegalAccessException, ParseException {
        if (!ObjectUtils.allNotNull((Object[])new Object[]{field, paramCheck})) {
            throw new RuntimeException("\u5bfc\u5165\u53c2\u6570\u4e1a\u52a1\u6821\u9a8c\u5f02\u5e38");
        }
        Object o = field.get(obj);
        boolean b = paramCheck.isNotNull();
        if (b && StringUtils.isBlank((CharSequence)String.valueOf(o))) {
            throw new ExcelMigrateException(paramCheck.msg());
        }
        ParamCheckTypeEnum[] paramCheckTypeEnums = paramCheck.checkType();
        if (paramCheckTypeEnums.length > 0) {
            for (ParamCheckTypeEnum paramCheckTypeEnum : paramCheckTypeEnums) {
                if (ParamCheckTypeEnum.NUMBER == paramCheckTypeEnum) {
                    this.numberCheck(field, paramCheck, obj);
                    continue;
                }
                if (ParamCheckTypeEnum.TEXT == paramCheckTypeEnum) continue;
                if (ParamCheckTypeEnum.DATE == paramCheckTypeEnum) {
                    if (StringUtils.isBlank((CharSequence)paramCheck.dateFormat())) {
                        throw new IllegalArgumentException("\u6821\u9a8c\u7c7b\u578b\u5305\u542b\u65f6\u95f4\u683c\u5f0f\u6821\u9a8c\uff0c\u8bf7\u8bbe\u7f6edateFormat(\u5b57\u5178\u7c7b\u578b)\u503c");
                    }
                    this.dateCheck(paramCheck.dateFormat(), String.valueOf(o));
                    continue;
                }
                if (ParamCheckTypeEnum.DICT == paramCheckTypeEnum) {
                    if (StringUtils.isBlank((CharSequence)paramCheck.dictType())) {
                        throw new IllegalArgumentException("\u6821\u9a8c\u7c7b\u578b\u5305\u542b\u5b57\u5178\u6821\u9a8c\uff0c\u8bf7\u8bbe\u7f6edictType(\u5b57\u5178\u7c7b\u578b)\u503c");
                    }
                    String dictValue = this.dictCheck(paramCheck.dictType(), String.valueOf(o));
                    field.set(obj, dictValue);
                    continue;
                }
                if (ParamCheckTypeEnum.LENGTH != paramCheckTypeEnum) continue;
                this.lengthCheck(paramCheck.length(), String.valueOf(o));
            }
        }
    }

    private void numberCheck(Field field, ParamCheck paramCheck, Object obj) {
    }

    private void textCheck(Field field, ParamCheck paramCheck, Object obj) {
    }

    private void dateCheck(String format, String value) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        Date date = simpleDateFormat.parse(value);
        String str = simpleDateFormat.format(date);
        if (!str.equals(value)) {
            throw new ExcelMigrateException("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef,\u8bf7\u68c0\u67e5");
        }
    }

    private String dictCheck(String dictType, String value) {
        String dictValue = this.dictEntityRepository.findDictCollectionByDictCodeType(dictType, value);
        if (StringUtils.isBlank((CharSequence)dictValue)) {
            throw new ExcelMigrateException(value + "\uff1a\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u5bfc\u5165\u3002");
        }
        return dictValue;
    }

    private void lengthCheck(Integer length, String value) {
        if (value.length() > length) {
            throw new ExcelMigrateException(value + "\uff1a\u957f\u5ea6\u8d85\u8fc7\u4e86" + length + "\uff0c\u8bf7\u4fee\u6539\u3002");
        }
    }
}

