/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.base.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.util.StringUtils;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.kuiper.entity.InstanceEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityAttributesEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.service.InstanceService;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.service.TemplateLayoutService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/configController"})
@Api(tags={"nebula\u914d\u7f6e"}, description="nebula\u914d\u7f6e")
public class ConfigController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ConfigController.class);
    @Autowired
    private InstanceService instanceService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private TemplateLayoutService templateLayoutService;
    @Autowired
    private TemplateVisibilityService templateVisibilityService;

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u83b7\u53d6\u8868\u5355\u914d\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="templateCode", value="\u7f16\u53f7", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="cversion", value="\u7248\u672c", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="visibilityName", value="\u53ef\u89c1\u6027", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"getFormConfig"})
    public List<JSONObject> getFormConfig(@RequestParam(value="templateCode") String templateCode, @RequestParam(value="cversion", required=false) String cversion, @RequestParam(value="visibilityName", required=false) String visibilityName) {
        Object list;
        Principal principal = this.getPrincipal();
        String account = principal.getName();
        InstanceEntity currentInstance = null;
        currentInstance = StringUtils.isEmpty((String)cversion) ? this.instanceService.createByTemplateCode(templateCode, null, account) : this.instanceService.createByTemplateCode(templateCode, cversion, null, account);
        visibilityName = StringUtils.isEmpty((String)visibilityName) ? "create" : visibilityName;
        TemplateEntity templateEntity = currentInstance.getTemplate();
        String templateId = templateEntity.getId();
        TemplateEntity result = this.templateService.findDetailsById(templateId);
        TemplateVisibilityEntity visibility = this.templateVisibilityService.findDetailsByTemplateIdAndVisibilityNameAndLayoutType(templateId, visibilityName, Integer.valueOf(1));
        HashMap<String, TemplateVisibilityAttributesEntity> visibilityMap = new HashMap<String, TemplateVisibilityAttributesEntity>();
        for (TemplateVisibilityAttributesEntity entity : visibility.getAttributes()) {
            visibilityMap.put(entity.getAttributeName(), entity);
        }
        JSONObject layout = this.templateLayoutService.findDetailsByTemplateId(templateId, Integer.valueOf(1));
        TreeMap mapx = new TreeMap();
        JSONObject cells = layout.getJSONObject("cells");
        for (Object keyTemp : cells.keySet()) {
            Integer n = Integer.valueOf(((String)keyTemp).split(",")[0]);
            JSONObject jsonObject = cells.getJSONObject((String)keyTemp);
            JSONObject jsonObjectTemp = new JSONObject();
            jsonObjectTemp.put((String)keyTemp, (Object)jsonObject);
            if (mapx.containsKey(n)) {
                ((List)mapx.get(n)).add(jsonObjectTemp);
                continue;
            }
            list = new ArrayList();
            list.add((JSONObject)jsonObjectTemp);
            mapx.put(n, list);
        }
        ArrayList retrunList = new ArrayList();
        for (Map.Entry entry : mapx.entrySet()) {
            List jsonObjects = (List)entry.getValue();
            TreeMap<Integer, JSONObject> mapY = new TreeMap<Integer, JSONObject>();
            for (JSONObject jsonObject : jsonObjects) {
                for (String keyTemp : jsonObject.keySet()) {
                    Integer temp = Integer.valueOf(keyTemp.split(",")[1]);
                    mapY.put(temp, jsonObject.getJSONObject(keyTemp));
                }
            }
            for (Map.Entry tempMapy : mapY.entrySet()) {
                retrunList.add(tempMapy.getValue());
            }
        }
        LinkedHashMap<Object, Object> mapRetrun = new LinkedHashMap<Object, Object>();
        for (JSONObject jsonObject : retrunList) {
            Object name = jsonObject.getString("for");
            if (StringUtils.isEmpty((String)name)) {
                name = jsonObject.getString("field");
            }
            if (StringUtils.isEmpty((String)name) && jsonObject.containsKey((Object)"controltype") && jsonObject.getString("controltype").equals("header")) {
                name = jsonObject.getString("name");
            }
            if (StringUtils.isEmpty((String)name) && jsonObject.containsKey((Object)"controltype") && jsonObject.getString("type").equals("button")) {
                name = jsonObject.getString("name");
            }
            if (StringUtils.isEmpty((String)name)) {
                if (jsonObject.size() <= 0) continue;
                log.info("\u8fd9\u91cc\u6709\u95ee\u9898");
                continue;
            }
            if (mapRetrun.containsKey(name)) {
                ((List)mapRetrun.get(name)).add(jsonObject);
                continue;
            }
            list = new ArrayList();
            list.add(jsonObject);
            mapRetrun.put(name, list);
        }
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        HashMap<String, TemplatePropertyEntity> mapPro = new HashMap<String, TemplatePropertyEntity>();
        for (TemplatePropertyEntity templatePropertyEntity : result.getProperties()) {
            String name = templatePropertyEntity.getPropertyName();
            if (StringUtils.isEmpty((String)name)) continue;
            mapPro.put(name, templatePropertyEntity);
        }
        String formInstanceId = currentInstance.getId();
        for (Map.Entry tempmap : mapRetrun.entrySet()) {
            JSONObject jsonObject = new JSONObject();
            String name = (String)tempmap.getKey();
            if (StringUtils.isEmpty((String)name)) continue;
            jsonObject.put("filed", (Object)name);
            Integer visibilityType = visibilityMap.containsKey(name) ? ((TemplateVisibilityAttributesEntity)visibilityMap.get(name)).getVisibilityType() : 3;
            jsonObject.put("visibilityType", (Object)visibilityType);
            Boolean nullable = visibilityMap.containsKey(name) ? ((TemplateVisibilityAttributesEntity)visibilityMap.get(name)).getNullable() : false;
            jsonObject.put("nullable", (Object)nullable);
            if (mapRetrun.containsKey(name)) {
                for (JSONObject temp : (List)mapRetrun.get(name)) {
                    if (temp.containsKey((Object)"controltype") && "label".equals(temp.getString("controltype"))) {
                        jsonObject.put("label", (Object)temp);
                        continue;
                    }
                    if (!temp.containsKey((Object)"controltype") && temp.containsKey((Object)"type")) {
                        temp.put("controltype", (Object)temp.getString("type"));
                    }
                    jsonObject.put("attribute", (Object)temp);
                }
            }
            jsonObject.put("formInstanceId", (Object)formInstanceId);
            arrayList.add(jsonObject);
        }
        return arrayList;
    }
}

