/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.base.util;

import com.biz.crm.base.util.ExcelImportUtil;
import com.biz.crm.base.util.HttpServletRequestUtil;
import com.biz.crm.nebular.mdm.humanarea.GetByUserAccount;
import com.biz.crm.service.RedisService;
import com.biz.crm.service.humanarea.HumanAreaService;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NebulaUserUtil {
    private static final Logger log = LoggerFactory.getLogger(NebulaUserUtil.class);
    private static RedisService redisService;
    private static HumanAreaService humanAreaService;

    private static void initRedis() {
        if (redisService == null) {
            redisService = (RedisService)ApplicationContextUtils.getApplicationContext().getBean(RedisService.class);
        }
        if (humanAreaService == null) {
            humanAreaService = (HumanAreaService)ApplicationContextUtils.getApplicationContext().getBean(HumanAreaService.class);
        }
    }

    public static UserRedis getUser() {
        String token = NebulaUserUtil.getUserToken();
        if (StringUtils.isEmpty((String)token)) {
            return null;
        }
        NebulaUserUtil.initRedis();
        if (redisService.hasKey(token)) {
            Object o = redisService.get(token);
            return (UserRedis)o;
        }
        UserRedis userRedis = NebulaUserUtil.createUser(token);
        redisService.setDays(token, (Object)userRedis, 5L);
        NebulaUserUtil.setTokenUser(userRedis, token);
        return userRedis;
    }

    private static void setTokenUser(UserRedis userRedis, String token) {
        String user_token = "LOGIN_USER_TOKEN_" + userRedis.getUsername();
        if (redisService.hasKey(user_token)) {
            Set tokens = redisService.sGet(user_token);
            tokens.forEach(set -> {
                String tokenTemp = (String)set;
                if (!redisService.hasKey(tokenTemp)) {
                    redisService.setRemove(user_token, new Object[]{tokenTemp});
                }
            });
        } else {
            redisService.sSetAndTime(user_token, 63072000L, new Object[]{token});
        }
    }

    private static UserRedis createUser(String token) {
        UserRedis userRedis = new UserRedis();
        String username = token.split("_")[1];
        userRedis.setUsername(username);
        GetByUserAccount user = humanAreaService.getByUserAccount(username);
        if (null != user) {
            userRedis.setRealname(user.getUserName());
            userRedis.setPoscode(user.getPosCode());
            userRedis.setPosname(user.getPosName());
            userRedis.setOrgcode(user.getOrgCode());
            userRedis.setOrgname(user.getOrgName());
            userRedis.setType(user.getType());
        }
        return userRedis;
    }

    public static String getUserToken() {
        ExcelImportUtil excelImportUtil = ExcelImportUtil.threadLocalExcelImportUtil.get();
        String sessionId = null;
        String account = null;
        if (null == excelImportUtil) {
            sessionId = HttpServletRequestUtil.getSessionId();
        } else {
            HttpServletRequest request = excelImportUtil.getRequest();
            account = excelImportUtil.getAccount();
            sessionId = request.getSession().getId();
        }
        if (StringUtils.isEmpty((String)sessionId)) {
            return null;
        }
        try {
            String username = null;
            username = null == account ? SecurityUtils.getUserAccount() : account;
            if (StringUtils.isEmpty((String)username)) {
                return null;
            }
            return "session" + sessionId + "_" + username;
        }
        catch (Exception e) {
            log.error("Nebula \u7528\u6237util", (Throwable)e);
            return null;
        }
    }
}

