/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.base.aop;

import com.biz.crm.base.util.ExcelImportUtil;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ExcelExportAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelExportAspect.class);

    @Before(value="@annotation(ExcelExport)")
    public void doBefore(JoinPoint joinPoint) {
        LOGGER.info("-----------------------------\u5bfc\u5165\u529f\u80fd\u524d\u7f6e\u53c2\u6570\u5904\u7406-----------------------------");
        ExcelImportUtil.threadLocalExcelImportUtil.remove();
        String methodName = joinPoint.getSignature().getName();
        if (!"exportProcess".equals(methodName)) {
            LOGGER.info("\u58f0\u660e\u5b9a\u4e49\u9519\u8bef\uff0c\u8bf7\u5728\u5bfc\u5165\u529f\u80fd\u7684 process() \u65b9\u6cd5\u4e0a\u4f7f\u7528 @ExcelExport \u8fdb\u884c\u58f0\u660e\u3002 ");
            return;
        }
        Object[] params = joinPoint.getArgs();
        if (ArrayUtils.isEmpty((Object[])params)) {
            LOGGER.info("\u65b9\u6cd5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u65b9\u6cd5\u53c2\u6570");
            return;
        }
        Map mapParams = (Map)params[4];
        HttpServletRequest request = (HttpServletRequest)mapParams.get("request");
        ExcelImportUtil excelImportUtil = new ExcelImportUtil();
        excelImportUtil.setAccount(String.valueOf(mapParams.get("account")));
        excelImportUtil.setRequest(request);
        ExcelImportUtil.threadLocalExcelImportUtil.set(excelImportUtil);
        LOGGER.info("-----------------------------\u5bfc\u5165\u529f\u80fd\u524d\u7f6e\u53c2\u6570\u5904\u7406\u5b8c\u6210-----------------------------");
    }
}

